/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.helper.cluster.NestedValueMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;

class SgConfigUpdater {
    private static final Logger log = LogManager.getLogger(SgConfigUpdater.class);

    SgConfigUpdater() {
    }

    static void updateSgConfig(Supplier<Client> adminCertClientSupplier, CType<?> configType, String key, Map<String, Object> value) {
        try {
            DocWriteResponse response;
            Client client = adminCertClientSupplier.get();
            log.info("Updating config {}.{}:{}", configType, (Object)key, value);
            GetResponse getResponse = (GetResponse)client.get(new GetRequest("searchguard", configType.toLCString())).actionGet();
            String jsonDoc = new String(Base64.getDecoder().decode(String.valueOf(getResponse.getSource().get(configType.toLCString()))));
            NestedValueMap config = NestedValueMap.fromJsonString(jsonDoc);
            config.put(key, value);
            if (log.isTraceEnabled()) {
                log.trace("Updated config: " + config);
            }
            if ((response = (DocWriteResponse)client.index(((IndexRequest)new IndexRequest("searchguard").id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType.toLCString(), BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(config.toJsonString().getBytes("utf-8")))})).actionGet()).getResult() != DocWriteResponse.Result.UPDATED) {
                throw new RuntimeException("Updated failed " + response);
            }
            ConfigUpdateResponse configUpdateResponse = (ConfigUpdateResponse)client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]))).actionGet();
            if (configUpdateResponse.hasFailures()) {
                throw new RuntimeException("ConfigUpdateResponse produced failures: " + configUpdateResponse.failures());
            }
        }
        catch (DocumentParseException | UnexpectedDocumentStructureException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

