/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class SimpleRestHandler<Request extends ActionRequest, Response extends ActionResponse>
extends BaseRestHandler {
    private String name;
    private RestHandler.Route route;
    private Function<RestRequest, Request> requestFactory;
    private ActionType<Response> actionType;

    public SimpleRestHandler(RestHandler.Route route, ActionType<Response> actionType, Function<RestRequest, Request> requestFactory) {
        this.route = route;
        this.name = route.getMethod() + " " + route.getPath();
        this.actionType = actionType;
        this.requestFactory = requestFactory;
    }

    public String getName() {
        return this.name;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(this.route);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        for (String param : request.params().keySet()) {
            request.param(param);
        }
        request.content();
        return channel -> client.execute(this.actionType, (ActionRequest)this.requestFactory.apply(request), (ActionListener)new RestToXContentListener(channel));
    }
}

