/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Map;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class BulkTests {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().user("bulk_test_user", "secret", new TestSgConfig.Role("bulk_test_user_role").clusterPermissions("*").indexPermissions("*").on("test")).build();

    @Test
    public void testBulk() throws Exception {
        try (RestHighLevelClient client = cluster.getRestHighLevelClient("bulk_test_user", "secret");){
            BulkRequest.Builder br = new BulkRequest.Builder();
            br.refresh(Refresh.True);
            br.operations((BulkOperation)new BulkOperation.Builder().index(((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().document(Map.of("a", "b")).index("test")).id("1")).build()).build(), new BulkOperation[]{(BulkOperation)new BulkOperation.Builder().index(((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().document(Map.of("a", "b")).index("myindex")).id("1")).build()).build()});
            BulkResponse res = client.getJavaClient().bulk(br.build());
            Assert.assertTrue((boolean)res.errors());
            Assert.assertEquals((long)2L, (long)res.items().size());
            Assert.assertTrue((((BulkResponseItem)res.items().get(0)).error() == null ? 1 : 0) != 0);
            Assert.assertFalse((((BulkResponseItem)res.items().get(1)).error() == null ? 1 : 0) != 0);
        }
    }
}

