/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.MultiTenancyChecker;
import java.util.Optional;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiTenancyCheckerTest {
    @Mock
    private MultiTenancyChecker.IndexRepository repository;
    private MultiTenancyChecker checker;

    @Before
    public void before() {
        this.checker = new MultiTenancyChecker(Settings.builder().put("searchguard.multi_tenancy_bootstrap_check_enabled", true).build(), this.repository);
    }

    @Test
    public void shouldReportErrorWhenMultiTenancyIndicesArePresent() {
        ImmutableMap indices = ImmutableMap.of((Object)".kibana_-152937574_admintenant_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_3_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indices);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotReportErrorWhenMultiTenancyIndicesArePresentAndBootstrapChecksAreExplicitelyDisabled() {
        Settings settings = Settings.builder().put("searchguard.multi_tenancy_bootstrap_check_enabled", false).build();
        ImmutableMap indices = ImmutableMap.of((Object)".kibana_-152937574_admintenant_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_3_0));
        this.checker = new MultiTenancyChecker(settings, this.repository);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReportErrorWhenOnlyOneMultiTenancyRelatedIndexExist() {
        ImmutableMap indices = ImmutableMap.of((Object)"data_index_1", (Object)this.mockMetadata(IndexVersions.V_8_5_0), (Object)"data_index_2", (Object)this.mockMetadata(IndexVersions.V_8_1_0), (Object)"logs_2023", (Object)this.mockMetadata(IndexVersions.V_8_2_0), (Object)".kibana_92668751_admin_8.7.12_100", (Object)this.mockMetadata(IndexVersions.V_8_3_0)).with((Object)"logs_2024", (Object)this.mockMetadata(IndexVersions.V_8_4_0)).with((Object)"logs_2024_01_01", (Object)this.mockMetadata(IndexVersions.V_8_6_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indices);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReportErrorWhenManyMultiTenancyRelatedIndexExist() {
        ImmutableMap indices = ImmutableMap.of((Object)"data_index_1", (Object)this.mockMetadata(IndexVersions.V_8_5_0), (Object)"data_index_2", (Object)this.mockMetadata(IndexVersions.V_8_1_0), (Object)"logs_2023", (Object)this.mockMetadata(IndexVersions.V_8_2_0), (Object)".kibana_92668751_admin_8.7.12_100", (Object)this.mockMetadata(IndexVersions.V_8_3_0)).with((Object)"logs_2024", (Object)this.mockMetadata(IndexVersions.V_8_4_0)).with((Object)".kibana_-152937574_admintenant_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_5_0)).with((Object)".kibana_1329513022_ittenant_8.7.0_002", (Object)this.mockMetadata(IndexVersions.V_8_6_0)).with((Object)"logs_2024_01_01", (Object)this.mockMetadata(IndexVersions.V_8_6_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indices);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotReportErrorWhenManyMultiTenancyRelatedIndexExistButWasCreatedInVersion8_8_0() {
        ImmutableMap indices = ImmutableMap.of((Object)"data_index_1", (Object)this.mockMetadata(IndexVersions.V_8_5_0), (Object)"data_index_2", (Object)this.mockMetadata(IndexVersions.V_8_1_0), (Object)"logs_2023", (Object)this.mockMetadata(IndexVersions.V_8_2_0), (Object)".kibana_92668751_admin_8.7.12_100", (Object)this.mockMetadata(IndexVersions.V_8_8_0)).with((Object)"logs_2024", (Object)this.mockMetadata(IndexVersions.V_8_4_0)).with((Object)".kibana_-152937574_admintenant_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_8_0)).with((Object)".kibana_1329513022_ittenant_8.7.0_002", (Object)this.mockMetadata(IndexVersions.V_8_8_0)).with((Object)"logs_2024_01_01", (Object)this.mockMetadata(IndexVersions.V_8_6_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indices);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReportErrorWhenOneMultiTenancyRelatedIndexExistAndWasCreatedInVersionPriorTo8_8_0() {
        ImmutableMap indices = ImmutableMap.of((Object)"data_index_1", (Object)this.mockMetadata(IndexVersions.V_8_5_0), (Object)"data_index_2", (Object)this.mockMetadata(IndexVersions.V_8_1_0), (Object)"logs_2023", (Object)this.mockMetadata(IndexVersions.V_8_2_0), (Object)".kibana_92668751_admin_8.7.12_100", (Object)this.mockMetadata(IndexVersions.V_8_8_0)).with((Object)"logs_2024", (Object)this.mockMetadata(IndexVersions.V_8_4_0)).with((Object)".kibana_-152937574_admintenant_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_7_0)).with((Object)".kibana_1329513022_ittenant_8.7.0_002", (Object)this.mockMetadata(IndexVersions.V_8_8_0)).with((Object)"logs_2024_01_01", (Object)this.mockMetadata(IndexVersions.V_8_6_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indices);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldDisableCheckingOfMultiTenancyRelatedIndices() {
        Settings settings = Settings.builder().put("searchguard.multi_tenancy_bootstrap_check_enabled", false).build();
        this.checker = new MultiTenancyChecker(settings, this.repository);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)false));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.repository});
    }

    @Test
    public void shouldNotReportErrorWhenMainKibanaIndexExist_1() {
        ImmutableMap indexMetadata = ImmutableMap.of((Object)".kibana_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_8_1_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indexMetadata);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotReportErrorWhenMainKibanaIndexExist_2() {
        ImmutableMap indexMetadata = ImmutableMap.of((Object)".kibana_7.17.12_001", (Object)this.mockMetadata(IndexVersions.V_7_0_0), (Object)".kibana_8.8.0_001", (Object)this.mockMetadata(IndexVersions.V_8_7_0));
        Mockito.when((Object)this.repository.findIndicesMetadata()).thenReturn((Object)indexMetadata);
        Optional errorDescription = this.checker.findMultiTenancyConfigurationError();
        MatcherAssert.assertThat((Object)errorDescription.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    private IndexMetadata mockMetadata(IndexVersion version) {
        IndexMetadata mock = (IndexMetadata)Mockito.mock(IndexMetadata.class);
        Mockito.when((Object)mock.getCreationVersion()).thenReturn((Object)version);
        return mock;
    }
}

