/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class AuthcCacheApiTest {
    private static final TestSgConfig.User[] USERS = new TestSgConfig.User[5];
    @ClassRule
    public static LocalCluster cluster;

    @Test
    public void testClearCache() throws Exception {
        for (int i = 0; i < USERS.length; ++i) {
            GenericRestClient client = cluster.getRestClient(USERS[i].getName(), USERS[i].getPassword(), new Header[0]);
            GenericRestClient.HttpResponse response = client.get("/_searchguard/component/rest_filter/_health", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((long)(i + 1), (long)this.getUserCacheSizeFromResponse(response));
        }
        GenericRestClient client = cluster.getRestClient(USERS[0].getName(), USERS[0].getPassword(), new Header[0]);
        GenericRestClient.HttpResponse response = client.delete("/_searchguard/authc/cache", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = client.get("/_searchguard/component/rest_filter/_health", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((long)1L, (long)this.getUserCacheSizeFromResponse(response));
    }

    private int getUserCacheSizeFromResponse(GenericRestClient.HttpResponse response) throws DocumentParseException, Format.UnknownDocTypeException, NullPointerException {
        AtomicInteger size = new AtomicInteger();
        ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("components").get(0)).getAsListOfNodes("parts").forEach(docNode -> size.addAndGet((Integer)((DocNode)docNode.getAsListOfNodes("parts").stream().filter(docNode1 -> docNode1.get("name").equals("rest_authentication_processor")).findFirst().orElse(null)).getAsNode("metrics").getAsNode("user_cache").getAsNode("cache").get("current_size")));
        return size.get();
    }

    static {
        for (int i = 0; i < USERS.length; ++i) {
            AuthcCacheApiTest.USERS[i] = new TestSgConfig.User("admin_" + i).password("pw").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
        }
        cluster = new LocalCluster.Builder().sslEnabled().users(USERS).build();
    }
}

