/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.searchguard.authc.session.TestApiAuthenticationFrontend;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.BearerAuthorization;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.io.BaseEncoding;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class SessionLongRunningIntegrationTest {
    private static final Logger log = LogManager.getLogger(SessionLongRunningIntegrationTest.class);
    static final Duration TIMEOUT = Duration.ofSeconds(60L);
    static TestSgConfig.User BASIC_USER = new TestSgConfig.User("basic_user").roles("sg_all_access");
    static TestSgConfig.User NO_ROLES_USER = new TestSgConfig.User("no_roles_user");
    static TestSgConfig.Sessions SESSIONS = new TestSgConfig.Sessions().inactivityTimeout(TIMEOUT).refreshSessionActivityIndex(true);
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db"));
    static TestSgConfig TEST_SG_CONFIG = new TestSgConfig().resources("session").authc(AUTHC).frontendAuthc("default", new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("basic").label("Basic Login"))).frontendAuthc("test_fe", new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain(TestApiAuthenticationFrontend.class.getName()).label("Test Login"))).user(NO_ROLES_USER).user(BASIC_USER).sessions(SESSIONS);
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().resources("session").sgConfig(TEST_SG_CONFIG).sslEnabled().build();

    @Ignore
    @Test
    public void singleUser() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRandomClientNode().getRestClient(new Header[0]);){
            response = client.postJson("/_searchguard/auth/session", SessionLongRunningIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            token = response.getBodyAsDocNode().getAsString("token");
        }
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(cluster.getRandom().nextInt((int)TIMEOUT.toMillis() - 2000) + 100);
            try (GenericRestClient restClient = cluster.getRandomClientNode().getRestClient(new Header[]{new BearerAuthorization(token)});){
                GenericRestClient.HttpResponse response2 = restClient.get("/_searchguard/authinfo", new Header[0]);
                Assert.assertEquals((String)response2.getBody(), (long)200L, (long)response2.getStatusCode());
                Assert.assertEquals((String)response2.getBody(), (Object)BASIC_USER.getName(), (Object)response2.getBodyAsDocNode().getAsString("user_name"));
                continue;
            }
        }
        Thread.sleep((int)TIMEOUT.toMillis() + 1000);
        try (GenericRestClient restClient = cluster.getRandomClientNode().getRestClient(new Header[]{new BearerAuthorization(token)});){
            response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
    }

    @Ignore(value="unsuitable for normal CI due to their run time")
    @Test
    public void multi() throws Exception {
        int sessions = 20;
        Duration testDuration = Duration.ofMinutes(30L);
        long endTime = System.currentTimeMillis() + testDuration.toMillis();
        HashMap<String, Instant> sessionTokenToTimeoutMap = new HashMap<String, Instant>();
        TreeMap<Long, String> scheduledAccess = new TreeMap<Long, String>();
        while (System.currentTimeMillis() < endTime) {
            while (sessionTokenToTimeoutMap.size() < sessions) {
                GenericRestClient client = cluster.getRandomClientNode().getRestClient(new Header[0]);
                try {
                    GenericRestClient.HttpResponse response = client.postJson("/_searchguard/auth/session", SessionLongRunningIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[0]);
                    Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                    String token = response.getBodyAsDocNode().getAsString("token");
                    Instant timeout = Instant.now().plus(TIMEOUT);
                    log.info("### Created new session " + this.getSessionId(token) + " :\n" + response.getBody());
                    sessionTokenToTimeoutMap.put(token, timeout);
                    this.scheduleRandomAccess(token, timeout, scheduledAccess);
                    Thread.sleep(cluster.getRandom().nextInt(1000) + 10);
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            Map.Entry nextAccess = scheduledAccess.firstEntry();
            scheduledAccess.remove(nextAccess.getKey());
            long sleepTime = (Long)nextAccess.getKey() - System.currentTimeMillis();
            log.debug("Sleeping " + sleepTime + " ms");
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
            String sessionToken = (String)nextAccess.getValue();
            Instant sessionTimeout = (Instant)sessionTokenToTimeoutMap.get(sessionToken);
            GenericRestClient restClient = cluster.getRandomClientNode().getRestClient(new Header[]{new BearerAuthorization(sessionToken)});
            try {
                GenericRestClient.HttpResponse response = restClient.get("/_searchguard/authinfo", new Header[0]);
                if (response.getStatusCode() == 200) {
                    log.info("___ Session used: " + this.getSessionId(sessionToken) + " " + sessionTimeout);
                } else {
                    log.warn("@@@ Session expired: " + this.getSessionId(sessionToken) + " " + sessionTimeout);
                }
                if (sessionTimeout.isBefore(Instant.ofEpochMilli(System.currentTimeMillis() - 1000L))) {
                    Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
                    sessionTokenToTimeoutMap.remove(sessionToken);
                    continue;
                }
                if (sessionTimeout.isAfter(Instant.ofEpochMilli(System.currentTimeMillis() + 1000L))) {
                    Assert.assertEquals((String)("Session was expired " + Instant.now() + " while it was expected to expire at " + sessionTimeout), (long)200L, (long)response.getStatusCode());
                    Assert.assertEquals((String)response.getBody(), (Object)BASIC_USER.getName(), (Object)response.getBodyAsDocNode().getAsString("user_name"));
                    sessionTimeout = Instant.now().plus(TIMEOUT);
                    sessionTokenToTimeoutMap.put(sessionToken, sessionTimeout);
                    this.scheduleRandomAccess(sessionToken, sessionTimeout, scheduledAccess);
                    continue;
                }
                if (sessionTimeout.isAfter(Instant.now())) {
                    log.info("Access briefly before timeout: " + response.getStatusCode());
                } else {
                    log.info("Access briefly after timeout: " + response.getStatusCode());
                }
                sessionTokenToTimeoutMap.remove(sessionToken);
            }
            finally {
                if (restClient == null) continue;
                restClient.close();
            }
        }
    }

    private static Map<String, Object> basicAuthRequest(TestSgConfig.User user, Object ... additionalAttrs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("mode", "basic");
        result.put("user", user.getName());
        result.put("password", user.getPassword());
        if (additionalAttrs != null && additionalAttrs.length > 0) {
            for (int i = 0; i < additionalAttrs.length; i += 2) {
                result.put(additionalAttrs[i].toString(), additionalAttrs[i + 1]);
            }
        }
        return result;
    }

    private void scheduleRandomAccess(String session, Instant timeout, SortedMap<Long, String> scheduledAccess) {
        if ((double)cluster.getRandom().nextFloat() < 0.2) {
            long nextAccess = timeout.toEpochMilli() + (long)cluster.getRandom().nextInt(5000) + 1000L;
            while (scheduledAccess.containsKey(nextAccess)) {
                ++nextAccess;
            }
            scheduledAccess.put(nextAccess, session);
        } else {
            long timeSpan = timeout.toEpochMilli() - 1000L - System.currentTimeMillis();
            if (timeSpan <= 0L) {
                timeSpan = 100L;
            }
            long nextAccess = Math.round(cluster.getRandom().nextDouble() * (double)timeSpan) + System.currentTimeMillis();
            while (scheduledAccess.containsKey(nextAccess)) {
                ++nextAccess;
            }
            scheduledAccess.put(nextAccess, session);
        }
    }

    private String getSessionId(String sessionToken) throws DocumentParseException, UnexpectedDocumentStructureException {
        String[] parts = sessionToken.split("\\.");
        String payloadBase64 = parts[1];
        Map payload = DocReader.json().readObject(BaseEncoding.base64Url().decode((CharSequence)payloadBase64));
        return String.valueOf(payload.get("jti"));
    }
}

