/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.meta.Meta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={ClusterPermissions.class, IndexPermissions.class, IndexPermissionsSpecial.class, AliasPermissions.class, AliasPermissionsSpecial.class, DataStreamPermissions.class})
public class RoleBasedActionAuthorizationTests {
    private static final Actions actions = new Actions(null);
    private static final ByteSizeValue STATEFUL_SIZE = new ByteSizeValue(10L, ByteSizeUnit.MB);

    private static PrivilegesEvaluationContext ctx(User user, String ... roles) {
        return new PrivilegesEvaluationContext(user, false, ImmutableSet.ofArray((Object[])roles), null, (Object)roles, true, null, null);
    }

    static enum Statefulness {
        STATEFUL,
        NON_STATEFUL;

    }

    static class ActionSpec {
        String name;
        ImmutableList<String> givenPrivs;
        ImmutableSet<Action> requiredPrivs;
        Action primaryAction;
        boolean wellKnownActions;

        ActionSpec(String name) {
            this.name = name;
        }

        ActionSpec givenPrivs(String ... actions) {
            this.givenPrivs = ImmutableList.ofArray((Object[])actions);
            return this;
        }

        ActionSpec requiredPrivs(String ... requiredPrivs) {
            this.requiredPrivs = ImmutableSet.ofArray((Object[])requiredPrivs).map(a -> actions.get(a));
            this.primaryAction = actions.get(requiredPrivs[0]);
            this.wellKnownActions = this.requiredPrivs.forAnyApplies(a -> a instanceof Action.WellKnownAction);
            return this;
        }

        public String toString() {
            return this.name;
        }
    }

    static class IndexSpec {
        ImmutableList<String> givenIndexPrivs = ImmutableList.empty();
        ImmutableList<String> givenAliasPrivs = ImmutableList.empty();
        ImmutableList<String> givenDataStreamPrivs = ImmutableList.empty();
        boolean wildcardPrivs;
        boolean aliasWildcardPrivs;
        boolean dataStreamWildcardPrivs;

        IndexSpec() {
        }

        IndexSpec givenIndexPrivs(String ... indexPatterns) {
            this.givenIndexPrivs = ImmutableList.ofArray((Object[])indexPatterns);
            this.wildcardPrivs = this.givenIndexPrivs.contains((Object)"*");
            return this;
        }

        IndexSpec givenAliasPrivs(String ... aliasPatterns) {
            this.givenAliasPrivs = ImmutableList.ofArray((Object[])aliasPatterns);
            this.aliasWildcardPrivs = this.givenAliasPrivs.contains((Object)"*");
            return this;
        }

        IndexSpec givenDataStreamPrivs(String ... dataStreamPatterns) {
            this.givenDataStreamPrivs = ImmutableList.ofArray((Object[])dataStreamPatterns);
            this.dataStreamWildcardPrivs = this.givenDataStreamPrivs.contains((Object)"*");
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (!this.givenIndexPrivs.isEmpty()) {
                result.append("indices: ").append(this.givenIndexPrivs.stream().collect(Collectors.joining(",")));
            }
            if (!this.givenAliasPrivs.isEmpty()) {
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append("aliases: ").append(this.givenAliasPrivs.stream().collect(Collectors.joining(",")));
            }
            if (!this.givenDataStreamPrivs.isEmpty()) {
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append("data_streams: ").append(this.givenDataStreamPrivs.stream().collect(Collectors.joining(",")));
            }
            return result.toString();
        }

        public SgDynamicConfiguration<Role> toRolesConfig(ActionSpec actionSpec) {
            try {
                return (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"test_role", (Object)DocNode.of((String)"index_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"index_patterns", this.givenIndexPrivs, (String)"allowed_actions", actionSpec.givenPrivs)}), (String)"alias_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"alias_patterns", this.givenAliasPrivs, (String)"allowed_actions", actionSpec.givenPrivs)}), (String)"data_stream_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"data_stream_patterns", this.givenDataStreamPrivs, (String)"allowed_actions", actionSpec.givenPrivs)}))), (CType)CType.ROLES, null).get();
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class DataStreamPermissions {
        final ActionSpec actionSpec;
        final IndexSpec indexSpec;
        final SgDynamicConfiguration<Role> roles;
        final Action primaryAction;
        final ImmutableSet<Action> requiredActions;
        final ImmutableSet<Action> otherActions;
        final RoleBasedActionAuthorization subject;
        final User user = User.forUser((String)"test").attribute("dept_no", (Object)"a1").build();
        static final Meta BASIC = Meta.Mock.dataStream((String)"datastream_a1").of(new String[]{".ds-datastream_a1-xyz-0001", ".ds-datastream_a1-xyz-0002"}).dataStream("datastream_a2").of(new String[]{".ds-datastream_a2-xyz-0001", ".ds-datastream_a2-xyz-0002"}).dataStream("datastream_b1").of(new String[]{".ds-datastream_b1-xyz-0001", ".ds-datastream_b1-xyz-0002"}).dataStream("datastream_b2").of(new String[]{".ds-datastream_b2-xyz-0001", ".ds-datastream_b2-xyz-0002"}).alias("datastream_a").of(new String[]{"datastream_a1", "datastream_a2"});

        @Test
        public void positive_datastream_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a1"}), Action.Scope.INDEX_LIKE);
            if (!this.indexSpec.givenDataStreamPrivs.isEmpty() || this.indexSpec.dataStreamWildcardPrivs || this.indexSpec.aliasWildcardPrivs || this.indexSpec.givenAliasPrivs.contains((Object)"datastream_a")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001", (Object)".ds-datastream_a1-xyz-0002")));
            }
        }

        @Test
        public void positive_index_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{".ds-datastream_a1-xyz-0002"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
        }

        @Test
        public void positive_alias_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a"}), Action.Scope.INDEX_LIKE);
            if (this.indexSpec.aliasWildcardPrivs || this.indexSpec.givenAliasPrivs.contains((Object)"datastream_a")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if (this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_a1") || this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_${user.attrs.dept_no}") || this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_a*") && this.indexSpec.givenDataStreamPrivs.contains((Object)"-datastream_a2")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"datastream_a1")));
            } else if (this.indexSpec.dataStreamWildcardPrivs || this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_a*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"datastream_a1", (Object)"datastream_a2")));
            } else if (this.indexSpec.givenIndexPrivs.contains((Object)".ds-datastream_a1*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001", (Object)".ds-datastream_a1-xyz-0002")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001", (Object[])new String[]{".ds-datastream_a1-xyz-0002", ".ds-datastream_a2-xyz-0001", ".ds-datastream_a2-xyz-0002"})));
            }
        }

        @Test
        public void positive_datastream_partial() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a1", "datastream_a2", "datastream_b1"}), Action.Scope.INDEX_LIKE);
            if (this.indexSpec.dataStreamWildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if (this.indexSpec.wildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001", (Object[])new String[]{".ds-datastream_a1-xyz-0002", ".ds-datastream_a2-xyz-0001", ".ds-datastream_a2-xyz-0002", ".ds-datastream_b1-xyz-0001", ".ds-datastream_b1-xyz-0002"})));
            } else if (this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_a*") && this.indexSpec.givenDataStreamPrivs.contains((Object)"-datastream_a2")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"datastream_a1")));
            } else if (this.indexSpec.givenDataStreamPrivs.contains((Object)"datastream_a*") || this.indexSpec.aliasWildcardPrivs || this.indexSpec.givenAliasPrivs.contains((Object)"datastream_a")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"datastream_a1", (Object)"datastream_a2")));
            } else if (this.indexSpec.givenIndexPrivs.contains((Object)".ds-datastream_a1*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001", (Object)".ds-datastream_a1-xyz-0002")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"datastream_a1")));
            }
        }

        @Test
        public void positive_index_partial() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{".ds-datastream_a1-xyz-0001", ".ds-datastream_b1-xyz-0001"}), Action.Scope.INDEX_LIKE);
            if (this.indexSpec.wildcardPrivs || this.indexSpec.dataStreamWildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)".ds-datastream_a1-xyz-0001")));
            }
        }

        @Test
        public void negative_wrongRole() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongRole_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"datastream_a"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Parameterized.Parameters(name="{0};  actions: {1};  {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (IndexSpec indexSpec : Arrays.asList(new IndexSpec().givenIndexPrivs("*"), new IndexSpec().givenAliasPrivs("*"), new IndexSpec().givenDataStreamPrivs("*"), new IndexSpec().givenDataStreamPrivs("datastream_a1"), new IndexSpec().givenDataStreamPrivs("datastream_a*"), new IndexSpec().givenDataStreamPrivs("datastream_${user.attrs.dept_no}"), new IndexSpec().givenDataStreamPrivs("datastream_a*", "-datastream_a2"), new IndexSpec().givenAliasPrivs("datastream_a"), new IndexSpec().givenIndexPrivs(".ds-datastream_a1*"))) {
                for (ActionSpec actionSpec : Arrays.asList(new ActionSpec("constant, well known").givenPrivs("indices:data/read/search").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known, two required privs").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search", "indices:data/read/get"), new ActionSpec("constant, non well known").givenPrivs("indices:unknown/unwell").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known, two required privs").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell", "indices:unknown/notatall"))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{indexSpec, actionSpec, statefulness});
                    }
                }
            }
            return result;
        }

        public DataStreamPermissions(IndexSpec indexSpec, ActionSpec actionSpec, Statefulness statefulness) throws Exception {
            this.indexSpec = indexSpec;
            this.actionSpec = actionSpec;
            this.roles = indexSpec.toRolesConfig(actionSpec);
            this.primaryAction = actionSpec.primaryAction;
            this.requiredActions = actionSpec.requiredPrivs;
            this.otherActions = actionSpec.wellKnownActions ? ImmutableSet.of((Object)actions.get("indices:data/write/update")) : ImmutableSet.of((Object)actions.get("indices:foobar/unknown"));
            this.subject = new RoleBasedActionAuthorization(this.roles, ActionGroup.FlattenedIndex.EMPTY, actions, (Meta)(statefulness == Statefulness.STATEFUL ? BASIC : null), (Set)ImmutableSet.empty(), STATEFUL_SIZE);
        }
    }

    public static class AliasPermissionsSpecial {
        @Test
        public void wellKnown_constantAction_constantAlias_statefulIndices() throws Exception {
            Action indexAction = actions.get("indices:data/write/index");
            Assert.assertTrue((String)indexAction.toString(), (boolean)(indexAction instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("test_role:\n  alias_permissions:\n  - alias_patterns: ['alias_constant_a']\n    allowed_actions: ['indices:data/write/index']"), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            Meta indexMetadata = Meta.Mock.indices((String[])new String[]{"index_a1", "index_a2", "index_b1", "index_b2"}).alias("alias_constant_a").of(new String[]{"index_a1", "index_a2"});
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, indexMetadata, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            ResolvedIndices aliasConstantA = ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_constant_a"});
            PrivilegesEvaluationResult result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), aliasConstantA);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            ResolvedIndices indexA1 = ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"index_a1"});
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), indexA1, Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_constant_a", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_constant_a")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"index_a1", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a1")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "other_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_constant_a", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void wellKnown_constantAction_indexPattern_statefulIndices() throws Exception {
            Action indexAction = actions.get("indices:data/read/search");
            Assert.assertTrue((String)indexAction.toString(), (boolean)(indexAction instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("test_role:\n  alias_permissions:\n  - alias_patterns: ['alias_a*']\n    allowed_actions: ['indices:data/read/search']"), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            Meta indexMetadata = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).alias("alias_a1").of(new String[]{"index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, indexMetadata, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            ResolvedIndices aliasA1 = ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_a1"});
            PrivilegesEvaluationResult result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), aliasA1, Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            ResolvedIndices indexA1 = ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"index_a11"});
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), indexA1, Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_a1", "alias_b"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_a1")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_a1", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_a1")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"index_a11", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "other_role"), indexAction, ImmutableSet.of((Object)indexAction), ResolvedIndices.of((Meta)indexMetadata, (String[])new String[]{"alias_a1", "index_b1"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class AliasPermissions {
        final ActionSpec actionSpec;
        final IndexSpec indexSpec;
        final SgDynamicConfiguration<Role> roles;
        final Action primaryAction;
        final ImmutableSet<Action> requiredActions;
        final ImmutableSet<Action> otherActions;
        final RoleBasedActionAuthorization subject;
        final User user = User.forUser((String)"test").attribute("dept_no", (Object)"a1").build();
        static final Meta BASIC = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).alias("alias_a").of(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"}).alias("alias_a1").of(new String[]{"index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});

        @Test
        public void positive_alias_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            if (!this.indexSpec.givenAliasPrivs.isEmpty()) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if (this.indexSpec.wildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11", (Object)"index_a12")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            }
        }

        @Test
        public void positive_index_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
        }

        @Test
        public void positive_alias_partial() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1", "alias_a2", "alias_b"}));
            if (this.indexSpec.aliasWildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if (this.indexSpec.wildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_b1", (Object[])new String[]{"index_b2", "index_a12", "index_a11", "index_a22", "index_a21"})));
            } else if (this.indexSpec.givenAliasPrivs.contains((Object)"alias_a*") && this.indexSpec.givenAliasPrivs.contains((Object)"-alias_a2")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_a1")));
            } else if (this.indexSpec.givenAliasPrivs.contains((Object)"alias_a*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_a1", (Object)"alias_a2")));
            } else if (this.indexSpec.givenAliasPrivs.isEmpty() && this.indexSpec.givenIndexPrivs.equals((Object)ImmutableList.of((Object)"index_a11"))) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"alias_a1")));
            }
        }

        @Test
        public void positive_index_partial() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11", "index_a12", "index_a21", "index_b1"}), Action.Scope.INDEX_LIKE);
            if (this.indexSpec.wildcardPrivs || this.indexSpec.aliasWildcardPrivs) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if (this.indexSpec.givenAliasPrivs.contains((Object)"alias_a*") && !this.indexSpec.givenAliasPrivs.contains((Object)"-alias_a")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11", (Object[])new String[]{"index_a12", "index_a21"})));
            } else if (this.indexSpec.givenAliasPrivs.isEmpty() && this.indexSpec.givenIndexPrivs.equals((Object)ImmutableList.of((Object)"index_a11"))) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11", (Object)"index_a12")));
            }
        }

        @Test
        public void negative_wrongRole() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongRole_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Parameterized.Parameters(name="{0};  actions: {1};  {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (IndexSpec indexSpec : Arrays.asList(new IndexSpec().givenIndexPrivs("*"), new IndexSpec().givenAliasPrivs("*"), new IndexSpec().givenAliasPrivs("alias_a1"), new IndexSpec().givenAliasPrivs("alias_a*"), new IndexSpec().givenAliasPrivs("alias_${user.attrs.dept_no}"), new IndexSpec().givenAliasPrivs("alias_a*", "-alias_a2", "-alias_a"), new IndexSpec().givenIndexPrivs("index_a11"))) {
                for (ActionSpec actionSpec : Arrays.asList(new ActionSpec("constant, well known").givenPrivs("indices:data/read/search").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known, two required privs").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search", "indices:data/read/get"), new ActionSpec("constant, non well known").givenPrivs("indices:unknown/unwell").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known, two required privs").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell", "indices:unknown/notatall"))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{indexSpec, actionSpec, statefulness});
                    }
                }
            }
            return result;
        }

        public AliasPermissions(IndexSpec indexSpec, ActionSpec actionSpec, Statefulness statefulness) throws Exception {
            this.indexSpec = indexSpec;
            this.actionSpec = actionSpec;
            this.roles = indexSpec.toRolesConfig(actionSpec);
            this.primaryAction = actionSpec.primaryAction;
            this.requiredActions = actionSpec.requiredPrivs;
            this.otherActions = actionSpec.wellKnownActions ? ImmutableSet.of((Object)actions.get("indices:data/write/update")) : ImmutableSet.of((Object)actions.get("indices:foobar/unknown"));
            this.subject = new RoleBasedActionAuthorization(this.roles, ActionGroup.FlattenedIndex.EMPTY, actions, (Meta)(statefulness == Statefulness.STATEFUL ? BASIC : null), (Set)ImmutableSet.empty(), STATEFUL_SIZE);
        }
    }

    public static class IndexPermissionsSpecial {
        static final Meta BASIC = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).alias("alias_a").of(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"}).alias("alias_a1").of(new String[]{"index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});

        @Test
        public void indexAction_wellKnown_constantAction_indexTemplate() throws Exception {
            ImmutableSet indexAction = ImmutableSet.of((Object)actions.get("indices:data/read/search"));
            ImmutableSet otherAction = ImmutableSet.of((Object)actions.get("indices:data/read/get"));
            Assert.assertTrue((String)indexAction.toString(), (boolean)(indexAction.only() instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("test_role:\n  index_permissions:\n  - index_patterns: ['index_${user.attrs.dept_no}']\n    allowed_actions: ['indices:data/read/search']"), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, null, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").attribute("dept_no", (Object)"a11").build();
            PrivilegesEvaluationResult result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), (Action)indexAction.only(), indexAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), (Action)indexAction.only(), indexAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11", "index_a12"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), (Action)indexAction.only(), indexAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "other_role"), (Action)indexAction.only(), indexAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), (Action)indexAction.only(), otherAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
            User userWithoutAttributes = User.forUser((String)"no_attributes").build();
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(userWithoutAttributes, "test_role"), (Action)indexAction.only(), indexAction, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}));
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getErrors().toString().contains("No value for ${user.attrs.dept_no}"));
        }

        @Test
        public void indexAction_twoRequiredPrivileges_actionPattern_indexPattern() throws Exception {
            Action indexAction = actions.get("indices:data/write/index");
            Action indexActionNotWellKnown = actions.get("indices:data/write/index/notWellKnown");
            Assert.assertTrue((String)indexAction.toString(), (boolean)(indexAction instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("test_role1:\n  index_permissions:\n  - index_patterns: ['index_a*']\n    allowed_actions: ['indices:data/write/index']\ntest_role2:\n  index_permissions:\n  - index_patterns: ['index_a1']\n    allowed_actions: ['indices:data/write/index/notWell*']\ntest_role3:\n  index_permissions:\n  - index_patterns: ['index_a2']\n    allowed_actions: ['indices:data/write/index/notWell*']\n"), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, null, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            Meta meta = Meta.Mock.indices((String[])new String[]{"index_a1", "index_a2", "index_b"});
            PrivilegesEvaluationResult result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1", "test_role2", "test_role3"), indexAction, ImmutableSet.of((Object)indexAction, (Object)indexActionNotWellKnown), ResolvedIndices.of((Meta)meta, (String[])new String[]{"index_a1", "index_a2"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1", "test_role2", "test_role3"), indexAction, ImmutableSet.of((Object)indexAction, (Object)indexActionNotWellKnown), ResolvedIndices.of((Meta)meta, (String[])new String[]{"index_a1", "index_a2", "index_b"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a1", (Object)"index_a2")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1", "test_role2"), indexAction, ImmutableSet.of((Object)indexAction, (Object)indexActionNotWellKnown), ResolvedIndices.of((Meta)meta, (String[])new String[]{"index_a1", "index_a2", "index_b"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
            Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a1")));
            result = subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role2", "test_role3"), indexAction, ImmutableSet.of((Object)indexAction, (Object)indexActionNotWellKnown), ResolvedIndices.of((Meta)meta, (String[])new String[]{"index_a1", "index_a2"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class IndexPermissions {
        final ActionSpec actionSpec;
        final IndexSpec indexSpec;
        final SgDynamicConfiguration<Role> roles;
        final Action primaryAction;
        final ImmutableSet<Action> requiredActions;
        final ImmutableSet<Action> otherActions;
        final RoleBasedActionAuthorization subject;
        final User user = User.forUser((String)"test").attribute("dept_no", (Object)"a11").build();
        static final Meta BASIC = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).alias("alias_a").of(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"}).alias("alias_a1").of(new String[]{">index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});

        @Test
        public void positive_full() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
        }

        @Test
        public void positive_partial() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11", "index_a12"}));
            if (this.indexSpec.wildcardPrivs || this.indexSpec.givenIndexPrivs.contains((Object)"index_*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if ((this.indexSpec.givenIndexPrivs.contains((Object)"index_a1*") || this.indexSpec.givenIndexPrivs.contains((Object)"/index_(?!b.*).*/")) && !this.indexSpec.givenIndexPrivs.contains((Object)"-index_a12")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            }
        }

        @Test
        public void positive_partial2() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11", "index_a12", "index_b1"}));
            if (this.indexSpec.wildcardPrivs || this.indexSpec.givenIndexPrivs.contains((Object)"index_*")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK ? 1 : 0) != 0);
            } else if ((this.indexSpec.givenIndexPrivs.contains((Object)"index_a1*") || this.indexSpec.givenIndexPrivs.contains((Object)"/index_(?!b.*).*/")) && !this.indexSpec.givenIndexPrivs.contains((Object)"-index_a12")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11", (Object)"index_a12")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            }
        }

        @Test
        public void positive_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            if ((this.indexSpec.wildcardPrivs || this.indexSpec.givenIndexPrivs.contains((Object)"index_*") || this.indexSpec.givenIndexPrivs.contains((Object)"index_a1*") || this.indexSpec.givenIndexPrivs.contains((Object)"/index_(?!b.*).*/")) && !this.indexSpec.givenIndexPrivs.contains((Object)"-index_a12")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                if (this.actionSpec.primaryAction.name().equals("indices:data/write/index")) {
                    Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
                } else {
                    Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11", (Object)"index_a12")));
                }
            } else if (this.actionSpec.primaryAction.name().equals("indices:data/write/index")) {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            } else {
                Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK ? 1 : 0) != 0);
                Assert.assertTrue((String)result.toString(), (boolean)result.getAvailableIndices().equals(ImmutableSet.of((Object)"index_a11")));
            }
        }

        @Test
        public void negative_wrongRole() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"index_a11"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongRole_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "other_role"), this.primaryAction, this.requiredActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Test
        public void negative_wrongAction_alias() throws Exception {
            PrivilegesEvaluationResult result = this.subject.hasIndexPermission(RoleBasedActionAuthorizationTests.ctx(this.user, "test_role"), (Action)this.otherActions.any(), this.otherActions, ResolvedIndices.of((Meta)BASIC, (String[])new String[]{"alias_a1"}), Action.Scope.INDEX_LIKE);
            Assert.assertTrue((String)result.toString(), (result.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT ? 1 : 0) != 0);
        }

        @Parameterized.Parameters(name="{0};  actions: {1};  {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (IndexSpec indexSpec : Arrays.asList(new IndexSpec().givenIndexPrivs("*"), new IndexSpec().givenIndexPrivs("index_*"), new IndexSpec().givenIndexPrivs("index_a11"), new IndexSpec().givenIndexPrivs("index_a1*"), new IndexSpec().givenIndexPrivs("index_${user.attrs.dept_no}"), new IndexSpec().givenIndexPrivs("index_a1*", "-index_a12"), new IndexSpec().givenIndexPrivs("index_${user.attrs.dept_no}", "-index_a12"), new IndexSpec().givenIndexPrivs("/index_(?!b.*).*/"))) {
                for (ActionSpec actionSpec : Arrays.asList(new ActionSpec("constant, well known").givenPrivs("indices:data/read/search").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search"), new ActionSpec("pattern, well known, two required privs").givenPrivs("indices:data/read/*").requiredPrivs("indices:data/read/search", "indices:data/read/get"), new ActionSpec("constant, well known, index action (uses write index of alias)").givenPrivs("indices:data/write/index").requiredPrivs("indices:data/write/index"), new ActionSpec("constant, non well known").givenPrivs("indices:unknown/unwell").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell"), new ActionSpec("pattern, non well known, two required privs").givenPrivs("indices:unknown/*").requiredPrivs("indices:unknown/unwell", "indices:unknown/notatall"))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{indexSpec, actionSpec, statefulness});
                    }
                }
            }
            return result;
        }

        public IndexPermissions(IndexSpec indexSpec, ActionSpec actionSpec, Statefulness statefulness) throws Exception {
            this.indexSpec = indexSpec;
            this.actionSpec = actionSpec;
            this.roles = indexSpec.toRolesConfig(actionSpec);
            this.primaryAction = actionSpec.primaryAction;
            this.requiredActions = actionSpec.requiredPrivs;
            this.otherActions = actionSpec.wellKnownActions ? ImmutableSet.of((Object)actions.get("indices:data/write/update")) : ImmutableSet.of((Object)actions.get("indices:foobar/unknown"));
            this.subject = new RoleBasedActionAuthorization(this.roles, ActionGroup.FlattenedIndex.EMPTY, actions, (Meta)(statefulness == Statefulness.STATEFUL ? BASIC : null), (Set)ImmutableSet.empty(), STATEFUL_SIZE);
        }
    }

    public static class ClusterPermissions {
        @Test
        public void clusterAction_wellKnown() throws Exception {
            Action nodesStatsAction = actions.get("cluster:monitor/nodes/stats");
            Action otherAction = actions.get("cluster:monitor/nodes/usage");
            Assert.assertTrue((String)nodesStatsAction.toString(), (boolean)(nodesStatsAction instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"test_role", (Object)DocNode.of((String)"cluster_permissions", Arrays.asList("cluster:monitor/nodes/stats*"))), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, null, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            Assert.assertTrue((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), nodesStatsAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "other_role"), nodesStatsAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), otherAction).isOk());
        }

        @Test
        public void clusterAction_notWellKnown() throws Exception {
            Action nodesStatsAction = actions.get("cluster:monitor/nodes/stats/somethingnotwellknown");
            Action otherAction = actions.get("cluster:monitor/nodes/usage/somethingnotwellknown");
            Assert.assertFalse((String)nodesStatsAction.toString(), (boolean)(nodesStatsAction instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"test_role", (Object)DocNode.of((String)"cluster_permissions", Arrays.asList("cluster:monitor/nodes/stats*"))), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, null, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            Assert.assertTrue((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), nodesStatsAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "other_role"), nodesStatsAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role"), otherAction).isOk());
        }

        @Test
        public void clusterAction_exclusion() throws Exception {
            Action nodesStatsAction = actions.get("cluster:monitor/nodes/stats");
            Action nodesUsageAction = actions.get("cluster:monitor/nodes/usage");
            Action nodesStatsActionNotWellKnown = actions.get("cluster:monitor/nodes/stats/not_well_known");
            Assert.assertTrue((String)nodesStatsAction.toString(), (boolean)(nodesStatsAction instanceof Action.WellKnownAction));
            Assert.assertTrue((String)nodesUsageAction.toString(), (boolean)(nodesUsageAction instanceof Action.WellKnownAction));
            Assert.assertFalse((String)nodesStatsActionNotWellKnown.toString(), (boolean)(nodesStatsActionNotWellKnown instanceof Action.WellKnownAction));
            SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("test_role1:\n  cluster_permissions:\n  - 'cluster:monitor/*'\n  exclude_cluster_permissions:\n  - 'cluster:monitor/nodes/stats*'\n"), (CType)CType.ROLES, null).get();
            ImmutableSet tenants = ImmutableSet.empty();
            RoleBasedActionAuthorization subject = new RoleBasedActionAuthorization(roles, ActionGroup.FlattenedIndex.EMPTY, actions, null, (Set)tenants, STATEFUL_SIZE);
            User user = User.forUser((String)"test").build();
            Assert.assertTrue((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1"), nodesUsageAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1"), nodesStatsAction).isOk());
            Assert.assertFalse((boolean)subject.hasClusterPermission(RoleBasedActionAuthorizationTests.ctx(user, "test_role1"), nodesStatsActionNotWellKnown).isOk());
        }
    }
}

