/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.BcryptPipeFunction;
import java.util.List;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class BcryptPipeFunctionTest {
    public static final byte[] SALT = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 1, 2, 3, 4};
    private BcryptPipeFunction bcryptPipeFunction;

    @Before
    public void before() {
        this.bcryptPipeFunction = new BcryptPipeFunction(5, () -> SALT);
    }

    @Test
    public void shouldHashWithBcrypt() {
        String password = "one";
        Object hash = this.bcryptPipeFunction.apply((Object)password);
        MatcherAssert.assertThat((Object)OpenBSDBCrypt.checkPassword((String)((String)hash), (byte[])password.getBytes()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.equalTo((Object)"$2y$05$..CA.uOD/eaGAOm..OGB/.8o5odudFwf0ql5C46dG45mVtMwc00hW"));
    }

    @Test
    public void shouldSupportHashingInCollections() {
        ImmutableList collection = ImmutableList.of((Object)"four", (Object)"five", (Object)"six", (Object[])new String[0]);
        List result = (List)this.bcryptPipeFunction.apply((Object)collection);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)collection.size()));
        String hash = (String)result.get(0);
        MatcherAssert.assertThat((Object)OpenBSDBCrypt.checkPassword((String)hash, (byte[])((String)collection.get(0)).getBytes()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.equalTo((Object)"$2y$05$..CA.uOD/eaGAOm..OGB/.9Qgl01fJlJH.rz7NG0.Ph7UT3/sV8sa"));
        hash = (String)result.get(1);
        MatcherAssert.assertThat((Object)OpenBSDBCrypt.checkPassword((String)hash, (byte[])((String)collection.get(1)).getBytes()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.equalTo((Object)"$2y$05$..CA.uOD/eaGAOm..OGB/.IRnrOQ8zVZ3f4ML4hqRQDM.o5XXdiMy"));
        hash = (String)result.get(2);
        MatcherAssert.assertThat((Object)OpenBSDBCrypt.checkPassword((String)hash, (byte[])((String)collection.get(2)).getBytes()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.equalTo((Object)"$2y$05$..CA.uOD/eaGAOm..OGB/.Fh7z6Oo1ii4DQLqyTd2O9fdGsnLGu8C"));
    }

    @Test
    public void shouldHashObjectWhichIsNotString() {
        Object value = this.bcryptPipeFunction.apply((Object)7);
        MatcherAssert.assertThat((Object)OpenBSDBCrypt.checkPassword((String)((String)value), (byte[])"7".getBytes()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSupportNulls() {
        Object value = this.bcryptPipeFunction.apply(null);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.nullValue());
    }
}

