/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.documents.patch.JsonPathPatch;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ApiIntegrationTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().sgConfig(new TestSgConfig().frontendAuthc("default", new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("basic")).loginPage(new TestSgConfig.FrontendLoginPage().brandImage("/relative-default/img.png")))).user(ADMIN_USER).embedded().build();

    @Test
    public void patchAuthc() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            client.patch("/_searchguard/config/authc", (DocPatch)new JsonPathPatch(new JsonPathPatch.Operation[]{new JsonPathPatch.Operation(JsonPath.compile((String)"debug", (Predicate[])new Predicate[0]), (Object)true)}), new Header[0]);
        }
    }

    @Test
    public void deleteAuthc() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(CType.AUTHC, () -> {
                GenericRestClient.HttpResponse response = client.get("/_searchguard/config/authc", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)Matchers.anEmptyMap()));
                response = client.delete("/_searchguard/config/authc", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = client.get("/_searchguard/config/authc", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.anEmptyMap());
                return null;
            });
        }
    }

    @Test
    public void putLicenseKeyBadEncoding() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/license/key", (Document<?>)DocNode.of((String)"key", (Object)"ggfgf"));
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Invalid base64 encoding"));
        }
    }

    @Test
    public void putLicenseKeyBadContent() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/license/key", (Document<?>)DocNode.of((String)"key", (Object)"aGVsbG8K"));
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Cannot find license signature"));
        }
    }

    @Test
    public void putFrontendAuthc_multipleDomainsWithAutoSelect() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.of((String)"default", (Object)DocNode.of((String)"auth_domains", (Object)ImmutableList.of((Object)DocNode.of((String)"type", (Object)"basic", (String)"label", (Object)"basic-1", (String)"enabled", (Object)false, (String)"auto_select", (Object)true), (Object)DocNode.of((String)"type", (Object)"basic", (String)"label", (Object)"basic-2", (String)"enabled", (Object)false, (String)"auto_select", (Object)true))));
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/config/authc_frontend", (Document<?>)body);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("'default.auth_domains': Only one frontend authentication domain can have 'auto_select' enabled"));
        }
    }

    @Test
    public void putFrontendAuthc_oneDomainWithAutoSelect() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.of((String)"default", (Object)DocNode.of((String)"auth_domains", (Object)ImmutableList.of((Object)DocNode.of((String)"type", (Object)"basic", (String)"label", (Object)"basic-1", (String)"enabled", (Object)false, (String)"auto_select", (Object)true), (Object)DocNode.of((String)"type", (Object)"oidc", (String)"label", (Object)"basic-2", (String)"enabled", (Object)false, (String)"auto_select", (Object)false))));
            GenericRestClient.HttpResponse response = cluster.callAndRestoreConfig(CType.FRONTEND_AUTHC, () -> client.putJson("/_searchguard/config/authc_frontend", (Document<?>)body));
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
    }

    @Test
    public void getFrontendAuthc_shouldReturnBrandImageWithRelativePath() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config/authc_frontend", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)response.getBodyAsDocNode().findSingleValueByJsonPath("$.content.default.login_page.brand_image", String.class), (Object)"/relative-default/img.png");
            response = client.get("/_searchguard/config/authc_frontend/default", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)response.getBodyAsDocNode().findSingleValueByJsonPath("$.data.login_page.brand_image", String.class), (Object)"/relative-default/img.png");
        }
    }

    @Test
    public void putFrontendAuthc_shouldValidateLoginPageBrandImagePath() throws Exception {
        DocNode bodyWithAbsolutePath;
        GenericRestClient.HttpResponse response;
        DocNode bodyWithRelativePath;
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            bodyWithRelativePath = DocNode.of((String)"default", (Object)DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"/relative/test.png")));
            response = client.putJson("/_searchguard/config/authc_frontend", (Document<?>)bodyWithRelativePath);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("'default.login_page.brand_image': Must be an absolute URI"));
            bodyWithAbsolutePath = DocNode.of((String)"default", (Object)DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"http://localhost:123/absolute/test.png")));
            cluster.callAndRestoreConfig(CType.FRONTEND_AUTHC, () -> {
                GenericRestClient.HttpResponse putResponse = client.putJson("/_searchguard/config/authc_frontend", (Document<?>)bodyWithAbsolutePath);
                Assert.assertEquals((String)putResponse.getBody(), (long)200L, (long)putResponse.getStatusCode());
                GenericRestClient.HttpResponse getResponse = client.get("/_searchguard/config/authc_frontend", new Header[0]);
                Assert.assertEquals((String)getResponse.getBody(), (long)200L, (long)getResponse.getStatusCode());
                Assert.assertEquals((Object)getResponse.getBodyAsDocNode().findSingleValueByJsonPath("$.content.default.login_page.brand_image", String.class), (Object)"http://localhost:123/absolute/test.png");
                return null;
            });
        }
        client = cluster.getAdminCertRestClient();
        try {
            bodyWithRelativePath = DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"/relative/test.png"));
            response = client.putJson("/_searchguard/config/authc_frontend/default", (Document<?>)bodyWithRelativePath);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("'login_page.brand_image': Must be an absolute URI"));
            bodyWithAbsolutePath = DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"http://localhost:123/absolute/test.png"));
            cluster.callAndRestoreConfig(CType.FRONTEND_AUTHC, () -> {
                GenericRestClient.HttpResponse putResponse = client.putJson("/_searchguard/config/authc_frontend/default", (Document<?>)bodyWithAbsolutePath);
                Assert.assertEquals((String)putResponse.getBody(), (long)200L, (long)putResponse.getStatusCode());
                GenericRestClient.HttpResponse getResponse = client.get("/_searchguard/config/authc_frontend/default", new Header[0]);
                Assert.assertEquals((String)getResponse.getBody(), (long)200L, (long)getResponse.getStatusCode());
                Assert.assertEquals((Object)getResponse.getBodyAsDocNode().findSingleValueByJsonPath("$.data.login_page.brand_image", String.class), (Object)"http://localhost:123/absolute/test.png");
                return null;
            });
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void patchFrontendAuthc_shouldValidateLoginPageBrandImagePath() throws Exception {
        DocNode bodyWithAbsolutePath;
        GenericRestClient.HttpResponse response;
        DocNode bodyWithRelativePath;
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            bodyWithRelativePath = DocNode.of((String)"default", (Object)DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"/relative/test.png")));
            response = client.patchJsonMerge("/_searchguard/config/authc_frontend", (Document<?>)bodyWithRelativePath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("'default.login_page.brand_image': Must be an absolute URI"));
            bodyWithAbsolutePath = DocNode.of((String)"default", (Object)DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"http://localhost:123/absolute/test.png")));
            cluster.callAndRestoreConfig(CType.FRONTEND_AUTHC, () -> {
                GenericRestClient.HttpResponse patchResponse = client.patchJsonMerge("/_searchguard/config/authc_frontend", (Document<?>)bodyWithAbsolutePath, new Header[0]);
                Assert.assertEquals((String)patchResponse.getBody(), (long)200L, (long)patchResponse.getStatusCode());
                GenericRestClient.HttpResponse getResponse = client.get("/_searchguard/config/authc_frontend", new Header[0]);
                Assert.assertEquals((String)getResponse.getBody(), (long)200L, (long)getResponse.getStatusCode());
                Assert.assertEquals((Object)getResponse.getBodyAsDocNode().findSingleValueByJsonPath("$.content.default.login_page.brand_image", String.class), (Object)"http://localhost:123/absolute/test.png");
                return null;
            });
        }
        client = cluster.getAdminCertRestClient();
        try {
            bodyWithRelativePath = DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"/relative/test.png"));
            response = client.patchJsonMerge("/_searchguard/config/authc_frontend/default", (Document<?>)bodyWithRelativePath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("'login_page.brand_image': Must be an absolute URI"));
            bodyWithAbsolutePath = DocNode.of((String)"login_page", (Object)DocNode.of((String)"brand_image", (Object)"http://localhost:123/absolute/test.png"));
            cluster.callAndRestoreConfig(CType.FRONTEND_AUTHC, () -> {
                GenericRestClient.HttpResponse patchResponse = client.patchJsonMerge("/_searchguard/config/authc_frontend/default", (Document<?>)bodyWithAbsolutePath, new Header[0]);
                Assert.assertEquals((String)patchResponse.getBody(), (long)200L, (long)patchResponse.getStatusCode());
                GenericRestClient.HttpResponse getResponse = client.get("/_searchguard/config/authc_frontend/default", new Header[0]);
                Assert.assertEquals((String)getResponse.getBody(), (long)200L, (long)getResponse.getStatusCode());
                Assert.assertEquals((Object)getResponse.getBodyAsDocNode().findSingleValueByJsonPath("$.data.login_page.brand_image", String.class), (Object)"http://localhost:123/absolute/test.png");
                return null;
            });
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

