/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public interface TestIndexLike {
    public String getName();

    public Set<String> getDocumentIds();

    public Map<String, Map<String, ?>> getDocuments();

    public DocNode getFieldsMappings();

    default public Filtered filteredBy(Predicate<DocNode> filter) {
        return new Filtered(this, filter);
    }

    default public TestIndexLike intersection(TestIndexLike other) {
        if (other == this) {
            return this;
        }
        if (!this.getName().equals(other.getName())) {
            throw new IllegalArgumentException("Cannot intersect different indices: " + this + " vs " + other);
        }
        if (other instanceof Filtered) {
            return ((Filtered)other).intersection(this);
        }
        return this;
    }

    default public Map<String, ?> firstDocument() {
        return this.getDocuments().values().stream().findFirst().orElseThrow();
    }

    public static class Filtered
    implements TestIndexLike {
        final TestIndexLike testIndexLike;
        final Predicate<DocNode> filter;
        Map<String, Map<String, ?>> cachedDocuments;

        Filtered(TestIndexLike testIndexLike, Predicate<DocNode> filter) {
            this.testIndexLike = testIndexLike;
            this.filter = filter;
        }

        @Override
        public String getName() {
            return this.testIndexLike.getName();
        }

        @Override
        public Set<String> getDocumentIds() {
            return this.getDocuments().keySet();
        }

        @Override
        public Map<String, Map<String, ?>> getDocuments() {
            Map<String, Map<String, ?>> result = this.cachedDocuments;
            if (result == null) {
                result = new HashMap();
                for (Map.Entry<String, Map<String, ?>> entry : this.testIndexLike.getDocuments().entrySet()) {
                    if (!this.filter.test(DocNode.wrap(entry.getValue()))) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
                this.cachedDocuments = Collections.unmodifiableMap(result);
            }
            return result;
        }

        @Override
        public DocNode getFieldsMappings() {
            return this.testIndexLike.getFieldsMappings();
        }

        @Override
        public TestIndexLike intersection(TestIndexLike other) {
            if (other == this) {
                return this;
            }
            if (other instanceof Filtered) {
                return new Filtered(this.testIndexLike, node -> this.filter.test((DocNode)node) && ((Filtered)other).filter.test((DocNode)node));
            }
            return this;
        }

        public String toString() {
            return this.testIndexLike + " [filtered]";
        }
    }
}

