/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.SecureRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class CertificateAndPrivateKeyWriter {
    private static final Logger log = LogManager.getLogger(CertificateAndPrivateKeyWriter.class);
    private static final SecureRandom secureRandom = new SecureRandom();

    public static String writeCertificate(X509CertificateHolder certificate) {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter writer = new JcaPEMWriter((Writer)stringWriter);){
            writer.writeObject((Object)certificate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static void saveCertificate(File certificateFile, X509CertificateHolder certificate) {
        try (JcaPEMWriter writer = new JcaPEMWriter((Writer)new FileWriter(certificateFile));){
            writer.writeObject((Object)certificate);
        }
        catch (Exception e) {
            log.error("Error while writing certificate to file: {}", (Object)certificateFile.getAbsolutePath(), (Object)e);
            throw new RuntimeException(String.format("Error while writing to file: %s", certificateFile.getAbsolutePath()), e);
        }
    }

    public static void savePrivateKey(File privateKeyFile, PrivateKey privateKey, String privateKeyPassword) {
        try (JcaPEMWriter writer = new JcaPEMWriter((Writer)new FileWriter(privateKeyFile));){
            writer.writeObject((PemObjectGenerator)CertificateAndPrivateKeyWriter.createPkcs8PrivateKeyPem(privateKey, privateKeyPassword));
        }
        catch (Exception e) {
            log.error("Error while writing private key to file: {}", (Object)privateKeyFile.getAbsolutePath(), (Object)e);
            throw new RuntimeException(String.format("Error while writing private key to file: %s", privateKeyFile.getAbsolutePath()), e);
        }
    }

    private static PemObject createPkcs8PrivateKeyPem(PrivateKey privateKey, String password) {
        try {
            OutputEncryptor outputEncryptor = CertificateAndPrivateKeyWriter.getPasswordEncryptor(password);
            return new PKCS8Generator(PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()), outputEncryptor).generate();
        }
        catch (OperatorCreationException | PemGenerationException e) {
            log.error("Creating PKCS8 private key failed", e);
            throw new RuntimeException("Creating PKCS8 private key failed", e);
        }
    }

    private static OutputEncryptor getPasswordEncryptor(String password) throws OperatorCreationException {
        if (password != null) {
            JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_3DES);
            encryptorBuilder.setRandom(secureRandom);
            encryptorBuilder.setPassword(password.toCharArray());
            return encryptorBuilder.build();
        }
        return null;
    }
}

