/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsDownload;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.Settings;

class EsInstallation {
    private static final Logger log = LogManager.getLogger(EsInstallation.class);
    private final File path;
    private final File configPath;
    private final String esVersion;
    private final ExecutorService executorService;

    EsInstallation(File path, String esVersion, ExecutorService executorService) {
        this.path = path;
        this.configPath = new File(path, "config");
        this.esVersion = esVersion;
        this.executorService = executorService;
    }

    void installPlugin(File plugin) throws EsDownload.EsInstallationUnavailableException {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bin/elasticsearch-plugin", "install", "-v", "-b", "file:///" + plugin.getAbsolutePath());
            processBuilder.directory(this.path);
            Process process = processBuilder.start();
            StringBuilder result = new StringBuilder();
            this.executorService.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(l -> result.append((String)l).append("\n")));
            this.executorService.submit(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(l -> result.append((String)l).append("\n")));
            int rc = process.waitFor();
            if (rc != 0) {
                log.info("{}", (Object)result);
                throw new Exception("Command failed with rc " + rc);
            }
        }
        catch (Exception e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while installing " + plugin, e);
        }
    }

    synchronized void ensureKeystore() throws EsDownload.EsInstallationUnavailableException {
        try {
            if (new File(this.configPath, "elasticsearch.keystore").exists()) {
                return;
            }
            try (KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.create();){
                keyStoreWrapper.save(this.configPath.toPath(), new char[0]);
            }
        }
        catch (Exception e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while creating default key store", e);
        }
    }

    void appendConfig(String name, String content) throws EsDownload.EsInstallationUnavailableException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.configPath, name), true));){
            writer.newLine();
            writer.write(content);
            writer.newLine();
        }
        catch (IOException e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while writing configuration to " + name, e);
        }
    }

    void writeConfig(String name, String content) throws EsDownload.EsInstallationUnavailableException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.configPath, name)));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while writing configuration to " + name, e);
        }
    }

    void writeConfig(String name, File file) throws EsDownload.EsInstallationUnavailableException {
        try {
            this.writeConfig(name, Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read());
        }
        catch (IOException e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while reading configuration from " + file, e);
        }
    }

    void initSgConfig(Map<String, Document<?>> config) throws EsDownload.EsInstallationUnavailableException {
        File sgConfigDir = new File(this.path, "plugins/search-guard-flx/sgconfig/");
        for (File file : sgConfigDir.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
        for (Map.Entry entry : config.entrySet()) {
            File file = new File(sgConfigDir, "sg_" + (String)entry.getKey() + ".yml");
            try {
                Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)((Document)entry.getValue()).toYamlString());
            }
            catch (IOException e) {
                throw new EsDownload.EsInstallationUnavailableException("Error while writing " + file, e);
            }
        }
    }

    Process startProcess(int httpPort, int transportPort, File workingDir, Settings settings, ClusterConfiguration.NodeSettings nodeSettings) throws EsDownload.EsInstallationUnavailableException {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            File dataDir = new File(workingDir, "data");
            dataDir.mkdir();
            File logsDir = new File(workingDir, "logs");
            logsDir.mkdir();
            Map<String, String> env = processBuilder.environment();
            env.remove("path.home");
            ArrayList<String> command = new ArrayList<String>();
            command.add("bin/elasticsearch");
            command.add("-Ehttp.port=" + httpPort);
            command.add("-Etransport.port=" + transportPort);
            DocNode wrappedSettings = DocNode.parse((Format)Format.JSON).from(settings.toString());
            for (String key : settings.keySet()) {
                command.add("-E" + key + "=" + wrappedSettings.getAsNode(key).toYamlString().replace("---", ""));
            }
            if (nodeSettings.masterNode && nodeSettings.dataNode) {
                command.add("-Enode.roles=master,data,remote_cluster_client");
            } else if (nodeSettings.masterNode) {
                command.add("-Enode.roles=master,remote_cluster_client");
            } else if (nodeSettings.dataNode) {
                command.add("-Enode.roles=data,remote_cluster_client");
            }
            command.add("-Epath.data=" + dataDir.getAbsolutePath());
            command.add("-Epath.logs=" + logsDir.getAbsolutePath());
            log.debug("Executing {}", command);
            processBuilder.command(command);
            processBuilder.directory(this.path);
            Process process = processBuilder.start();
            return process;
        }
        catch (Exception e) {
            throw new EsDownload.EsInstallationUnavailableException("Error while starting " + this, e);
        }
    }

    public String toString() {
        return "EsInstallation [path=" + this.path + ", esVersion=" + this.esVersion + "]";
    }

    File getConfigPath() {
        return this.configPath;
    }
}

