/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import java.util.concurrent.CompletableFuture;

public interface AuthenticationBackend
extends ComponentStateProvider {
    public static final AuthenticationBackend NOOP = new AuthenticationBackend(){
        private final ComponentState componentState = new ComponentState(0, "authentication_backend", "noop").initialized();

        @Override
        public String getType() {
            return "noop";
        }

        @Override
        public CompletableFuture<AuthCredentials> authenticate(AuthCredentials authCredentials, Meter meter) throws AuthenticatorUnavailableException, CredentialsException {
            return CompletableFuture.completedFuture(authCredentials);
        }

        @Override
        public UserCachingPolicy userCachingPolicy() {
            return UserCachingPolicy.ONLY_IF_AUTHZ_SEPARATE;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    };

    public String getType();

    public CompletableFuture<AuthCredentials> authenticate(AuthCredentials var1, Meter var2) throws AuthenticatorUnavailableException, CredentialsException;

    default public UserCachingPolicy userCachingPolicy() {
        return UserCachingPolicy.ALWAYS;
    }

    default public ImmutableMap<String, String> describeAvailableUserMappingAttributes() {
        return ImmutableMap.empty();
    }

    public static enum UserCachingPolicy {
        ALWAYS,
        ONLY_IF_AUTHZ_SEPARATE,
        NEVER;

    }

    @FunctionalInterface
    public static interface UserMapper {
        public static final UserMapper DIRECT = authCredentials -> User.forUser(authCredentials.getName()).with(authCredentials).build();

        public User map(AuthCredentials var1) throws CredentialsException;
    }
}

