/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import java.io.Serializable;
import java.util.Arrays;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.search.SearchRequest;

public class SourceFieldsContext
implements Serializable {
    private String[] includes;
    private String[] excludes;
    private boolean fetchSource = true;
    private static final long serialVersionUID = 1L;

    public static boolean isNeeded(SearchRequest request) {
        return request.source() != null && request.source().fetchSource() != null && (request.source().fetchSource().includes() != null || request.source().fetchSource().excludes() != null) || request.source() != null && request.source().storedFields() != null && request.source().storedFields().fieldNames() != null && !request.source().storedFields().fieldNames().isEmpty();
    }

    public static boolean isNeeded(GetRequest request) {
        return request.fetchSourceContext() != null && (request.fetchSourceContext().includes() != null || request.fetchSourceContext().excludes() != null) || request.storedFields() != null && request.storedFields().length > 0;
    }

    public SourceFieldsContext() {
    }

    public SourceFieldsContext(SearchRequest request) {
        if (request.source() != null && request.source().fetchSource() != null) {
            this.includes = request.source().fetchSource().includes();
            this.excludes = request.source().fetchSource().excludes();
            this.fetchSource = request.source().fetchSource().fetchSource();
        }
    }

    public SourceFieldsContext(GetRequest request) {
        if (request.fetchSourceContext() != null) {
            this.includes = request.fetchSourceContext().includes();
            this.excludes = request.fetchSourceContext().excludes();
            this.fetchSource = request.fetchSourceContext().fetchSource();
        }
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public boolean hasIncludesOrExcludes() {
        return this.includes != null && this.includes.length > 0 || this.excludes != null && this.excludes.length > 0;
    }

    public boolean isFetchSource() {
        return this.fetchSource;
    }

    public String toString() {
        return "SourceFieldsContext [includes=" + Arrays.toString(this.includes) + ", excludes=" + Arrays.toString(this.excludes) + ", fetchSource=" + this.fetchSource + "]";
    }
}

