/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.searchguard.authz.DocumentWhitelist;
import org.junit.Assert;
import org.junit.Test;

public class DocumentWhitelistTest {
    @Test
    public void basicTest() throws Exception {
        DocumentWhitelist.Builder builder = new DocumentWhitelist.Builder();
        builder.add("test", "foo");
        builder.add("test", "x/y");
        builder.add("test", "a|b");
        builder.add("test", "$\\#");
        builder.add("test", "o\\/p");
        DocumentWhitelist documentWhitelist = builder.build();
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "foo"));
        Assert.assertFalse((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "bar"));
        Assert.assertFalse((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test2", "foo"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "x/y"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "a|b"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "$\\#"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "o\\/p"));
    }

    @Test
    public void parseTest() throws Exception {
        DocumentWhitelist.Builder builder = new DocumentWhitelist.Builder();
        builder.add("test", "foo");
        builder.add("test", "x/y");
        builder.add("test", "a|b");
        builder.add("test", "$\\#");
        builder.add("test", "o\\/p");
        DocumentWhitelist documentWhitelist = builder.build();
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "foo"));
        Assert.assertFalse((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "bar"));
        Assert.assertFalse((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test2", "foo"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "x/y"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "a|b"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "$\\#"));
        Assert.assertTrue((String)documentWhitelist.toString(), (boolean)documentWhitelist.isWhitelisted("test", "o\\/p"));
        DocumentWhitelist documentWhitelist2 = DocumentWhitelist.parse((String)documentWhitelist.toString());
        Assert.assertEquals((Object)documentWhitelist, (Object)documentWhitelist2);
        Assert.assertTrue((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "foo"));
        Assert.assertFalse((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "bar"));
        Assert.assertFalse((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test2", "foo"));
        Assert.assertTrue((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "x/y"));
        Assert.assertTrue((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "a|b"));
        Assert.assertTrue((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "$\\#"));
        Assert.assertTrue((String)documentWhitelist2.toString(), (boolean)documentWhitelist2.isWhitelisted("test", "o\\/p"));
    }
}

