/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.PitHolder;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IgnoreUnauthorizedCcsIntTest {
    @Parameterized.Parameter
    public String ccsMinimizeRoundtrips;
    private static TestCertificates certificatesContext = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addNodes("CN=node-0.example.com,OU=SearchGuard,O=SearchGuard").addClients("CN=client-0.example.com,OU=SearchGuard,O=SearchGuard").addAdminClients("CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard").build();
    static TestSgConfig.User LIMITED_USER_COORD_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*"));
    static TestSgConfig.User LIMITED_USER_REMOTE_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards", "indices:admin/resolve/cluster").on("a*"));
    static TestSgConfig.User LIMITED_USER_COORD_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("b*"));
    static TestSgConfig.User LIMITED_USER_REMOTE_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards").on("b*"));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").roles(new TestSgConfig.Role("unlimited_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards", "indices:admin/resolve/cluster").on("*"));
    static TestIndex index_coord_a1 = TestIndex.name("a1").documentCount(100).seed(1).attr("prefix", "a").attr("cluster", "local").build();
    static TestIndex index_coord_a2 = TestIndex.name("a2").documentCount(110).seed(2).attr("prefix", "a").attr("cluster", "local").build();
    static TestIndex index_remote_a1 = TestIndex.name("a1").documentCount(120).seed(11).attr("prefix", "a").attr("cluster", "remote").build();
    static TestIndex index_remote_a2 = TestIndex.name("a2").documentCount(130).seed(12).attr("prefix", "a").attr("cluster", "remote").build();
    static TestIndex index_coord_b1 = TestIndex.name("b1").documentCount(51).seed(4).attr("prefix", "b").attr("cluster", "local").build();
    static TestIndex index_coord_b2 = TestIndex.name("b2").documentCount(52).seed(5).attr("prefix", "b").attr("cluster", "local").build();
    static TestIndex index_remote_b1 = TestIndex.name("b1").documentCount(53).seed(14).attr("prefix", "b").attr("cluster", "remote").build();
    static TestIndex index_remote_b2 = TestIndex.name("b2").documentCount(54).seed(15).attr("prefix", "b").attr("cluster", "remote").build();
    static TestIndex index_coord_c1 = TestIndex.name("c1").documentCount(5).seed(7).attr("prefix", "c").attr("cluster", "local").build();
    static TestIndex index_remote_r1 = TestIndex.name("r1").documentCount(5).seed(8).attr("prefix", "r").attr("cluster", "remote").build();
    static TestAlias xalias_coord_ab1 = new TestAlias("xalias_ab1", index_coord_a1, index_coord_a2, index_coord_b1);
    static TestAlias xalias_remote_ab1 = new TestAlias("xalias_ab1", index_remote_a1, index_remote_a2, index_remote_b1);
    static NamedWriteableRegistry nameRegistry;
    @ClassRule
    public static LocalCluster.Embedded anotherCluster;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{"ccs_minimize_roundtrips=false", "ccs_minimize_roundtrips=true"};
    }

    @BeforeClass
    public static void beforeClass() {
        nameRegistry = cluster.getInjectable(NamedWriteableRegistry.class);
    }

    @Test
    public void search_noPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_localWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "*/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_localWildcard_withPit() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        PitHolder pitHolder;
        String query = "/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            pitHolder = PitHolder.of(restClient).post("/*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Object[] expectedIndices = new TestIndex[]{index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1};
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches((TestIndex[])expectedIndices))}));
                    Object[] expectedIndicesNames = (String[])ImmutableList.ofArray((Object[])expectedIndices).map(TestIndex::getName).toArray(String[]::new);
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expectedIndicesNames));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            pitHolder = PitHolder.of(restClient).post("/*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2))}));
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{index_coord_a1.getName(), index_coord_a2.getName()}));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_localAll() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "_all/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches(index_coord_a1, index_coord_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_remoteWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:*/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_remoteWildcard_withPit() throws Exception {
        Object[] expectedIndicesWithRemoteClusterPrefix;
        int expectedIndicesDocCount;
        Object[] expectedIndices;
        GenericRestClient.HttpResponse httpResponse;
        PitHolder pitHolder;
        String query = "/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            pitHolder = PitHolder.of(restClient).post("/my_remote:*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    expectedIndices = new TestIndex[]{index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1};
                    expectedIndicesDocCount = Stream.of(expectedIndices).mapToInt(testIndex -> testIndex.getTestData().getRetainedDocuments().size()).sum();
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits[*]", Matchers.hasSize((int)expectedIndicesDocCount))}));
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", (TestIndex[])expectedIndices))}));
                    expectedIndicesWithRemoteClusterPrefix = (String[])ImmutableList.ofArray((Object[])expectedIndices).map(TestIndex::getName).map(indexName -> "my_remote:" + indexName).toArray(String[]::new);
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expectedIndicesWithRemoteClusterPrefix));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            pitHolder = PitHolder.of(restClient).post("/my_remote:*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    expectedIndices = new TestIndex[]{index_remote_a1, index_remote_a2};
                    expectedIndicesDocCount = Stream.of(expectedIndices).mapToInt(testIndex -> testIndex.getTestData().getRetainedDocuments().size()).sum();
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits[*]", Matchers.hasSize((int)expectedIndicesDocCount))}));
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", (TestIndex[])expectedIndices))}));
                    expectedIndicesWithRemoteClusterPrefix = (String[])ImmutableList.ofArray((Object[])expectedIndices).map(TestIndex::getName).map(indexName -> "my_remote:" + indexName).toArray(String[]::new);
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expectedIndicesWithRemoteClusterPrefix));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_remoteAll() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:_all/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_wildcardWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "*:*/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_clusterWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "*:/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits", Matchers.empty())}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.status", Matchers.equalTo((Object)"skipped"))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures", Matchers.hasSize((int)1))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures[0].reason.reason", Matchers.containsString((String)"no such index"))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits", Matchers.empty())}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.status", Matchers.equalTo((Object)"skipped"))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures", Matchers.hasSize((int)1))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures[0].reason.reason", Matchers.equalTo((Object)"Insufficient permissions"))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    @Ignore(value="NoSuchRemoteClusterException: no such remote cluster: []")
    public void search_emptyClusterName() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = ":*/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.empty())}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.empty())}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indexPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:a*/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indexPattern_withPit() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        PitHolder pitHolder;
        String query = "/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            pitHolder = PitHolder.of(restClient).post("/my_remote:a*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"my_remote:a1", "my_remote:a2"}));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            pitHolder = PitHolder.of(restClient).post("/my_remote:a*/_pit?keep_alive=1m");
            try {
                httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2))}));
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"my_remote:a1", "my_remote:a2"}));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndices() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:b1/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"my_remote:b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits", Matchers.empty())}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.status", Matchers.equalTo((Object)"skipped"))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures", Matchers.hasSize((int)1))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures[0].reason.reason", Matchers.equalTo((Object)"Insufficient permissions"))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndices_pit() throws Exception {
        PitHolder pitHolder;
        String query = "/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            pitHolder = PitHolder.of(restClient).post("/my_remote:b1/_pit?keep_alive=1m");
            try {
                GenericRestClient.HttpResponse httpResponse = restClient.postJson(query, (Map<String, Object>)pitHolder.asSearchBody(), new Header[0]);
                if (this.ccsMinimizeRoundtrips.equals("ccs_minimize_roundtrips=true")) {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"[ccs_minimize_roundtrips] cannot be used with point in time"))}));
                } else {
                    Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
                    Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"my_remote:b1"}))}));
                    Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"my_remote:b1"}));
                }
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            pitHolder = PitHolder.of(restClient).post("/my_remote:b1/_pit?keep_alive=1m");
            try {
                Assert.assertThat((Object)pitHolder.getResponse(), RestMatchers.isOk());
                Assert.assertThat((Object)pitHolder.extractIndicesFromPit(nameRegistry), (Matcher)Matchers.emptyArray());
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndices_ignoreUnavailable() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:b1/_search?size=1000&ignore_unavailable=true&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"my_remote:b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.empty())}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndicesRemoteAndLocal() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:b1,b1,my_remote:a1,a1/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"b1", (Object)index_coord_b1, (Object)"my_remote:a1", (Object)index_remote_a1, (Object)"my_remote:b1", (Object)index_remote_b1)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndicesRemoteAndLocal_ignoreUnavailable() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:b1,b1,my_remote:a1,a1/_search?size=1000&ignore_unavailable=true&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"b1", (Object)index_coord_b1, (Object)"my_remote:a1", (Object)index_remote_a1, (Object)"my_remote:b1", (Object)index_remote_b1)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"my_remote:a1", (Object)index_remote_a1)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_remoteAlias() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:xalias_ab1/_search?size=1000&" + this.ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2, index_remote_b1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits", Matchers.empty())}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.status", Matchers.equalTo((Object)"skipped"))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures", Matchers.hasSize((int)1))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.details.my_remote.failures[0].reason.reason", Matchers.equalTo((Object)"Insufficient permissions"))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void msearch_staticIndicesInURL() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:a1/_msearch?" + this.ccsMinimizeRoundtrips;
        String msearchBody = "{}\n{\"size\":1000, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_B, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits", Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.empty()}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*]._clusters.details.my_remote.status", Matchers.containsInAnyOrder((Object[])new String[]{"skipped"}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*]._clusters.details.my_remote.failures", Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.hasSize((int)1)}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*]._clusters.details.my_remote.failures[0].reason.reason", Matchers.containsInAnyOrder((Object[])new String[]{"Insufficient permissions"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void msearch_staticIndicesInURL_remoteAndLocal() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "a1,my_remote:a1/_msearch?" + this.ccsMinimizeRoundtrips;
        String msearchBody = "{}\n{\"size\":1000, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"my_remote:a1", (Object)index_remote_a1)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"my_remote:a1", (Object)index_remote_a1)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_B, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].error.type", Matchers.containsInAnyOrder((Object[])new String[]{"security_exception"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void msearch_staticIndicesInURL_remoteAndLocal_ignoreUnavailable() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "a1,my_remote:a1,b1,my_remote:b1/_msearch?" + this.ccsMinimizeRoundtrips;
        String msearchBody = "{\"ignore_unavailable\": true}\n{\"size\":1000, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"my_remote:a1", (Object)index_remote_a1, (Object)"b1", (Object)index_coord_b1, (Object)"my_remote:b1", (Object)index_remote_b1)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1, (Object)"my_remote:a1", (Object)index_remote_a1)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_B, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)"b1", (Object)index_coord_b1, (Object)"my_remote:b1", (Object)index_remote_b1)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indicesAggregation_localWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "*/_search?" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":1000}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount(index_coord_a1, index_coord_a2))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indicesAggregation_localAndRemoteWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:*,*/_search?" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":1000}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1).with((Object)"a2", (Object)index_coord_a2).with((Object)"b1", (Object)index_coord_b1).with((Object)"b2", (Object)index_coord_b2).with((Object)"c1", (Object)index_coord_c1).with((Object)"my_remote:a1", (Object)index_remote_a1).with((Object)"my_remote:a2", (Object)index_remote_a2).with((Object)"my_remote:b1", (Object)index_remote_b1).with((Object)"my_remote:b2", (Object)index_remote_b2).with((Object)"my_remote:r1", (Object)index_remote_r1)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount((Map<String, TestIndex>)ImmutableMap.of((Object)"a1", (Object)index_coord_a1).with((Object)"a2", (Object)index_coord_a2).with((Object)"my_remote:a1", (Object)index_remote_a1).with((Object)"my_remote:a2", (Object)index_remote_a2)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indicesAggregation_localAndRemoteIndexPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:a*,b*/_search?" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":1000}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount((Map<String, TestIndex>)ImmutableMap.of((Object)"b1", (Object)index_coord_b1).with((Object)"b2", (Object)index_coord_b2).with((Object)"my_remote:a1", (Object)index_remote_a1).with((Object)"my_remote:a2", (Object)index_remote_a2)))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets", RestMatchers.matchesDocCount((Map<String, TestIndex>)ImmutableMap.of((Object)"my_remote:a1", (Object)index_remote_a1).with((Object)"my_remote:a2", (Object)index_remote_a2)))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_termsAggregation_localAndRemoteWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:*,*/_search?" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":1000}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.successful", Matchers.is((Object)2))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'local')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{300}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'remote')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{342}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.successful", Matchers.is((Object)2))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'local')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{198}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'remote')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{236}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_termsAggregation_localNotFoundAndRemoteWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:*,notfound/_search?" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":1000}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_termsAggregation_localNotFoundAndRemoteWildcard_ignoreUnavailable() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        boolean roundtripsMinimized = this.ccsMinimizeRoundtrips.endsWith(String.valueOf(Boolean.TRUE));
        String query = "my_remote:*,notfound/_search?ignore_unavailable=true&" + this.ccsMinimizeRoundtrips;
        String body = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":1000}}}}";
        Matcher clustersCountMatcherCssRoundtripsMinTrue = Matchers.allOf(RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.successful", Matchers.is((Object)2))}), RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.running", Matchers.is((Object)0))}));
        Matcher clustersCountMatcherCssRoundtripsMinFalse = Matchers.allOf(RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.successful", Matchers.is((Object)2))}), RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("_clusters.running", Matchers.is((Object)0))}));
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, (Matcher)(roundtripsMinimized ? clustersCountMatcherCssRoundtripsMinTrue : clustersCountMatcherCssRoundtripsMinFalse));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'remote')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{342}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, body, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.clusteragg.buckets[?(@.key == 'remote')].doc_count", Matchers.containsInAnyOrder((Object[])new Integer[]{236}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void resolve_cluster_local_static_match_ignore_unavailable_true_limited_user() throws Exception {
        String query = "/_resolve/cluster/b1?ignore_unavailable=true";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_local_static_match_ignore_unavailable_false_limited_user() throws Exception {
        String query = "/_resolve/cluster/b1?ignore_unavailable=false";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.error.root_cause[0].type", Matchers.equalTo((Object)"security_exception"))}));
        }
    }

    @Test
    public void resolve_cluster_local_pattern_not_match_limited_user_limited_user() throws Exception {
        String query = "/_resolve/cluster/no_such_local_index*";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_local_pattern_not_match() throws Exception {
        String query = "/_resolve/cluster/no_such_local_index*";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_local_pattern_star_match() throws Exception {
        String query = "/_resolve/cluster/*";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)true))}));
        }
    }

    @Test
    public void resolve_cluster_remote_static_match() throws Exception {
        String query = "/_resolve/cluster/my_remote:b1";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)true))}));
        }
    }

    @Test
    public void resolve_cluster_remote_static_match_ignore_unavailable_true_limited_user() throws Exception {
        String query = "/_resolve/cluster/my_remote:b1?ignore_unavailable=true";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_remote_static_match_ignore_unavailable_false_limited_user() throws Exception {
        String query = "/_resolve/cluster/my_remote:b1";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.error", Matchers.equalTo((Object)"Insufficient permissions"))}));
        }
    }

    @Test
    public void resolve_cluster_remote_pattern_not_match() throws Exception {
        String query = "/_resolve/cluster/my_remote:no_such_remote_index*";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_remote_all_static_match() throws Exception {
        String query = "/_resolve/cluster/*:b1";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)true))}));
        }
    }

    @Test
    public void resolve_cluster_remote_all_static_match_limited_user() throws Exception {
        String query = "/_resolve/cluster/*:b1";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.error", Matchers.equalTo((Object)"Insufficient permissions"))}));
        }
    }

    @Test
    public void resolve_cluster_remote_and_local_static_match() throws Exception {
        String query = "/_resolve/cluster/my_remote:b1,b1";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)true))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)true))}));
        }
    }

    @Test
    public void resolve_cluster_remote_and_local_static_match_limited_user() throws Exception {
        String query = "/_resolve/cluster/my_remote:b1,b1";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.error.root_cause[0].type", Matchers.equalTo((Object)"security_exception"))}));
        }
    }

    @Test
    public void resolve_cluster_remote_and_local_pattern_match() throws Exception {
        String query = "/_resolve/cluster/*:*,*";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)true))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)true))}));
        }
    }

    @Test
    public void resolve_cluster_remote_and_local_pattern_match_user_not_allowed_to_access_endpoint() throws Exception {
        String query = "/_resolve/cluster/*:*,*";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_COORD_B, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)false))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void resolve_cluster_remote_and_local_pattern_match_and_not_match() throws Exception {
        String query = "/_resolve/cluster/*:no_such_remote_index*,*";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$['(local)'].matching_indices", Matchers.equalTo((Object)true))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.my_remote.matching_indices", Matchers.equalTo((Object)false))}));
        }
    }

    static {
        anotherCluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).nodeSettings("searchguard.diagnosis.action_stack.enabled", true).users(LIMITED_USER_REMOTE_A, LIMITED_USER_REMOTE_B, UNLIMITED_USER).indices(index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1).aliases(xalias_remote_ab1).embedded().build();
        cluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).remote("my_remote", anotherCluster).nodeSettings("searchguard.diagnosis.action_stack.enabled", true).nodeSettings("cluster.remote.my_remote.skip_unavailable", true).users(LIMITED_USER_COORD_A, LIMITED_USER_COORD_B, UNLIMITED_USER).indices(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1).aliases(xalias_coord_ab1).embedded().build();
    }
}

