/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.SelfDescribing;

public class ResolvedIndicesMatcher
extends DiagnosingMatcher<ResolvedIndices> {
    private final IndicesMatcher indicesMatcher;
    private final AliasesMatcher aliasesMatcher;
    private final DataStreamsMatcher dataStreamsMatcher;

    ResolvedIndicesMatcher(IndicesMatcher indicesMatcher, AliasesMatcher aliasesMatcher, DataStreamsMatcher dataStreamsMatcher) {
        this.indicesMatcher = indicesMatcher;
        this.aliasesMatcher = aliasesMatcher;
        this.dataStreamsMatcher = dataStreamsMatcher;
    }

    public void describeTo(Description description) {
        if (this.indicesMatcher != null) {
            description.appendDescriptionOf((SelfDescribing)this.indicesMatcher).appendText("; ");
        }
        if (this.aliasesMatcher != null) {
            description.appendDescriptionOf((SelfDescribing)this.aliasesMatcher).appendText("; ");
        }
        if (this.dataStreamsMatcher != null) {
            description.appendDescriptionOf((SelfDescribing)this.dataStreamsMatcher).appendText("; ");
        }
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        if (!(item instanceof ResolvedIndices)) {
            mismatchDescription.appendValue(item).appendText(" is not an ResolvedIndices object");
            return false;
        }
        ResolvedIndices resolvedIndices = (ResolvedIndices)item;
        boolean match = true;
        if (this.indicesMatcher != null) {
            match &= this.indicesMatcher.matches(resolvedIndices, mismatchDescription);
        }
        if (this.aliasesMatcher != null) {
            match &= this.aliasesMatcher.matches(resolvedIndices, mismatchDescription);
        }
        if (this.dataStreamsMatcher != null) {
            match &= this.dataStreamsMatcher.matches(resolvedIndices, mismatchDescription);
        }
        if (!match) {
            mismatchDescription.appendText("\n").appendValue((Object)resolvedIndices);
        }
        return match;
    }

    public static ResolvedIndicesMatcher hasIndices(String ... expected) {
        return new ResolvedIndicesMatcher(new IndicesMatcher(expected), null, null);
    }

    public ResolvedIndicesMatcher hasAliases(String ... expected) {
        return new ResolvedIndicesMatcher(this.indicesMatcher, new AliasesMatcher(expected), this.dataStreamsMatcher);
    }

    public ResolvedIndicesMatcher hasDataStreams(String ... expected) {
        return new ResolvedIndicesMatcher(this.indicesMatcher, this.aliasesMatcher, new DataStreamsMatcher(expected));
    }

    public static ResolvedIndicesMatcher hasNoIndices() {
        return new ResolvedIndicesMatcher(new IndicesMatcher(new String[0]), null, null);
    }

    public ResolvedIndicesMatcher hasNoAliases() {
        return new ResolvedIndicesMatcher(this.indicesMatcher, new AliasesMatcher(new String[0]), this.dataStreamsMatcher);
    }

    public ResolvedIndicesMatcher hasNoDataStreams() {
        return new ResolvedIndicesMatcher(this.indicesMatcher, this.aliasesMatcher, new DataStreamsMatcher(new String[0]));
    }

    static class IndicesMatcher
    extends AbstractResolvedIndicesMatcher {
        IndicesMatcher(String ... expected) {
            super(expected);
        }

        @Override
        protected String objectType() {
            return "indices";
        }

        @Override
        protected ImmutableSet<? extends Meta.IndexLikeObject> getObjects(ResolvedIndices resolvedIndices) {
            return resolvedIndices.getLocal().getPureIndices();
        }
    }

    static class AliasesMatcher
    extends AbstractResolvedIndicesMatcher {
        AliasesMatcher(String ... expected) {
            super(expected);
        }

        @Override
        protected String objectType() {
            return "aliases";
        }

        @Override
        protected ImmutableSet<? extends Meta.IndexLikeObject> getObjects(ResolvedIndices resolvedIndices) {
            return resolvedIndices.getLocal().getAliases();
        }
    }

    static class DataStreamsMatcher
    extends AbstractResolvedIndicesMatcher {
        DataStreamsMatcher(String ... expected) {
            super(expected);
        }

        @Override
        protected String objectType() {
            return "data streams";
        }

        @Override
        protected ImmutableSet<? extends Meta.IndexLikeObject> getObjects(ResolvedIndices resolvedIndices) {
            return resolvedIndices.getLocal().getDataStreams();
        }
    }

    static abstract class AbstractResolvedIndicesMatcher
    extends DiagnosingMatcher<ResolvedIndices> {
        protected final ImmutableSet<String> expected;

        AbstractResolvedIndicesMatcher(String ... expected) {
            this.expected = ImmutableSet.ofArray((Object[])expected);
        }

        AbstractResolvedIndicesMatcher(ImmutableSet<String> expected) {
            this.expected = expected;
        }

        protected abstract String objectType();

        protected abstract ImmutableSet<? extends Meta.IndexLikeObject> getObjects(ResolvedIndices var1);

        public void describeTo(Description description) {
            if (this.expected.isEmpty()) {
                description.appendText(this.objectType() + " are empty");
            } else {
                description.appendText(this.objectType() + " are " + this.expected);
            }
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            if (!(item instanceof ResolvedIndices)) {
                mismatchDescription.appendValue(item).appendText(" is not an ResolvedIndices object");
                return false;
            }
            ResolvedIndices resolvedIndices = (ResolvedIndices)item;
            return this.match(this.getObjects(resolvedIndices), mismatchDescription);
        }

        protected boolean match(ImmutableSet<? extends Meta.IndexLikeObject> resolved, Description mismatchDescription) {
            String objectType = this.objectType();
            ImmutableSet present = resolved.map(Meta.IndexLikeObject::name);
            if (this.expected.equals((Object)present)) {
                return true;
            }
            ImmutableSet missing = this.expected.without((Collection)present);
            ImmutableSet unexpected = present.without(this.expected);
            if (this.expected.isEmpty()) {
                mismatchDescription.appendText(objectType + " are not empty; unexpected: ").appendValue((Object)unexpected);
            } else if (!missing.isEmpty() && !unexpected.isEmpty()) {
                mismatchDescription.appendText(objectType + " ").appendValue(resolved).appendText(" do not match expected " + objectType + " ").appendValue(this.expected).appendText("; missing: ").appendValue((Object)missing).appendText("; unexpected: ").appendValue((Object)unexpected);
            } else if (!missing.isEmpty()) {
                mismatchDescription.appendText(objectType + " do not match expected " + objectType + "; missing: ").appendValue((Object)missing);
            } else {
                mismatchDescription.appendText(objectType + " do not match expected " + objectType + "; unexpected: ").appendValue((Object)unexpected);
            }
            return false;
        }
    }
}

