/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public class IndexAuthorizationReadWriteIntTests {
    static TestIndex index_ar1 = TestIndex.name("index_ar1").documentCount(10).build();
    static TestIndex index_ar2 = TestIndex.name("index_ar2").documentCount(10).build();
    static TestIndex index_aw1 = TestIndex.name("index_aw1").documentCount(10).build();
    static TestIndex index_aw2 = TestIndex.name("index_aw2").documentCount(10).build();
    static TestIndex index_br1 = TestIndex.name("index_br1").documentCount(10).build();
    static TestIndex index_br2 = TestIndex.name("index_br2").documentCount(10).build();
    static TestIndex index_bw1 = TestIndex.name("index_bw1").documentCount(10).build();
    static TestIndex index_bw2 = TestIndex.name("index_bw2").documentCount(10).build();
    static TestIndex index_cr1 = TestIndex.name("index_cr1").documentCount(10).build();
    static TestIndex index_cw1 = TestIndex.name("index_cw1").documentCount(10).build();
    static TestIndex index_hidden = TestIndex.name("index_hidden").hidden().documentCount(1).seed(8).attr("prefix", "h").build();
    static TestAlias alias_ab1r = new TestAlias("alias_ab1r", index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_bw1);
    static TestAlias alias_ab1w = new TestAlias("alias_ab1w", index_aw1, index_aw2, index_bw1).writeIndex(index_aw1);
    static TestAlias alias_ab1w_nowriteindex = new TestAlias("alias_ab1w_nowriteindex", index_aw1, index_aw2, index_bw1);
    static TestAlias alias_c1 = new TestAlias("alias_c1", index_cr1, index_cw1);
    static TestIndex index_bwx1 = TestIndex.name("index_bwx1").documentCount(0).build();
    static TestIndex index_bwx2 = TestIndex.name("index_bwx2").documentCount(0).build();
    static TestAlias alias_bwx = new TestAlias("alias_bwx", new TestIndexLike[0]);
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").description("index_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_a*").indexPermissions("SGS_WRITE").on("index_aw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_ar1, index_ar2, index_aw1, index_aw2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_aw1, index_aw2)).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").description("index_b*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*").indexPermissions("SGS_WRITE").on("index_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_CREATE_INDEX = new TestSgConfig.User("limited_user_B_create_index").description("index_b* with create index privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*").indexPermissions("SGS_WRITE").on("index_bw*").indexPermissions("SGS_CREATE_INDEX").on("index_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_MANAGE_INDEX = new TestSgConfig.User("limited_user_B_manage_index").description("index_b* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*").indexPermissions("SGS_WRITE").on("index_bw*").indexPermissions("SGS_MANAGE").on("index_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(new TestIndexLike[0]));
    static TestSgConfig.User LIMITED_USER_B_MANAGE_INDEX_ALIAS = new TestSgConfig.User("limited_user_B_manage_index_alias").description("index_b*, alias_bwx* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*").indexPermissions("SGS_WRITE").on("index_bw*").indexPermissions("SGS_MANAGE").on("index_bw*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, alias_bwx)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, alias_bwx)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(alias_bwx));
    static TestSgConfig.User LIMITED_USER_B_CREATE_INDEX_MANAGE_ALIAS = new TestSgConfig.User("limited_user_B_create_index").description("index_b* with create index privs and manage alias privs, alias_bwx* with manage alias privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*").indexPermissions("SGS_WRITE").on("index_bw*").indexPermissions("SGS_CREATE_INDEX", "SGS_MANAGE_ALIASES").on("index_bw*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, alias_bwx)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_HIDDEN_MANAGE_INDEX_ALIAS = new TestSgConfig.User("limited_user_B_HIDDEN_anage_index_alias").description("index_b*, index_hidden*, alias_bwx* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_b*", "index_hidden*").indexPermissions("SGS_WRITE").on("index_bw*", "index_hidden*").indexPermissions("SGS_MANAGE").on("index_bw*", "index_hidden*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2, index_hidden)).indexMatcher("write", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, index_hidden)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, index_hidden)).indexMatcher("manage_index", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, alias_bwx, index_hidden)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(index_bw1, index_bw2, index_bwx1, index_bwx2, alias_bwx, index_hidden)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(alias_bwx));
    static TestSgConfig.User LIMITED_USER_AB_MANAGE_INDEX = new TestSgConfig.User("limited_user_AB_manage_index").description("index_a*, index_b* with manage index privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("index_a*", "index_b*").indexPermissions("SGS_WRITE").on("index_aw*", "index_bw*").indexPermissions("SGS_MANAGE").on("index_aw*", "index_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_br2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_index", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1, index_bw2, index_bwx1, index_bwx2)).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_C = new TestSgConfig.User("limited_user_C").description("index_c*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh").on("index_c*").indexPermissions("SGS_WRITE").on("index_cw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_cr1, index_cw1)).indexMatcher("write", IndexApiMatchers.limitedTo(index_cw1)).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_AB1_ALIAS = new TestSgConfig.User("limited_user_alias_AB1").description("alias_ab1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get").on("alias_ab1r").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get", "SGS_WRITE", "indices:admin/refresh*").on("alias_ab1w*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_bw1, alias_ab1r, alias_ab1w, alias_ab1w_nowriteindex)).indexMatcher("write", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1, alias_ab1w, alias_ab1w_nowriteindex)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1)).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedTo(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_bw1, alias_ab1r, alias_ab1w));
    static TestSgConfig.User LIMITED_USER_AB1_ALIAS_READ_ONLY = new TestSgConfig.User("limited_user_alias_AB1_read_only").description("read/only on alias_ab1w, but with write privs in write index index_aw1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_WRITE", "indices:admin/refresh").on("index_aw1").aliasPermissions("SGS_READ").on("alias_ab1w")).indexMatcher("read", IndexApiMatchers.limitedTo(index_aw1, index_aw2, index_bw1, alias_ab1w)).indexMatcher("write", IndexApiMatchers.limitedTo(index_aw1, alias_ab1w)).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_ALIAS_C1 = new TestSgConfig.User("limited_user_alias_C1").description("alias_c1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_WRITE", "SGS_INDICES_MONITOR").on("alias_c1")).indexMatcher("read", IndexApiMatchers.limitedTo(index_cr1, index_cw1, alias_c1)).indexMatcher("write", IndexApiMatchers.limitedTo(index_cr1, index_cw1, alias_c1)).indexMatcher("create_index", IndexApiMatchers.limitedTo(index_cw1)).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedTo(alias_c1));
    static TestSgConfig.User LIMITED_READ_ONLY_ALL = new TestSgConfig.User("limited_read_only_all").description("read/only on *").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ").on("*")).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_READ_ONLY_A = new TestSgConfig.User("limited_read_only_A").description("read/only on index_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ").on("index_a*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_ar1, index_ar2, index_aw1, index_aw2)).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_NONE = new TestSgConfig.User("limited_user_none").description("no privileges for existing indices").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_CRUD", "SGS_INDICES_MONITOR").on("index_does_not_exist_*")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS = new TestSgConfig.User("invalid_user_index_permissions_for_alias").description("invalid: index permissions for alias").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_CRUD", "SGS_INDICES_MONITOR", "SGS_CREATE_INDEX").on("alias_ab1")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_index", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("write", IndexApiMatchers.unlimited()).indexMatcher("create_index", IndexApiMatchers.unlimited()).indexMatcher("manage_index", IndexApiMatchers.unlimited()).indexMatcher("manage_alias", IndexApiMatchers.unlimited()).indexMatcher("get_alias", IndexApiMatchers.unlimited());
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("write", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("create_index", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("manage_index", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("manage_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices());
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)LIMITED_USER_A, (Object)LIMITED_USER_B, (Object)LIMITED_USER_B_CREATE_INDEX, (Object[])new TestSgConfig.User[]{LIMITED_USER_B_MANAGE_INDEX, LIMITED_USER_B_MANAGE_INDEX_ALIAS, LIMITED_USER_B_HIDDEN_MANAGE_INDEX_ALIAS, LIMITED_USER_AB_MANAGE_INDEX, LIMITED_USER_C, LIMITED_USER_AB1_ALIAS, LIMITED_USER_AB1_ALIAS_READ_ONLY, LIMITED_USER_ALIAS_C1, LIMITED_READ_ONLY_ALL, LIMITED_READ_ONLY_A, LIMITED_USER_NONE, INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS, UNLIMITED_USER, SUPER_UNLIMITED_USER});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().nodeSettings("action.destructive_requires_name", false).users(USERS).indices(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_br2, index_bw1, index_bw2, index_cr1, index_cw1, index_hidden).aliases(alias_ab1r, alias_ab1w, alias_ab1w_nowriteindex, alias_c1).authzDebug(true).embedded().build();
    final TestSgConfig.User user;

    @Test
    public void putDocument() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/index_bw1/_doc/put_test_1", (Document<?>)DocNode.of((String)"a", (Object)1));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bw1).at("_index").but(this.user.indexMatcher("write")).whenEmpty(403));
        }
    }

    @Test
    public void deleteDocument() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse httpResponse = adminRestClient.putJson("/index_bw1/_doc/put_delete_test_1?refresh=true", (Document<?>)DocNode.of((String)"a", (Object)1));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            httpResponse = restClient.delete("/index_bw1/_doc/put_delete_test_1", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bw1).at("_index").but(this.user.indexMatcher("write")).whenEmpty(403));
        }
    }

    @Test
    public void deleteByQuery_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse httpResponse = adminRestClient.putJson("/index_bw1/_doc/put_delete_delete_by_query_b1?refresh=true", (Document<?>)DocNode.of((String)"delete_by_query_test", (Object)"yes"));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            httpResponse = adminRestClient.putJson("/index_bw1/_doc/put_delete_delete_by_query_b2?refresh=true", (Document<?>)DocNode.of((String)"delete_by_query_test", (Object)"no"));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            httpResponse = adminRestClient.putJson("/index_aw1/_doc/put_delete_delete_by_query_a1?refresh=true", (Document<?>)DocNode.of((String)"delete_by_query_test", (Object)"yes"));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            httpResponse = adminRestClient.putJson("/index_aw1/_doc/put_delete_delete_by_query_a2?refresh=true", (Document<?>)DocNode.of((String)"delete_by_query_test", (Object)"no"));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            httpResponse = restClient.postJson("/index_aw*,index_bw*/_delete_by_query?refresh=true&wait_for_completion=true", (Map<String, Object>)DocNode.of((String)"query.term.delete_by_query_test", (Object)"yes"), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_aw1, index_aw2, index_bw1, index_bw2).at("_index").but(this.user.indexMatcher("write")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
                int expectedDeleteCount = IndexApiMatchers.containsExactly(index_aw1, index_bw1).at("_index").but(this.user.indexMatcher("write")).size();
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("deleted", IsEqual.equalTo((Object)expectedDeleteCount))}));
            }
        }
    }

    @Test
    public void putDocument_bulk() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/index_aw1/_doc/new_doc_aw1", "/index_bw1/_doc/new_doc_bw1", "/index_cw1/_doc/new_doc_cw1");
            IndexApiMatchers.IndexMatcher writePrivileges = this.user.indexMatcher("write");
            DocNode testDoc = DocNode.of((String)"a", (Object)1);
            GenericRestClient.HttpResponse httpResponse = restClient.putNdJson("/_bulk?refresh=true", new Document[]{DocNode.of((String)"index._index", (Object)"index_aw1", (String)"index._id", (Object)"new_doc_aw1"), testDoc, DocNode.of((String)"index._index", (Object)"index_bw1", (String)"index._id", (Object)"new_doc_bw1"), testDoc, DocNode.of((String)"index._index", (Object)"index_cw1", (String)"index._id", (Object)"new_doc_cw1"), testDoc});
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_aw1, index_bw1, index_cw1).at("items[*].index[?(@.result == 'created')]._index").but(writePrivileges).whenEmpty(200));
            MatcherAssert.assertThat(cluster.documents(index_aw1, index_bw1, index_cw1), (Matcher)IndexApiMatchers.containsExactly(writePrivileges.covers(index_aw1) ? index_aw1.withAdditionalDocument("new_doc_aw1", testDoc) : index_aw1, writePrivileges.covers(index_bw1) ? index_bw1.withAdditionalDocument("new_doc_bw1", testDoc) : index_bw1, writePrivileges.covers(index_cw1) ? index_cw1.withAdditionalDocument("new_doc_cw1", testDoc) : index_cw1));
        }
    }

    @Test
    public void putDocument_alias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/alias_ab1w/_doc/put_doc_alias_test_1", (Document<?>)DocNode.of((String)"a", (Object)1));
            if (IndexApiMatchers.containsExactly(alias_ab1w, index_aw1).but(this.user.indexMatcher("write")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_aw1).at("_index").but(this.user.indexMatcher("write")).whenEmpty(403));
            }
        }
    }

    @Test
    public void putDocument_alias_noWriteIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/alias_ab1w_nowriteindex/_doc/put_doc_alias_test_1", (Document<?>)DocNode.of((String)"a", (Object)1));
            if (IndexApiMatchers.containsExactly(alias_ab1w_nowriteindex).but(this.user.indexMatcher("write")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
            }
        }
    }

    @Test
    public void putDocument_bulk_alias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/index_aw1/_doc/put_doc_alias_bulk_test_1");
            GenericRestClient.HttpResponse httpResponse = restClient.putNdJson("/_bulk?refresh=true", new Document[]{DocNode.of((String)"index._index", (Object)"alias_ab1w", (String)"index._id", (Object)"put_doc_alias_bulk_test_1"), DocNode.of((String)"a", (Object)1)});
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_aw1).at("items[*].index[?(@.result == 'created')]._index").but(this.user.indexMatcher("write")).whenEmpty(200));
        }
    }

    @Test
    public void putDocument_noExistingIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/index_bwx1");
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/index_bwx1/_doc/put_doc_non_existing_index_test_1", (Document<?>)DocNode.of((String)"a", (Object)1));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bwx1).at("_index").but(this.user.indexMatcher("create_index")).whenEmpty(403));
        }
    }

    @Test
    public void createIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/index_bwx1", (Document<?>)DocNode.EMPTY);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bwx1).at("index").but(this.user.indexMatcher("create_index")).whenEmpty(403));
        }
    }

    @Test
    public void createIndex_deleteIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/index_bwx1", (Document<?>)DocNode.EMPTY);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bwx1).at("index").but(this.user.indexMatcher("create_index")).whenEmpty(403));
            httpResponse = restClient.delete("/index_bwx1", new Header[0]);
            if (this.user.indexMatcher("manage_index").isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
    }

    @Test
    public void createIndex_withAlias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/index_bwx1", (Document<?>)DocNode.of((String)"aliases.alias_bwx", (Object)DocNode.EMPTY));
            if (IndexApiMatchers.containsExactly(alias_bwx).but(this.user.indexMatcher("manage_alias")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bwx1).at("index").but(this.user.indexMatcher("create_index")).whenEmpty(403));
            }
        }
    }

    @Test
    public void deleteAlias_staticIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            restClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.index", (Object)"index_bw1", (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.delete("/index_bw1/_aliases/alias_bwx", new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void deleteAlias_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            adminRestClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.index", (Object)"index_bw1", (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.delete("/*/_aliases/alias_bwx", new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_createAlias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.index", (Object)"index_bw1", (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_createAlias_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.indices", (Object)DocNode.array((Object[])new Object[]{"index_bw*"}), (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, index_bw2, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_deleteAlias_staticIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            adminRestClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.index", (Object)"index_bw1", (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"remove.index", (Object)"index_bw1", (String)"remove.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_deleteAlias_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            adminRestClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.indices", (Object)DocNode.array((Object[])new Object[]{"index_bw1", "index_bw2"}), (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"remove.index", (Object)"*", (String)"remove.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bw1, index_bw2, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_removeIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            adminRestClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.putJson("/index_bwx1", (Document<?>)DocNode.of((String)"aliases.alias_bwx", (Object)DocNode.EMPTY));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = adminRestClient.putJson("/index_bwx2", (Document<?>)DocNode.of((String)"aliases.alias_bwx", (Object)DocNode.EMPTY));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"remove_index.index", (Object)"index_bwx1")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bwx2).isCoveredBy(this.user.indexMatcher("manage_index"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void reindex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/index_bwx1");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_reindex", (Map<String, Object>)DocNode.of((String)"source.index", (Object)"index_br1", (String)"dest.index", (Object)"index_bwx1"), new Header[0]);
            if (IndexApiMatchers.containsExactly(index_bwx1).but(this.user.indexMatcher("create_index")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
                MatcherAssert.assertThat((Object)cluster.getAdminCertRestClient().get("/index_bwx1/_search", new Header[0]), RestMatchers.isNotFound());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)cluster.getAdminCertRestClient().get("/index_bwx1/_search", new Header[0]), RestMatchers.isOk());
            }
        }
    }

    @Test
    public void reindex2() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/index_bwx1");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_reindex", (Map<String, Object>)DocNode.of((String)"source.index", (Object)"index_ar1", (String)"dest.index", (Object)"index_bwx1"), new Header[0]);
            if (this.user == UNLIMITED_USER || this.user == SUPER_UNLIMITED_USER || this.user == LIMITED_USER_AB_MANAGE_INDEX) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cloneIndex() throws Exception {
        String sourceIndex = "index_bw1";
        String targetIndex = "index_bwx1";
        Client client = cluster.getInternalNodeClient();
        client.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{sourceIndex}).settings(Settings.builder().put("index.blocks.write", true).build())).actionGet();
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed(targetIndex);
            GenericRestClient.HttpResponse httpResponse = restClient.post(sourceIndex + "/_clone/" + targetIndex);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bwx1).at("index").but(this.user.indexMatcher("manage_index")).whenEmpty(403));
        }
        catch (Throwable throwable) {
            cluster.getInternalNodeClient().admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{sourceIndex}).settings(Settings.builder().put("index.blocks.write", false).build())).actionGet();
            throw throwable;
        }
        cluster.getInternalNodeClient().admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{sourceIndex}).settings(Settings.builder().put("index.blocks.write", false).build())).actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/index_bw1/_close");
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bw1).at("indices.keys()").but(this.user.indexMatcher("manage_index")).whenEmpty(403));
        }
        catch (Throwable throwable) {
            cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"index_bw1"})).actionGet();
            throw throwable;
        }
        cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"index_bw1"})).actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeIndex_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/*/_close");
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_br2, index_bw1, index_bw2, index_cr1, index_cw1).at("indices.keys()").but(this.user.indexMatcher("manage_index")).whenEmpty(403));
        }
        catch (Throwable throwable) {
            cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"*"})).actionGet();
            throw throwable;
        }
        cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"*"})).actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeIndex_openIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/index_bw1/_close");
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_bw1).at("indices.keys()").but(this.user.indexMatcher("manage_index")).whenEmpty(403));
            httpResponse = restClient.post("/index_bw1/_open");
            if (IndexApiMatchers.containsExactly(index_bw1).but(this.user.indexMatcher("manage_index")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
        catch (Throwable throwable) {
            cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"index_bw1"})).actionGet();
            throw throwable;
        }
        cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"index_bw1"})).actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeIndex_openIndex_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/*/_close");
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_br2, index_bw1, index_bw2, index_cr1, index_cw1).at("indices.keys()").but(this.user.indexMatcher("manage_index")).whenEmpty(403));
            httpResponse = restClient.post("/*/_open");
            if (IndexApiMatchers.containsExactly(index_ar1, index_ar2, index_aw1, index_aw2, index_br1, index_br2, index_bw1, index_bw2, index_cr1, index_cw1).but(this.user.indexMatcher("manage_index")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
        catch (Throwable throwable) {
            cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"*"})).actionGet();
            throw throwable;
        }
        cluster.getInternalNodeClient().admin().indices().open(new OpenIndexRequest(new String[]{"*"})).actionGet();
    }

    @After
    public void refresh() {
        cluster.getInternalNodeClient().admin().indices().refresh(new RefreshRequest(new String[]{"*"})).actionGet();
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (TestSgConfig.User user : USERS) {
            result.add(new Object[]{user, user.getDescription()});
        }
        return result;
    }

    public IndexAuthorizationReadWriteIntTests(TestSgConfig.User user, String description) throws Exception {
        this.user = user;
    }
}

