/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.license.SearchGuardLicense;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SearchGuardLicenseTest {
    @Test
    public void validate_shouldReturnErrorWhenCurrentDateDoesNotFallsWithinThirtyDaysBeforeStartDate() {
        LocalDate startDate = LocalDate.now().plusDays(40L);
        String issueDate = this.dateToString(startDate.minusDays(50L));
        String expiryDate = this.dateToString(startDate.plusDays(30L));
        String startDateStr = this.dateToString(startDate);
        SearchGuardLicense searchGuardLicense = new SearchGuardLicense(UUID.randomUUID().toString(), SearchGuardLicense.Type.FULL, SearchGuardLicense.Feature.values(), issueDate, expiryDate, "abc", "SG", startDateStr, Integer.valueOf(7), "abc", 1);
        ValidationErrors validationErrors = searchGuardLicense.staticValidate();
        Map errors = validationErrors.getErrors();
        MatcherAssert.assertThat((Object)errors.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"start_date"), (Matcher)Matchers.anything()));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasKey((Matcher)Matchers.equalTo((Object)"start_date")));
        MatcherAssert.assertThat((Object)((Collection)errors.get("start_date")), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)((Collection)errors.get("start_date")).iterator().next()).getMessage(), (Matcher)Matchers.equalTo((Object)("License cannot be applied earlier than " + DateTimeFormatter.ISO_DATE.format(startDate.minusDays(30L)))));
    }

    @Test
    public void validate_shouldNotReturnErrorWhenCurrentDateFallsWithinThirtyDaysBeforeStartDate() {
        LocalDate startDate = LocalDate.now().plusDays(25L);
        String issueDate = this.dateToString(startDate.minusDays(50L));
        String expiryDate = this.dateToString(startDate.plusDays(30L));
        String startDateStr = this.dateToString(startDate);
        SearchGuardLicense searchGuardLicense = new SearchGuardLicense(UUID.randomUUID().toString(), SearchGuardLicense.Type.FULL, SearchGuardLicense.Feature.values(), issueDate, expiryDate, "abc", "SG", startDateStr, Integer.valueOf(7), "abc", 1);
        ValidationErrors validationErrors = searchGuardLicense.staticValidate();
        Map errors = validationErrors.getErrors();
        MatcherAssert.assertThat((Object)errors.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    private String dateToString(LocalDate date) {
        return DateTimeFormatter.ISO_DATE.format(date);
    }
}

