/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestIndex;
import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.filter.ValueNodes;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class RestMatchers {
    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isOk() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 200 OK");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 200) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 200 OK: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isCreated() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 201 Created");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 201) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 201 Created: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isNotFound() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 404 Not Found");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 404) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 404 Not Found: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isForbidden() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 403 Forbidden");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 403) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 403 Forbidden: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isUnauthorized() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 401 Unauthorized");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 401) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 401 Unauthorized: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isBadRequest() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 400 Bad Request");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 400) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 400 Bad Request: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isBadRequest(final String jsonPath, final String patternString) {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 400 Bad Request with the value ").appendValue((Object)patternString).appendText(" at ").appendValue((Object)jsonPath);
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() != 400) {
                    mismatchDescription.appendText("Status is not 400 Bad Request: ").appendText("\n").appendValue(item);
                    return false;
                }
                try {
                    String value = (String)response.getBodyAsDocNode().findSingleValueByJsonPath(jsonPath, String.class);
                    if (value == null) {
                        mismatchDescription.appendText("Could not find value at " + jsonPath).appendText("\n").appendValue(item);
                        return false;
                    }
                    Pattern pattern = Pattern.create((String)patternString);
                    if (pattern.test((Object)value)) {
                        return true;
                    }
                    mismatchDescription.appendText("Value at " + jsonPath + " does not match ").appendValue((Object)patternString).appendText("\n").appendValue(item);
                    return false;
                }
                catch (Exception e) {
                    mismatchDescription.appendText("Parsing request body failed with " + e).appendText("\n").appendValue(item);
                    return false;
                }
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> isInternalServerError() {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Response has status 500 Internal Server Error");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() == 500) {
                    return true;
                }
                mismatchDescription.appendText("Status is not 500 Internal Server Error: ").appendValue(item);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<GenericRestClient.HttpResponse> json(final BaseMatcher<?> ... subMatchers) {
        return new DiagnosingMatcher<GenericRestClient.HttpResponse>(){

            public void describeTo(Description description) {
                description.appendText("Got JSON");
                if (subMatchers.length > 0) {
                    description.appendText(" where ");
                }
                for (BaseMatcher subMatcher : subMatchers) {
                    subMatcher.describeTo(description);
                }
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                String contentType;
                if (!(item instanceof GenericRestClient.HttpResponse)) {
                    mismatchDescription.appendValue(item).appendText(" is not a HttpResponse");
                    return false;
                }
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                String string = contentType = response.getContentType() != null ? response.getContentType().toLowerCase() : "";
                if (!contentType.startsWith("application/json")) {
                    mismatchDescription.appendText("Response does not have the content type application/json: ").appendValue((Object)(response.getContentType() + "; " + response.getHeaders()));
                    return false;
                }
                try {
                    DocNode docNode = response.getBodyAsDocNode();
                    boolean ok = true;
                    for (BaseMatcher subMatcher : subMatchers) {
                        if (subMatcher.matches((Object)docNode)) continue;
                        subMatcher.describeMismatch((Object)docNode, mismatchDescription);
                        mismatchDescription.appendText("\nResponse Body:\n").appendText(response.getBody());
                        ok = false;
                    }
                    return ok;
                }
                catch (DocumentParseException | Format.UnknownDocTypeException e) {
                    mismatchDescription.appendText("Response cannot be parsed as JSON: " + e.toString()).appendValue((Object)response.getBody());
                    return false;
                }
            }
        };
    }

    public static DiagnosingMatcher<ValueNodes.JsonNode> nodeAt(final String jsonPath, final Matcher<?> subMatcher) {
        return new DiagnosingMatcher<ValueNodes.JsonNode>(){

            public void describeTo(Description description) {
                description.appendText("element at ").appendValue((Object)jsonPath).appendText(" matches ").appendDescriptionOf((SelfDescribing)subMatcher);
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DocNode)) {
                    mismatchDescription.appendValue(item != null ? item.getClass() : "null").appendText(" is not a DocNode");
                    return false;
                }
                Configuration config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(BasicJsonPathDefaultConfiguration.JSON_PROVIDER).mappingProvider(BasicJsonPathDefaultConfiguration.MAPPING_PROVIDER).build();
                Object value = JsonPath.using((Configuration)config).parse(item).read(jsonPath, new Predicate[0]);
                if (value == null) {
                    mismatchDescription.appendText("No value at " + jsonPath + " ").appendValue(item);
                    return false;
                }
                if (value instanceof DocNode) {
                    value = ((DocNode)value).toBasicObject();
                }
                if (subMatcher.matches(value)) {
                    return true;
                }
                mismatchDescription.appendText("at " + jsonPath + ": ").appendValue(value).appendText("\n");
                subMatcher.describeMismatch(value, mismatchDescription);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<ValueNodes.JsonNode> distinctNodesAt(final String jsonPath, final Matcher<?> subMatcher) {
        return new DiagnosingMatcher<ValueNodes.JsonNode>(){

            public void describeTo(Description description) {
                description.appendText("element at ").appendValue((Object)jsonPath).appendText(" matches ").appendDescriptionOf((SelfDescribing)subMatcher);
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DocNode)) {
                    mismatchDescription.appendValue(item != null ? item.getClass() : "null").appendText(" is not a DocNode");
                    return false;
                }
                Configuration config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(BasicJsonPathDefaultConfiguration.JSON_PROVIDER).mappingProvider(BasicJsonPathDefaultConfiguration.MAPPING_PROVIDER).build();
                HashSet value = JsonPath.using((Configuration)config).parse(item).read(jsonPath, new Predicate[0]);
                if (value == null) {
                    mismatchDescription.appendText("No value at " + jsonPath + " ").appendValue(item);
                    return false;
                }
                if (value instanceof DocNode) {
                    value = ((DocNode)value).toBasicObject();
                }
                if (value instanceof Collection) {
                    value = new HashSet(value);
                }
                if (subMatcher.matches((Object)value)) {
                    return true;
                }
                String valueString = ((Object)value).toString();
                if (valueString.length() < 80) {
                    mismatchDescription.appendText("at " + jsonPath + ": ").appendValue((Object)valueString).appendText("\n");
                } else {
                    mismatchDescription.appendText("at " + jsonPath + ": ").appendText("\n");
                }
                subMatcher.describeMismatch(value, mismatchDescription);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<Object> matches(TestIndex ... testIndices) {
        HashMap<String, TestIndex> indexNameMap = new HashMap<String, TestIndex>();
        for (TestIndex testIndex : testIndices) {
            indexNameMap.put(testIndex.getName(), testIndex);
        }
        return RestMatchers.matches(indexNameMap);
    }

    public static DiagnosingMatcher<Object> matches(String prefix, TestIndex ... testIndices) {
        HashMap<String, TestIndex> indexNameMap = new HashMap<String, TestIndex>();
        for (TestIndex testIndex : testIndices) {
            indexNameMap.put(prefix + ":" + testIndex.getName(), testIndex);
        }
        return RestMatchers.matches(indexNameMap);
    }

    public static DiagnosingMatcher<Object> matches(TestIndex testIndex1, String prefix2, TestIndex testIndex2) {
        return RestMatchers.matches((Map<String, TestIndex>)ImmutableMap.of((Object)testIndex1.getName(), (Object)testIndex1, (Object)(prefix2 + ":" + testIndex2.getName()), (Object)testIndex2));
    }

    public static DiagnosingMatcher<Object> matches(final Map<String, TestIndex> indexNameMap) {
        final HashSet<CallSite> pendingDocuments = new HashSet<CallSite>();
        for (Map.Entry<String, TestIndex> entry : indexNameMap.entrySet()) {
            for (String id : entry.getValue().getTestData().getRetainedDocuments().keySet()) {
                pendingDocuments.add((CallSite)((Object)(entry.getKey() + "/" + id)));
            }
        }
        return new DiagnosingMatcher<Object>(){

            public void describeTo(Description description) {
                description.appendText("content of indices " + indexNameMap.keySet().stream().collect(Collectors.joining(", ")));
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof Collection)) {
                    mismatchDescription.appendText("Not a collection: ").appendValue(item);
                    return false;
                }
                Collection collection = (Collection)item;
                for (Object object : collection) {
                    DocNode docNode = DocNode.wrap(object);
                    TestIndex index = (TestIndex)indexNameMap.get(docNode.getAsString("_index"));
                    if (index == null) {
                        mismatchDescription.appendText("result contains unknown index: ").appendValue((Object)docNode.getAsString("_index")).appendText("; expected: ").appendValue(indexNameMap.keySet()).appendText("\ndocument: ").appendText(docNode.toJsonString());
                        return false;
                    }
                    Map<String, ?> document = index.getTestData().getRetainedDocuments().get(docNode.getAsString("_id"));
                    if (document == null) {
                        mismatchDescription.appendText("result contains unknown document id ").appendValue((Object)docNode.getAsString("_id")).appendText(" for index ").appendValue((Object)docNode.getAsString("_index")).appendText("\ndocument: ").appendText(docNode.toJsonString());
                        return false;
                    }
                    if (!document.equals(docNode.get("_source"))) {
                        mismatchDescription.appendText("result document ").appendValue((Object)docNode.getAsString("_id")).appendText(" in index ").appendValue((Object)docNode.getAsString("_index")).appendText(" does not match expected document:\n").appendText(docNode.getAsNode("_source").toJsonString()).appendText("\n").appendText(DocNode.wrap(document).toJsonString());
                        return false;
                    }
                    pendingDocuments.remove(docNode.getAsString("_index") + "/" + docNode.getAsString("_id"));
                }
                if (!pendingDocuments.isEmpty()) {
                    mismatchDescription.appendText("result does not contain expected documents: ").appendValue((Object)pendingDocuments);
                    return false;
                }
                return true;
            }
        };
    }

    public static DiagnosingMatcher<Object> matchesDocCount(TestIndex ... testIndices) {
        HashMap<String, TestIndex> indexNameMap = new HashMap<String, TestIndex>();
        for (TestIndex testIndex : testIndices) {
            indexNameMap.put(testIndex.getName(), testIndex);
        }
        return RestMatchers.matchesDocCount(indexNameMap);
    }

    public static DiagnosingMatcher<Object> matchesDocCount(final Map<String, TestIndex> indexNameMap) {
        final HashSet<String> pendingIndices = new HashSet<String>(indexNameMap.keySet());
        return new DiagnosingMatcher<Object>(){

            public void describeTo(Description description) {
                description.appendText("doc count of indices " + indexNameMap.keySet().stream().collect(Collectors.joining(", ")));
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof Collection)) {
                    mismatchDescription.appendText("Not a collection: ").appendValue(item);
                    return false;
                }
                Collection collection = (Collection)item;
                for (Object object : collection) {
                    Number actualDocCount;
                    DocNode docNode = DocNode.wrap(object);
                    TestIndex index = (TestIndex)indexNameMap.get(docNode.getAsString("key"));
                    if (index == null) {
                        mismatchDescription.appendText("result contains unknown index: ").appendValue((Object)docNode.getAsString("key")).appendText("; expected: ").appendValue(indexNameMap.keySet()).appendText("\ndocument: ").appendText(docNode.toJsonString());
                        return false;
                    }
                    int expectedDocCount = index.getTestData().getSize();
                    try {
                        actualDocCount = docNode.getAsNode("doc_count").toNumber();
                    }
                    catch (ConfigValidationException e) {
                        mismatchDescription.appendText("result doc count").appendValue((Object)docNode.getAsNode("doc_count")).appendText(" for index ").appendValue((Object)docNode.getAsString("key")).appendText(" is not a number; expected doc count ").appendValue((Object)expectedDocCount);
                        return false;
                    }
                    if (actualDocCount == null || actualDocCount.intValue() != expectedDocCount) {
                        mismatchDescription.appendText("result doc count").appendValue((Object)actualDocCount).appendText(" for index ").appendValue((Object)docNode.getAsString("key")).appendText(" does not match expected doc count ").appendValue((Object)expectedDocCount);
                        return false;
                    }
                    pendingIndices.remove(docNode.getAsString("key"));
                }
                if (!pendingIndices.isEmpty()) {
                    mismatchDescription.appendText("result does not contain expected indices: ").appendValue((Object)pendingIndices);
                    return false;
                }
                return true;
            }
        };
    }
}

