/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.cli.MavenCli;

public class SgPluginPackage {
    private static final CompletableFuture<SgPluginPackage> result = new CompletableFuture();
    private static boolean building = false;
    private final File file;

    public static synchronized CompletableFuture<SgPluginPackage> get() {
        if (result.isDone() || building) {
            return result;
        }
        building = true;
        String externalFile = System.getProperty("sg.tests.sg_plugin.file");
        if (externalFile != null) {
            if (!new File(externalFile).exists()) {
                result.completeExceptionally(new RuntimeException("File specified by sg.tests.sg_plugin.file does not exist: " + externalFile));
            } else {
                SgPluginPackage instance = new SgPluginPackage(new File(externalFile));
                result.complete(instance);
            }
        } else {
            new Thread(() -> {
                try {
                    SgPluginPackage instance = new SgPluginPackage(SgPluginPackage.buildSgPluginFile());
                    result.complete(instance);
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }).start();
        }
        return result;
    }

    private SgPluginPackage(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static File findProjectRootDir() {
        for (File dir = new File(".").getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
            if (!new File(dir, "plugin").exists() || !new File(dir, "pom.xml").exists()) continue;
            return dir;
        }
        throw new RuntimeException("Could not find project root directory");
    }

    private static File buildSgPluginFile() {
        File projectRoot = SgPluginPackage.findProjectRootDir();
        File pluginBuildTarget = new File(projectRoot, "plugin/target/releases/");
        if (pluginBuildTarget.exists()) {
            for (File f : pluginBuildTarget.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
        }
        System.setProperty("maven.multiModuleProjectDirectory", projectRoot.getAbsolutePath());
        MavenCli cli = new MavenCli();
        int rc = cli.doMain(new String[]{"--no-transfer-progress", "--quiet", "--batch-mode", "install", "-DskipTests=true", "-Pquick"}, projectRoot.getAbsolutePath(), null, null);
        if (rc != 0) {
            throw new RuntimeException("mvn install failed");
        }
        for (File f : pluginBuildTarget.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith("search-guard-flx-elasticsearch-plugin")) continue;
            return f;
        }
        throw new RuntimeException("Could not find plugin file in " + pluginBuildTarget);
    }
}

