/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.legacy;

import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class LegacyAnonAuthenticationDomain
implements AuthenticationDomain<HttpAuthenticationFrontend> {
    private final ComponentState componentState = new ComponentState(0, "auth_domain", "legacy_anon").initialized();
    private final HttpAuthenticationFrontend frontend = new LegacyHTTPAuthenticator(){
        private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "legacy_anon").initialized();

        @Override
        public String getType() {
            return "anon";
        }

        @Override
        public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) throws ElasticsearchSecurityException {
            if (request.header("authorization") == null) {
                return AuthCredentials.forUser("sg_anonymous").backendRoles("sg_anonymous_backendrole").complete().build();
            }
            return null;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    };

    @Override
    public HttpAuthenticationFrontend getFrontend() {
        return this.frontend;
    }

    @Override
    public String getId() {
        return "anon";
    }

    @Override
    public boolean accept(RequestMetaData<?> request) {
        return true;
    }

    @Override
    public boolean accept(AuthCredentials authCredentials) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String toString() {
        return "anon";
    }

    @Override
    public CompletableFuture<User> authenticate(AuthCredentials authCredentials, AuthenticationDebugLogger debug) throws AuthenticatorUnavailableException, CredentialsException {
        return CompletableFuture.completedFuture(AuthenticationBackend.UserMapper.DIRECT.map(authCredentials));
    }

    @Override
    public CompletableFuture<User> impersonate(User originalUser, AuthCredentials authCredentials) throws AuthenticatorUnavailableException, CredentialsException {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getType() {
        return "anon";
    }

    @Override
    public boolean cacheUser() {
        return false;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

