/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.config;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.config.text.PatternMap;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.support.IPAddressCollection;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.google.common.collect.ArrayListMultimap;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.transport.TransportAddress;

public class RoleMapping
implements Document<RoleMapping>,
Hideable {
    private static final Logger log = LogManager.getLogger(RoleMapping.class);
    private final DocNode source;
    private final boolean reserved;
    private final boolean hidden;
    private final Pattern backendRoles;
    private final Pattern users;
    private final Pattern hosts;
    private final IPAddressCollection ips;
    private final ImmutableSet<Pattern> andBackendRoles;
    private final String description;

    public static ValidationResult<RoleMapping> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        boolean reserved = vNode.get("reserved").withDefault(false).asBoolean();
        boolean hidden = vNode.get("hidden").withDefault(false).asBoolean();
        Pattern backendRoles = (Pattern)vNode.get("backend_roles").by(Pattern::parse);
        Pattern hosts = (Pattern)vNode.get("hosts").by(Pattern::parse);
        Pattern users = (Pattern)vNode.get("users").by(Pattern::parse);
        ImmutableSet andBackendRoles = vNode.hasNonNull("and_backend_roles") ? ImmutableSet.of((Collection)vNode.get("and_backend_roles").asList().ofObjectsParsedBy(Pattern::parse)) : null;
        IPAddressCollection ips = (IPAddressCollection)vNode.get("ips").by(IPAddressCollection::parse);
        String description = vNode.get("description").asString();
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new RoleMapping(docNode, reserved, hidden, backendRoles, users, hosts, ips, (ImmutableSet<Pattern>)andBackendRoles, description), validationErrors);
    }

    public RoleMapping(DocNode docNode, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, (Parser.Context)context);
        this.source = docNode;
        this.reserved = vNode.get("reserved").withDefault(false).asBoolean();
        this.hidden = vNode.get("hidden").withDefault(false).asBoolean();
        this.backendRoles = (Pattern)vNode.get("backend_roles").by(Pattern::parse);
        this.hosts = (Pattern)vNode.get("hosts").by(Pattern::parse);
        this.users = (Pattern)vNode.get("users").by(Pattern::parse);
        this.andBackendRoles = vNode.hasNonNull("and_backend_roles") ? ImmutableSet.of((Collection)vNode.get("and_backend_roles").asList().ofObjectsParsedBy(Pattern::parse)) : null;
        this.ips = (IPAddressCollection)vNode.get("ips").by(IPAddressCollection::parse);
        this.description = vNode.get("description").asString();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
    }

    public RoleMapping(DocNode source, boolean reserved, boolean hidden, Pattern backendRoles, Pattern users, Pattern hosts, IPAddressCollection ips, ImmutableSet<Pattern> andBackendRoles, String description) {
        this.source = source;
        this.reserved = reserved;
        this.hidden = hidden;
        this.backendRoles = backendRoles;
        this.users = users;
        this.hosts = hosts;
        this.ips = ips;
        this.andBackendRoles = andBackendRoles;
        this.description = description;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public Pattern getBackendRoles() {
        return this.backendRoles;
    }

    public Pattern getHosts() {
        return this.hosts;
    }

    public IPAddressCollection getIps() {
        return this.ips;
    }

    public Pattern getUsers() {
        return this.users;
    }

    public ImmutableSet<Pattern> getAndBackendRoles() {
        return this.andBackendRoles;
    }

    public String getDescription() {
        return this.description;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public static class InvertedIndex
    implements ComponentStateProvider {
        private static final IPAddressNetwork.IPAddressGenerator ipAddressGenerator = new IPAddressNetwork.IPAddressGenerator();
        private final PatternMap<String> byUsers;
        private final PatternMap<String> byBackendRoles;
        private final PatternMap<String> byHostNames;
        private final ImmutableMap<IPAddressCollection, ImmutableSet<String>> byIps;
        private final ImmutableMap<ImmutableSet<Pattern>, ImmutableSet<String>> byBackendRolesAnded;
        private final ComponentState componentState = new ComponentState("role_mapping_index");
        private final MetricsLevel metricsLevel;
        private final Measurement<?> evaluations;

        public InvertedIndex(SgDynamicConfiguration<RoleMapping> roleMappings, MetricsLevel metricsLevel) {
            PatternMap.Builder users = new PatternMap.Builder();
            PatternMap.Builder backendRoles = new PatternMap.Builder();
            PatternMap.Builder hosts = new PatternMap.Builder();
            ArrayListMultimap ips = ArrayListMultimap.create();
            ArrayListMultimap andBackendRoles = ArrayListMultimap.create();
            for (Map.Entry entry : roleMappings.getCEntries().entrySet()) {
                String role = (String)entry.getKey();
                RoleMapping mapping = (RoleMapping)entry.getValue();
                users.add(mapping.getUsers(), (Object)role);
                backendRoles.add(mapping.getBackendRoles(), (Object)role);
                hosts.add(mapping.getHosts(), (Object)role);
                if (mapping.getIps() != null && !mapping.getIps().getSource().isEmpty()) {
                    for (String ip : mapping.getIps().getSource()) {
                        ips.put((Object)ip, (Object)role);
                    }
                }
                if (mapping.getAndBackendRoles() == null || mapping.getAndBackendRoles().isEmpty()) continue;
                andBackendRoles.put((Object)ImmutableSet.of(mapping.getAndBackendRoles()), (Object)role);
            }
            this.byUsers = users.build();
            this.byBackendRoles = backendRoles.build();
            this.byHostNames = hosts.build();
            this.byIps = ImmutableMap.map((Map)ips.asMap(), k -> InvertedIndex.ip(k), v -> ImmutableSet.of((Collection)v));
            this.byBackendRolesAnded = ImmutableMap.map((Map)andBackendRoles.asMap(), k -> k, v -> ImmutableSet.of((Collection)v));
            this.metricsLevel = metricsLevel;
            this.evaluations = metricsLevel == MetricsLevel.DETAILED ? new TimeAggregation.Milliseconds() : CountAggregation.noop();
            this.componentState.addMetrics("evaluations", this.evaluations);
            this.componentState.initialized();
        }

        public ImmutableSet<String> evaluate(User user, TransportAddress transportAddress, ResolutionMode rolesMappingResolution) {
            try (Meter meter = Meter.detail((MetricsLevel)this.metricsLevel, this.evaluations);){
                if (user == null) {
                    ImmutableSet immutableSet = ImmutableSet.empty();
                    return immutableSet;
                }
                ImmutableSet.Builder result = new ImmutableSet.Builder(user.getSearchGuardRoles());
                if (rolesMappingResolution == ResolutionMode.BOTH || rolesMappingResolution == ResolutionMode.BACKENDROLES_ONLY) {
                    result.addAll(user.getRoles());
                }
                if (rolesMappingResolution == ResolutionMode.BOTH || rolesMappingResolution == ResolutionMode.MAPPING_ONLY) {
                    result.addAll((Collection)this.byUsers.get(user.getName()));
                    result.addAll((Collection)this.byBackendRoles.get(user.getRoles()));
                    if (transportAddress != null) {
                        Meter subMeter;
                        if (!this.byHostNames.isEmpty()) {
                            subMeter = meter.detail("by_host_name");
                            try {
                                result.addAll((Collection)this.byHostNames.get(transportAddress.address().getHostName()));
                                result.addAll((Collection)this.byHostNames.get(transportAddress.getAddress()));
                            }
                            finally {
                                if (subMeter != null) {
                                    subMeter.close();
                                }
                            }
                        }
                        if (!this.byIps.isEmpty()) {
                            subMeter = meter.detail("by_ip");
                            try {
                                IPAddress ipAddress = ipAddressGenerator.from(transportAddress.address().getAddress());
                                for (Map.Entry entry : this.byIps.entrySet()) {
                                    if (!((IPAddressCollection)entry.getKey()).contains(ipAddress)) continue;
                                    result.addAll((Collection)entry.getValue());
                                }
                            }
                            finally {
                                if (subMeter != null) {
                                    subMeter.close();
                                }
                            }
                        }
                    }
                    if (!this.byBackendRolesAnded.isEmpty()) {
                        for (ImmutableSet patternSet : this.byBackendRolesAnded.keySet()) {
                            if (!patternSet.forAllApplies(p -> p.matches(user.getRoles()))) continue;
                            result.addAll((Collection)this.byBackendRolesAnded.get((Object)patternSet));
                        }
                    }
                }
                ImmutableSet immutableSet = result.build();
                return immutableSet;
            }
        }

        private static IPAddressCollection ip(String source) {
            try {
                return IPAddressCollection.parse(Collections.singletonList(source));
            }
            catch (Exception e) {
                log.error("Error while compiling IP address " + source, (Throwable)e);
                return null;
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    public static enum ResolutionMode {
        MAPPING_ONLY,
        BACKENDROLES_ONLY,
        BOTH;

    }
}

