/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class KibanaInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final MultiTenancyConfigurationProvider multiTenancyConfigurationProvider;
    private final ThreadContext threadContext;

    public KibanaInfoAction(PrivilegesEvaluator evaluator, ThreadPool threadPool, MultiTenancyConfigurationProvider multiTenancyConfigurationProvider) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        this.multiTenancyConfigurationProvider = multiTenancyConfigurationProvider;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/kibanainfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/kibanainfo"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                RestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)KibanaInfoAction.this.threadContext.getTransient("_sg_user");
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", KibanaInfoAction.this.evaluator.notFailOnForbiddenEnabled());
                    builder.field("kibana_mt_enabled", KibanaInfoAction.this.multiTenancyConfigurationProvider.isMultiTenancyEnabled());
                    builder.field("kibana_index", KibanaInfoAction.this.multiTenancyConfigurationProvider.getKibanaIndex());
                    builder.field("kibana_server_user", KibanaInfoAction.this.multiTenancyConfigurationProvider.getKibanaServerUser());
                    builder.field("kibana_rbac_enabled", false);
                    builder.endObject();
                    response = new RestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse(response);
            }
        };
    }

    public String getName() {
        return "Kibana Info Action";
    }
}

