/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.user.User;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class AuthcResult
implements ToXContentObject,
Document<AuthcResult> {
    public static final AuthcResult STOP = new AuthcResult(Status.STOP);
    public static final AuthcResult PASS_ANONYMOUS = new AuthcResult(User.ANONYMOUS, Status.PASS);
    public static final AuthcResult PASS_WITHOUT_AUTH = new AuthcResult(null, Status.PASS);
    private final User user;
    private final Status status;
    private final RestStatus restStatus;
    private final String restStatusMessage;
    private final String redirectUri;
    private final List<DebugInfo> debug;
    private final Map<String, List<String>> headers;

    public static AuthcResult stop(RestStatus restStatus, String message) {
        return new AuthcResult(Status.STOP, restStatus, message);
    }

    public static AuthcResult stop(RestStatus restStatus, String message, List<DebugInfo> debug) {
        return new AuthcResult(Status.STOP, restStatus, message, null, (ImmutableMap<String, List<String>>)ImmutableMap.empty(), debug);
    }

    public static AuthcResult stop(RestStatus restStatus, String message, ImmutableMap<String, List<String>> headers, List<DebugInfo> debug) {
        return new AuthcResult(Status.STOP, restStatus, message, null, headers, debug);
    }

    public static AuthcResult pass(User user) {
        return new AuthcResult(user, Status.PASS);
    }

    public static AuthcResult pass(User user, String redirectUri) {
        return new AuthcResult(user, Status.PASS, redirectUri);
    }

    public static AuthcResult pass(User user, String redirectUri, List<DebugInfo> debug) {
        return new AuthcResult(user, Status.PASS, redirectUri, debug);
    }

    public AuthcResult(User user, Status status) {
        this.user = user;
        this.status = status;
        this.restStatus = null;
        this.restStatusMessage = null;
        this.debug = null;
        this.redirectUri = null;
        this.headers = ImmutableMap.empty();
    }

    public AuthcResult(User user, Status status, String redirectUri) {
        this.user = user;
        this.status = status;
        this.restStatus = null;
        this.restStatusMessage = null;
        this.debug = null;
        this.redirectUri = redirectUri;
        this.headers = ImmutableMap.empty();
    }

    public AuthcResult(User user, Status status, String redirectUri, List<DebugInfo> debug) {
        this.user = user;
        this.status = status;
        this.restStatus = null;
        this.restStatusMessage = null;
        this.debug = debug;
        this.redirectUri = redirectUri;
        this.headers = ImmutableMap.empty();
    }

    public AuthcResult(Status status) {
        this.user = null;
        this.status = status;
        this.restStatus = null;
        this.restStatusMessage = null;
        this.debug = null;
        this.redirectUri = null;
        this.headers = ImmutableMap.empty();
    }

    public AuthcResult(Status status, RestStatus restStatus, String restStatusMessage) {
        this.user = null;
        this.status = status;
        this.restStatus = restStatus;
        this.restStatusMessage = restStatusMessage;
        this.debug = null;
        this.redirectUri = null;
        this.headers = ImmutableMap.empty();
    }

    public AuthcResult(Status status, RestStatus restStatus, String restStatusMessage, String redirectUri, ImmutableMap<String, List<String>> headers, List<DebugInfo> debug) {
        this.user = null;
        this.status = status;
        this.restStatus = restStatus;
        this.restStatusMessage = restStatusMessage;
        this.debug = debug != null ? Collections.unmodifiableList(new ArrayList<DebugInfo>(debug)) : null;
        this.redirectUri = redirectUri;
        this.headers = headers;
    }

    public User getUser() {
        return this.user;
    }

    public Status getStatus() {
        return this.status;
    }

    public RestStatus getRestStatus() {
        if (this.restStatus != null) {
            return this.restStatus;
        }
        if (this.status == Status.PASS) {
            return RestStatus.OK;
        }
        return RestStatus.UNAUTHORIZED;
    }

    public String getRestStatusMessage() {
        return this.restStatusMessage;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public List<DebugInfo> getDebug() {
        return this.debug;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.restStatus != null) {
            builder.field("status", (Enum)this.restStatus);
        }
        if (this.restStatusMessage != null) {
            builder.field("error", this.restStatusMessage);
        }
        if (this.debug != null) {
            builder.field("debug", this.debug);
        }
        if (this.redirectUri != null) {
            builder.field("redirect_uri", this.redirectUri);
        }
        if (this.headers != null) {
            builder.field("headers", this.headers);
        }
        builder.endObject();
        return builder;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Object toBasicObject() {
        return ImmutableMap.ofNonNull((Object)"status", (Object)this.restStatus, (Object)"error", (Object)this.restStatusMessage, (Object)"debug", this.debug, (Object)"redirect_uri", (Object)this.redirectUri, (Object)"headers", this.headers);
    }

    public static enum Status {
        PASS,
        STOP;

    }

    public static class DebugInfo
    implements ToXContentObject,
    Document<DebugInfo> {
        private final String authcMethod;
        private final boolean success;
        private final String message;
        private final Map<String, Object> details;

        public DebugInfo(String authcMethod, boolean success, String message) {
            this.authcMethod = authcMethod;
            this.success = success;
            this.message = message;
            this.details = null;
        }

        public DebugInfo(String authcMethod, boolean success, String message, Map<String, Object> details) {
            this.authcMethod = authcMethod;
            this.success = success;
            this.message = message;
            this.details = details != null ? ImmutableMap.of(details) : null;
        }

        public String getAuthcMethod() {
            return this.authcMethod;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getDetails() {
            return this.details;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("method", this.authcMethod);
            builder.field("success", this.success);
            builder.field("message", this.message);
            if (this.details != null && this.details.size() > 0) {
                builder.rawField("details", (InputStream)new ByteArrayInputStream(DocWriter.json().writeAsBytes(this.details)), XContentType.JSON);
            }
            builder.endObject();
            return builder;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"method", (Object)this.authcMethod, (Object)"success", (Object)this.success, (Object)"message", (Object)this.message, (Object)"details", this.details != null && this.details.size() > 0 ? this.details : null);
        }
    }
}

