/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.base.RequestAuthenticationProcessor;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.rest.RestRequest;

public class ApiAuthenticationProcessor
extends RequestAuthenticationProcessor<ApiAuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(ApiAuthenticationProcessor.class);
    private final Map<String, Object> request;
    private final String frontendConfigId;

    public ApiAuthenticationProcessor(Map<String, Object> request, RequestMetaData<RestRequest> requestMetaData, Collection<AuthenticationDomain<ApiAuthenticationFrontend>> authenticationDomains, AdminDNs adminDns, PrivilegesEvaluator privilegesEvaluator, AuditLog auditLog, BlockedUserRegistry blockedUserRegistry, List<AuthFailureListener> ipAuthFailureListeners, List<String> requiredLoginPrivileges, boolean debug) {
        super(requestMetaData, authenticationDomains, adminDns, privilegesEvaluator, null, null, auditLog, blockedUserRegistry, ipAuthFailureListeners, requiredLoginPrivileges, debug);
        this.request = request;
        this.frontendConfigId = request.get("config_id") != null ? request.get("config_id").toString() : "default";
    }

    @Override
    protected RequestAuthenticationProcessor.AuthDomainState handleCurrentAuthenticationDomain(AuthenticationDomain<ApiAuthenticationFrontend> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        AuthCredentials ac;
        ApiAuthenticationFrontend authenticationFrontend = authenticationDomain.getFrontend();
        if (log.isTraceEnabled()) {
            log.trace("Try to extract auth creds from {} authentication frontend", (Object)authenticationFrontend.getType());
        }
        try {
            ac = authenticationFrontend.extractCredentials(this.request);
        }
        catch (CredentialsException e) {
            if (log.isTraceEnabled()) {
                log.trace("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            }
            this.debug.add(e.getDebugInfo());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        catch (ConfigValidationException e) {
            log.error("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            this.debug.failure(authenticationFrontend.getType(), "Bad API request", "validation_errors", e.getValidationErrors());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        catch (AuthenticatorUnavailableException e) {
            log.warn("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            this.debug.failure(authenticationFrontend.getType(), e.getMessage());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        catch (Exception e) {
            log.error("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            this.debug.failure(authenticationFrontend.getType(), e.toString());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        if (ac != null && this.isUserBlocked(authenticationDomain.getType(), ac.getUsername())) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting REST request because of blocked user: " + ac.getUsername() + "; authDomain: " + String.valueOf(authenticationDomain));
            }
            this.auditLog.logBlockedUser(ac, false, ac, ((RequestAuthenticationProcessor)this).request.getRequest());
            this.debug.failure(authenticationFrontend.getType(), "User " + ac.getUsername() + " is blocked");
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        this.authCredentials = ac;
        if (ac == null) {
            this.debug.failure(authenticationFrontend.getType(), "No credentials extracted");
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        this.debug.success(authenticationFrontend.getType(), "User has been identified by auth frontend", "username", ac.getUsername(), "roles", ac.getBackendRoles(), "attributes", ac.getStructuredAttributes(), "claims", ac.getClaims() != null ? ac.getClaims() : Collections.emptyMap());
        if (!authenticationDomain.accept(ac)) {
            if (log.isDebugEnabled()) {
                log.debug("Skipped authentication of user {}", (Object)ac.getUsername());
            }
            this.debug.failure(authenticationFrontend.getType(), "User " + ac.getUsername() + " is skipped according to auth domain settings");
            ac.clearSecrets();
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        return this.proceed(ac, authenticationDomain, onResult, onFailure);
    }

    @Override
    protected void decorateAuthenticatedUser(User authenticatedUser) {
        if (this.frontendConfigId != null && !this.frontendConfigId.equals("default")) {
            authenticatedUser.addStructuredAttribute("__fe_cnf_id", this.frontendConfigId);
        }
    }
}

