/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.DocumentWhitelist;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.SnapshotRestoreEvaluator;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.AuthorizationConfig;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.RoleMapping;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.meta.Meta;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class PrivilegesEvaluator
implements ComponentStateProvider {
    static final StaticSettings.Attribute<Pattern> ADMIN_ONLY_ACTIONS = StaticSettings.Attribute.define((String)"searchguard.admin_only_actions").withDefault(Pattern.createUnchecked((String)"cluster:admin:searchguard:config/*", (String)"cluster:admin:searchguard:internal/*", (String[])new String[0])).asPattern();
    static final StaticSettings.Attribute<Pattern> ADMIN_ONLY_INDICES = StaticSettings.Attribute.define((String)"searchguard.admin_only_indices").withDefault(Pattern.createUnchecked((String)"searchguard", (String)".searchguard", (String[])new String[]{".searchguard_*", ".signals_watches*", ".signals_accounts", ".signals_settings", ".signals_truststores", ".signals_proxies"})).asPattern();
    static final StaticSettings.Attribute<Boolean> CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES = StaticSettings.Attribute.define((String)"searchguard.check_snapshot_restore_write_privileges").withDefault(true).asBoolean();
    static final StaticSettings.Attribute<Boolean> UNSUPPORTED_RESTORE_SGINDEX_ENABLED = StaticSettings.Attribute.define((String)"searchguard.unsupported.restore.sgindex.enabled").withDefault(false).asBoolean();
    public static final StaticSettings.AttributeSet STATIC_SETTINGS = StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{ADMIN_ONLY_ACTIONS, ADMIN_ONLY_INDICES, CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES, UNSUPPORTED_RESTORE_SGINDEX_ENABLED, RoleBasedActionAuthorization.PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE});
    private static final Logger log = LogManager.getLogger(PrivilegesEvaluator.class);
    private final ClusterService clusterService;
    private final AuthorizationService authorizationService;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private MultiTenancyConfigurationProvider multiTenancyConfigurationProvider;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final ClusterInfoHolder clusterInfoHolder;
    private final ActionRequestIntrospector actionRequestIntrospector;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;
    private final Pattern adminOnlyActions;
    private final Pattern adminOnlyIndices;
    private final Actions actions;
    private final ComponentState componentState = new ComponentState(10, null, "privileges_evaluator");
    private final ByteSizeValue statefulIndexMaxHeapSize;
    private final AtomicReference<RoleBasedActionAuthorization> actionAuthorization = new AtomicReference();
    private volatile AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
    private volatile TenantManager tenantManager = null;

    public PrivilegesEvaluator(final ClusterService clusterService, final ThreadPool threadPool, ConfigurationRepository configurationRepository, AuthorizationService authorizationService, IndexNameExpressionResolver resolver, AuditLog auditLog, final StaticSettings settings, ClusterInfoHolder clusterInfoHolder, final Actions actions, ActionRequestIntrospector actionRequestIntrospector, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, GuiceDependencies guiceDependencies, NamedXContentRegistry namedXContentRegistry, boolean enterpriseModulesEnabled) {
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.authorizationService = authorizationService;
        this.threadContext = threadPool.getThreadContext();
        this.checkSnapshotRestoreWritePrivileges = (Boolean)settings.get(CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES);
        this.clusterInfoHolder = clusterInfoHolder;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
        this.actions = actions;
        this.actionRequestIntrospector = actionRequestIntrospector;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(auditLog, guiceDependencies, (Boolean)settings.get(UNSUPPORTED_RESTORE_SGINDEX_ENABLED));
        this.adminOnlyActions = (Pattern)settings.get(ADMIN_ONLY_ACTIONS);
        this.adminOnlyIndices = (Pattern)settings.get(ADMIN_ONLY_INDICES);
        this.statefulIndexMaxHeapSize = (ByteSizeValue)settings.get(RoleBasedActionAuthorization.PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE);
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<AuthorizationConfig> config = configMap.get(CType.AUTHZ);
                SgDynamicConfiguration<LegacySgConfig> legacyConfig = configMap.get(CType.CONFIG);
                AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
                if (config != null && config.getCEntry("default") != null) {
                    PrivilegesEvaluator.this.authzConfig = authzConfig = config.getCEntry("default");
                    log.info("Updated authz config:\n" + String.valueOf(config));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)authzConfig);
                    }
                } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                    try {
                        LegacySgConfig sgConfig = legacyConfig.getCEntry("sg_config");
                        PrivilegesEvaluator.this.authzConfig = authzConfig = AuthorizationConfig.parseLegacySgConfig(sgConfig.getSource(), null, settings);
                        log.info("Updated authz config (legacy):\n" + String.valueOf(legacyConfig));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)authzConfig);
                        }
                    }
                    catch (ConfigValidationException e) {
                        log.error("Error while parsing sg_config:\n" + String.valueOf((Object)e));
                    }
                }
                SgDynamicConfiguration<Role> roles = configMap.get(CType.ROLES);
                SgDynamicConfiguration<Tenant> tenants = configMap.get(CType.TENANTS);
                ActionGroup.FlattenedIndex actionGroups = configMap.get(CType.ACTIONGROUPS) != null ? new ActionGroup.FlattenedIndex(configMap.get(CType.ACTIONGROUPS)) : ActionGroup.FlattenedIndex.EMPTY;
                PrivilegesEvaluator.this.tenantManager = new TenantManager((Set<String>)tenants.getCEntries().keySet(), PrivilegesEvaluator.this.multiTenancyConfigurationProvider);
                RoleBasedActionAuthorization newActionAuthorization = new RoleBasedActionAuthorization(roles, actionGroups, actions, Meta.from((Metadata)clusterService.state().metadata()), (Set<String>)tenants.getCEntries().keySet(), PrivilegesEvaluator.this.statefulIndexMaxHeapSize, PrivilegesEvaluator.this.adminOnlyIndices, authzConfig.getMetricsLevel(), PrivilegesEvaluator.this.multiTenancyConfigurationProvider);
                RoleBasedActionAuthorization oldActionAuthorization = PrivilegesEvaluator.this.actionAuthorization.getAndSet(newActionAuthorization);
                PrivilegesEvaluator.this.componentState.setConfigVersion(configMap.getVersionsAsString());
                PrivilegesEvaluator.this.componentState.replacePart(newActionAuthorization.getComponentState());
                PrivilegesEvaluator.this.componentState.replacePart(actionGroups.getComponentState());
                PrivilegesEvaluator.this.componentState.updateStateFromParts();
                if (oldActionAuthorization != null) {
                    oldActionAuthorization.shutdown();
                }
            }
        });
        clusterService.addListener(new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent event) {
                RoleBasedActionAuthorization actionAuthorization = PrivilegesEvaluator.this.actionAuthorization.get();
                if (actionAuthorization != null) {
                    actionAuthorization.updateStatefulIndexPrivilegesAsync(clusterService, threadPool);
                }
            }
        });
    }

    public boolean isInitialized() {
        return this.actionAuthorization.get() != null;
    }

    public PrivilegesEvaluationResult evaluate(User user, ImmutableSet<String> mappedRoles, String action0, ActionRequest request, Task task, PrivilegesEvaluationContext context, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext) {
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Search Guard is not initialized.", new Object[0]);
        }
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        Action action = this.actions.get(action0);
        if (this.adminOnlyActions.matches(action0)) {
            log.info("Action " + action0 + " is reserved for users authenticating with an admin certificate");
            return PrivilegesEvaluationResult.INSUFFICIENT.reason("Action is reserved for users authenticating with an admin certificate").missingPrivileges(action);
        }
        if ("cluster:admin:searchguard:session/_own/delete".equals(action0)) {
            return PrivilegesEvaluationResult.OK;
        }
        if (action.isOpen()) {
            return PrivilegesEvaluationResult.OK;
        }
        AuthorizationConfig authzConfig = this.authzConfig;
        ActionAuthorization actionAuthorization = specialPrivilegesEvaluationContext == null ? (ActionAuthorization)this.actionAuthorization.get() : specialPrivilegesEvaluationContext.getActionAuthorization();
        try {
            PrivilegesEvaluationResult result;
            if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
                PrivilegesEvaluationResult result2 = actionAuthorization.hasClusterPermission(context, action);
                if (result2.getStatus() != PrivilegesEvaluationResult.Status.OK) {
                    log.info("No cluster-level permission for {} [Action [{}]] [RolesChecked {}]\n{}", (Object)user, (Object)action0, mappedRoles, (Object)result2);
                    return result2;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Taking shortcut for BulkRequest; user: " + String.valueOf(user));
                }
                return result2;
            }
            ActionRequestIntrospector.ActionRequestInfo requestInfo = this.actionRequestIntrospector.getActionRequestInfo(action, request);
            if (log.isDebugEnabled()) {
                if (requestInfo.isUnknown()) {
                    log.debug("### evaluate UNKNOWN " + action0 + " (" + request.getClass().getName() + ")\nUser: " + String.valueOf(user) + "\nspecialPrivilegesEvaluationContext: " + String.valueOf(specialPrivilegesEvaluationContext));
                } else if (!requestInfo.isIndexRequest()) {
                    log.debug("### evaluate " + action0 + " (" + request.getClass().getName() + ")\nUser: " + String.valueOf(user) + "\nspecialPrivilegesEvaluationContext: " + String.valueOf(specialPrivilegesEvaluationContext));
                } else {
                    log.debug("### evaluate {} ({})\nUser: {}\nspecialPrivilegesEvaluationContext: {}\nRequestInfo: {}", (Object)action0, (Object)request.getClass().getName(), (Object)user, (Object)specialPrivilegesEvaluationContext, (Object)requestInfo);
                }
            }
            if (!(result = this.snapshotRestoreEvaluator.evaluate(request, task, action, this.clusterInfoHolder)).isPending()) {
                return result;
            }
            if (action.isClusterPrivilege()) {
                result = actionAuthorization.hasClusterPermission(context, action);
                if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
                    log.info("### No cluster privileges for {} ({})\nUser: {}\nRoles: {}\n{}", (Object)action, (Object)request.getClass().getName(), (Object)user, mappedRoles, (Object)result);
                    return result;
                }
                if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                    return this.evaluateIndexPrivileges(user, action, action.expandPrivileges(request), request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
                }
                ImmutableSet<Action> additionalPrivileges = action.getAdditionalPrivileges(request);
                if (additionalPrivileges.isEmpty()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Allowing as cluster privilege: " + action0);
                    }
                    return PrivilegesEvaluationResult.OK;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Additional privileges required: " + String.valueOf(additionalPrivileges));
                }
                return this.evaluateAdditionalPrivileges(user, action, additionalPrivileges, request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
            }
            if (action.isTenantPrivilege()) {
                result = this.hasTenantPermission(user, mappedRoles, action, actionAuthorization, context);
                if (!result.isOk()) {
                    log.info("No {}-level perm match for {} {} [Action [{}]] [RolesChecked {}]:\n{}", (Object)"tenant", (Object)user, (Object)requestInfo, (Object)action0, mappedRoles, (Object)result);
                    return result;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Allowing as tenant privilege: " + action0);
                }
                return result;
            }
            if (this.checkDocWhitelistHeader(user, action0, request)) {
                if (log.isTraceEnabled()) {
                    log.trace("Allowing due to doc whitelist: " + action0);
                }
                return PrivilegesEvaluationResult.OK;
            }
            ImmutableSet<Action> allIndexPermsRequired = action.expandPrivileges(request);
            if (log.isDebugEnabled() && (allIndexPermsRequired.size() > 1 || !allIndexPermsRequired.contains((Object)action))) {
                log.debug("Expanded index privileges: " + String.valueOf(allIndexPermsRequired));
            }
            return this.evaluateIndexPrivileges(user, action, allIndexPermsRequired, request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        catch (Exception e) {
            log.error("Error while evaluating " + action0 + " (" + request.getClass().getName() + ")", (Throwable)e);
            return PrivilegesEvaluationResult.INSUFFICIENT.with((ImmutableList<PrivilegesEvaluationResult.Error>)ImmutableList.of((Object)new PrivilegesEvaluationResult.Error(e.getMessage(), e)));
        }
    }

    private PrivilegesEvaluationResult evaluateIndexPrivileges(User user, Action action, ImmutableSet<Action> requiredPermissions, ActionRequest request, Task task, ActionRequestIntrospector.ActionRequestInfo actionRequestInfo, ImmutableSet<String> mappedRoles, AuthorizationConfig authzConfig, ActionAuthorization actionAuthorization, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        boolean dnfofPossible;
        if (actionRequestInfo.getResolvedIndices().containsOnlyRemoteIndices()) {
            log.debug("Request contains only remote indices. We can skip all further checks and let requests be handled by remote cluster: {}", (Object)action);
            return PrivilegesEvaluationResult.OK;
        }
        if (log.isDebugEnabled()) {
            log.debug("requested resolved indextypes: {}", (Object)actionRequestInfo);
        }
        boolean bl = dnfofPossible = authzConfig.isIgnoreUnauthorizedIndices() && authzConfig.getIgnoreUnauthorizedIndicesActions().matches(action.name()) && (actionRequestInfo.ignoreUnavailable() || actionRequestInfo.containsWildcards());
        if (!dnfofPossible) {
            context.setResolveLocalAll(false);
        }
        ImmutableSet allIndexPermsRequired = requiredPermissions.matching(Action::isIndexLikePrivilege);
        ImmutableSet clusterPermissions = requiredPermissions.matching(Action::isClusterPrivilege);
        if (!clusterPermissions.isEmpty()) {
            for (Action clusterPermission : clusterPermissions) {
                PrivilegesEvaluationResult result = actionAuthorization.hasClusterPermission(context, clusterPermission);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                if (log.isEnabled(Level.INFO)) {
                    log.info("### No cluster privileges for " + String.valueOf(clusterPermission) + " (" + request.getClass().getName() + ")\nUser: " + String.valueOf(user) + "\nResolved Indices: " + String.valueOf(actionRequestInfo.getResolvedIndices()) + "\nUnresolved: " + String.valueOf(actionRequestInfo.getUnresolved()) + "\nRoles: " + String.valueOf(mappedRoles) + "\n" + String.valueOf(result));
                }
                return result;
            }
        }
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasIndexPermission(context, action, (ImmutableSet<Action>)allIndexPermsRequired, actionRequestInfo.getMainResolvedIndices(), action.scope());
        if (!actionRequestInfo.getAdditionalResolvedIndices().isEmpty()) {
            for (Map.Entry entry : actionRequestInfo.getAdditionalResolvedIndices().entrySet()) {
                ImmutableSet<Action> additionalIndexPermissions = ((Action.AdditionalDimension)entry.getKey()).getRequiredPrivileges((ImmutableSet<Action>)allIndexPermsRequired, this.actions);
                PrivilegesEvaluationResult subResult = actionAuthorization.hasIndexPermission(context, action, additionalIndexPermissions, (ResolvedIndices)entry.getValue(), action.scope());
                if (log.isTraceEnabled()) {
                    log.trace("Sub result for {}/{}:\n{}", entry.getKey(), additionalIndexPermissions, (Object)subResult);
                }
                privilegesEvaluationResult = privilegesEvaluationResult.withAdditional((Action.AdditionalDimension)entry.getKey(), subResult);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Result from privileges evaluation: " + String.valueOf((Object)privilegesEvaluationResult.getStatus()) + "\n" + String.valueOf(privilegesEvaluationResult));
        }
        if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK_WHEN_RESOLVED) {
            if (authzConfig.isIgnoreUnauthorizedIndices() && authzConfig.getIgnoreUnauthorizedIndicesActions().matches(action.name())) {
                privilegesEvaluationResult = PrivilegesEvaluationResult.OK;
            } else if (actionRequestInfo.getResolvedIndices().getLocal().getAliases().size() == 1 && ((Meta.Alias)actionRequestInfo.getResolvedIndices().getLocal().getAliases().only()).resolve(action.aliasResolutionMode()).size() == 1 && privilegesEvaluationResult.getAvailableIndices().size() == 1 && (request instanceof GetRequest || request instanceof IndexRequest || request instanceof BulkShardRequest)) {
                privilegesEvaluationResult = PrivilegesEvaluationResult.OK;
            } else {
                reasonForNoIndexReduction = "You have privileges for all members of an alias, but not for the whole alias. Access to the alias is denied, because ignore_unauthorized_indices is globally disabled in sg_authz.";
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.INSUFFICIENT).reason((String)reasonForNoIndexReduction);
            }
        } else if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK) {
            if (dnfofPossible) {
                if (log.isDebugEnabled()) {
                    log.debug("Reducing indices to {}; {}\n{}", privilegesEvaluationResult.getAvailableIndices(), privilegesEvaluationResult.getAdditionalAvailableIndices(), (Object)privilegesEvaluationResult);
                }
                privilegesEvaluationResult = this.actionRequestIntrospector.reduceIndices(action, request, privilegesEvaluationResult.getAvailableIndices(), privilegesEvaluationResult.getAdditionalAvailableIndices(), actionRequestInfo);
            } else {
                reasonForNoIndexReduction = "You have privileges for some, but not all requested indices. However, access to the whole operation is denied, because ";
                reasonForNoIndexReduction = !authzConfig.isIgnoreUnauthorizedIndices() ? (String)reasonForNoIndexReduction + "ignore_unauthorized_indices is globally disabled in sg_authz." : (!authzConfig.getIgnoreUnauthorizedIndicesActions().matches(action.name()) ? (String)reasonForNoIndexReduction + "the action " + String.valueOf(action) + " is not available for ignore_unauthorized_indices." : (String)reasonForNoIndexReduction + "ignore_unavailable is set to false. Use ignore_unavailable=true to get access to the indices you have privileges for.");
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.INSUFFICIENT).reason((String)reasonForNoIndexReduction);
            }
        } else if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT && dnfofPossible) {
            if (!actionRequestInfo.getResolvedIndices().getRemoteIndices().isEmpty()) {
                privilegesEvaluationResult = this.actionRequestIntrospector.reduceIndices(action, request, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>>)ImmutableMap.empty(), actionRequestInfo);
            } else if (authzConfig.getIgnoreUnauthorizedIndicesActionsAllowingEmptyResult().matches(action.name())) {
                if (log.isTraceEnabled()) {
                    log.trace("Changing result from INSUFFICIENT to EMPTY");
                }
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.EMPTY);
            }
        }
        if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.EMPTY) {
            if (this.actionRequestIntrospector.forceEmptyResult(action, request)) {
                if (log.isDebugEnabled()) {
                    log.debug("DNF: Reducing indices to yield an empty result\n" + String.valueOf(privilegesEvaluationResult));
                }
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.OK);
            } else {
                log.warn("DNFOF for empty results is not available for {} ({})", (Object)action, (Object)request.getClass().getName());
            }
        }
        if (privilegesEvaluationResult.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            Level logLevel;
            Level level = logLevel = privilegesEvaluationResult.hasErrors() ? Level.WARN : Level.INFO;
            if (log.isEnabled(logLevel)) {
                log.log(logLevel, "### No index privileges for {} ({})\nUser: {}\nResolved Indices: {}\nUnresolved: {}\nRoles: {}\nRequired Privileges: {}\n{}", (Object)action, (Object)request.getClass().getName(), (Object)user, (Object)actionRequestInfo.getResolvedIndices(), actionRequestInfo.getUnresolved(), mappedRoles, (Object)allIndexPermsRequired, (Object)privilegesEvaluationResult);
            }
            return privilegesEvaluationResult;
        }
        if (log.isDebugEnabled()) {
            log.debug("Allowed because we have all indices permissions for " + String.valueOf(allIndexPermsRequired));
        }
        return PrivilegesEvaluationResult.OK;
    }

    private PrivilegesEvaluationResult evaluateAdditionalPrivileges(User user, Action action, ImmutableSet<Action> additionalPrivileges, ActionRequest request, Task task, ActionRequestIntrospector.ActionRequestInfo actionRequestInfo, ImmutableSet<String> mappedRoles, AuthorizationConfig authzConfig, ActionAuthorization actionAuthorization, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        if (additionalPrivileges.forAllApplies(a -> a.isIndexLikePrivilege())) {
            return this.evaluateIndexPrivileges(user, action, additionalPrivileges, request, task, actionRequestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        ImmutableSet indexPrivileges = ImmutableSet.empty();
        for (Action additionalPrivilege : additionalPrivileges) {
            PrivilegesEvaluationResult result;
            if (additionalPrivilege.isClusterPrivilege()) {
                result = actionAuthorization.hasClusterPermission(context, additionalPrivilege);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                log.info("Additional privilege missing: " + String.valueOf(result));
                return result;
            }
            if (additionalPrivilege.isTenantPrivilege()) {
                result = this.hasTenantPermission(user, mappedRoles, additionalPrivilege, actionAuthorization, context);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                log.info("Additional privilege missing: " + String.valueOf(result));
                return result;
            }
            if (!additionalPrivilege.isIndexLikePrivilege()) continue;
            indexPrivileges = indexPrivileges.with((Object)additionalPrivilege);
        }
        if (!indexPrivileges.isEmpty()) {
            return this.evaluateIndexPrivileges(user, action, (ImmutableSet<Action>)indexPrivileges, request, task, actionRequestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        return PrivilegesEvaluationResult.OK;
    }

    public Set<String> getAllConfiguredTenantNames() {
        return this.tenantManager.getConfiguredTenantNames();
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.authzConfig.isIgnoreUnauthorizedIndices();
    }

    public static boolean isTenantPerm(String action0) {
        return action0.startsWith("cluster:admin:searchguard:tenant:");
    }

    public Map<String, Boolean> evaluateClusterAndTenantPrivileges(User user, TransportAddress caller, Collection<String> privilegesAskedFor) {
        if (privilegesAskedFor == null || privilegesAskedFor.isEmpty() || user == null) {
            log.debug("Privileges or user empty");
            return Collections.emptyMap();
        }
        ImmutableSet<String> mappedRoles = this.authorizationService.getMappedRoles(user, caller);
        String requestedTenant = this.getRequestedTenant(user);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, false, mappedRoles, null, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean tenantValid = this.tenantManager.isTenantHeaderValid(requestedTenant);
        if (!tenantValid) {
            log.info("Invalid tenant: " + requestedTenant + "; user: " + String.valueOf(user));
        }
        ActionAuthorization actionAuthorization = this.actionAuthorization.get();
        for (String privilegeAskedFor : privilegesAskedFor) {
            Action action = this.actions.get(privilegeAskedFor);
            try {
                PrivilegesEvaluationResult privilegesEvaluationResult;
                if (action.isTenantPrivilege()) {
                    if (tenantValid) {
                        privilegesEvaluationResult = actionAuthorization.hasTenantPermission(context, action, requestedTenant);
                        result.put(privilegeAskedFor, privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK);
                        continue;
                    }
                    result.put(privilegeAskedFor, false);
                    continue;
                }
                privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, action);
                result.put(privilegeAskedFor, privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK);
            }
            catch (PrivilegesEvaluationException e) {
                log.error("Error while evaluating " + privilegeAskedFor + " for " + String.valueOf(user), (Throwable)e);
                result.put(privilegeAskedFor, false);
            }
        }
        return result;
    }

    private PrivilegesEvaluationResult hasTenantPermission(User user, ImmutableSet<String> mappedRoles, Action action, ActionAuthorization actionAuthorization, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        String requestedTenant;
        String string = requestedTenant = !Strings.isNullOrEmpty((String)user.getRequestedTenant()) ? user.getRequestedTenant() : "SGS_GLOBAL_TENANT";
        if (!this.multiTenancyConfigurationProvider.isMultiTenancyEnabled() && !this.tenantManager.isGlobalTenantHeader(requestedTenant)) {
            log.warn("Denying request to non-default tenant because MT is disabled: " + requestedTenant);
            return PrivilegesEvaluationResult.INSUFFICIENT.reason("Multi-tenancy is disabled");
        }
        return actionAuthorization.hasTenantPermission(context, action, requestedTenant);
    }

    private String getRequestedTenant(User user) {
        String requestedTenant = user.getRequestedTenant();
        if (this.tenantManager.isTenantHeaderEmpty(requestedTenant) || !this.multiTenancyConfigurationProvider.isMultiTenancyEnabled()) {
            return "SGS_GLOBAL_TENANT";
        }
        return requestedTenant;
    }

    public boolean hasClusterPermission(User user, String actionName, TransportAddress callerTransportAddress) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization;
        ImmutableSet<String> mappedRoles;
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, this.threadContext);
        if (specialPrivilegesEvaluationContext != null) {
            user = specialPrivilegesEvaluationContext.getUser();
        }
        if (specialPrivilegesEvaluationContext == null) {
            mappedRoles = this.authorizationService.getMappedRoles(user, callerTransportAddress);
            actionAuthorization = this.actionAuthorization.get();
        } else {
            mappedRoles = specialPrivilegesEvaluationContext.getMappedRoles();
            actionAuthorization = specialPrivilegesEvaluationContext.getActionAuthorization();
        }
        Action action = this.actions.get(actionName);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, false, mappedRoles, action, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, specialPrivilegesEvaluationContext);
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, action);
        return privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK;
    }

    public boolean hasClusterPermissions(User user, List<String> permissions, TransportAddress callerTransportAddress) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization;
        ImmutableSet<String> mappedRoles;
        if (permissions.isEmpty()) {
            return true;
        }
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, this.threadContext);
        if (specialPrivilegesEvaluationContext != null) {
            user = specialPrivilegesEvaluationContext.getUser();
        }
        if (specialPrivilegesEvaluationContext == null) {
            mappedRoles = this.authorizationService.getMappedRoles(user, callerTransportAddress);
            actionAuthorization = this.actionAuthorization.get();
        } else {
            mappedRoles = specialPrivilegesEvaluationContext.getMappedRoles();
            actionAuthorization = specialPrivilegesEvaluationContext.getActionAuthorization();
        }
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, false, mappedRoles, null, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, null);
        for (String permission : permissions) {
            PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, this.actions.get(permission));
            if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
            return false;
        }
        return true;
    }

    public boolean hasClusterPermissions(String permission, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization = context.getSpecialPrivilegesEvaluationContext() == null ? (ActionAuthorization)this.actionAuthorization.get() : context.getSpecialPrivilegesEvaluationContext().getActionAuthorization();
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, this.actions.get(permission));
        return privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK;
    }

    private boolean checkDocWhitelistHeader(User user, String action, ActionRequest request) {
        String docWhitelistHeader = this.threadContext.getHeader("_sg_doc_whitelist");
        if (docWhitelistHeader == null) {
            return false;
        }
        if (!(request instanceof GetRequest)) {
            return false;
        }
        try {
            DocumentWhitelist documentWhitelist = DocumentWhitelist.parse(docWhitelistHeader);
            GetRequest getRequest = (GetRequest)request;
            if (documentWhitelist.isWhitelisted(getRequest.index(), getRequest.id())) {
                if (log.isDebugEnabled()) {
                    log.debug("Request " + String.valueOf(request) + " is whitelisted by " + String.valueOf(documentWhitelist));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error while handling document whitelist: " + docWhitelistHeader, (Throwable)e);
            return false;
        }
    }

    public void setMultiTenancyConfigurationProvider(MultiTenancyConfigurationProvider multiTenancyConfigurationProvider) {
        this.multiTenancyConfigurationProvider = multiTenancyConfigurationProvider;
    }

    public RoleBasedActionAuthorization getActionAuthorization() {
        return this.actionAuthorization.get();
    }

    public RoleMapping.ResolutionMode getRolesMappingResolution() {
        return this.authzConfig.getRoleMappingResolution();
    }

    public ActionGroup.FlattenedIndex getActionGroups() {
        return this.actionAuthorization.get().getActionGroups();
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public IndexNameExpressionResolver getResolver() {
        return this.resolver;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public boolean isDebugEnabled() {
        return this.authzConfig.isDebugEnabled();
    }
}

