/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardConfigUpdateAction
extends BaseRestHandler {
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;

    public SearchGuardConfigUpdateAction(Settings settings, ThreadPool threadPool, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.threadContext = threadPool.getThreadContext();
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/configupdate"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] configTypes = request.paramAsStringArrayOrEmptyIfAll("config_types");
        SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo((Settings)this.settings, (Path)this.configPath, (RestRequest)request, (PrincipalExtractor)this.principalExtractor);
        if (sslInfo == null) {
            return channel -> channel.sendResponse(new RestResponse(RestStatus.FORBIDDEN, ""));
        }
        User user = (User)this.threadContext.getTransient("_sg_user");
        if (user == null || !this.adminDns.isAdmin(user)) {
            return channel -> channel.sendResponse(new RestResponse(RestStatus.FORBIDDEN, ""));
        }
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(configTypes);
        return channel -> client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    public String getName() {
        return "Search Guard config update";
    }
}

