/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.AuthDomainInfo;
import com.floragunn.searchguard.user.UserInformation;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.JsonPath;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class User
implements Serializable,
UserInformation,
AttributeSource {
    private static final Logger log = LogManager.getLogger(User.class);
    public static final User ANONYMOUS = new User("sg_anonymous", AuthDomainInfo.ANON, Lists.newArrayList((Object[])new String[]{"sg_anonymous_backendrole"}), null);
    public static final String USER_TENANT = "__user__";
    private static final long serialVersionUID = -5500938501822658596L;
    private final String name;
    private final String subName;
    private final String type;
    private String authDomain;
    private final Set<String> roles;
    private final Set<String> searchGuardRoles;
    private final Object specialAuthzConfig;
    private String requestedTenant;
    private Map<String, String> attributes;
    private Map<String, Object> structuredAttributes;
    private boolean isInjected = false;
    private transient boolean authzComplete = false;

    public static Builder forUser(String username) {
        return new Builder().name(username);
    }

    public User(String name, String subName, AuthDomainInfo authDomainInfo, String type, Set<String> roles, Set<String> searchGuardRoles, Object specialAuthzConfig, String requestedTenant, Map<String, Object> structuredAttributes, Map<String, String> attributes, boolean authzComplete) {
        this.name = name;
        this.subName = subName;
        this.authDomain = authDomainInfo != null ? authDomainInfo.toInfoString() : null;
        this.type = type;
        this.roles = roles;
        this.searchGuardRoles = searchGuardRoles;
        this.specialAuthzConfig = specialAuthzConfig;
        this.requestedTenant = requestedTenant;
        this.structuredAttributes = structuredAttributes;
        this.attributes = attributes;
        this.authzComplete = authzComplete;
    }

    public User(String name, AuthDomainInfo authDomainInfo, Collection<String> roles, AuthCredentials customAttributes) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        this.authDomain = authDomainInfo != null ? authDomainInfo.toInfoString() : null;
        this.subName = null;
        this.type = null;
        this.roles = new HashSet<String>();
        this.searchGuardRoles = new HashSet<String>();
        this.attributes = new HashMap<String, String>();
        this.structuredAttributes = new HashMap<String, Object>();
        this.specialAuthzConfig = null;
        if (roles != null) {
            this.addRoles(roles);
        }
        if (customAttributes != null) {
            this.attributes.putAll(customAttributes.getAttributes());
            this.structuredAttributes.putAll(customAttributes.getStructuredAttributes());
        }
    }

    @Deprecated
    public User(String name, Collection<String> roles, AuthCredentials customAttributes) {
        this(name, null, roles, customAttributes);
    }

    public User(String name) {
        this(name, null, null, null);
    }

    public User(String name, AuthDomainInfo authDomainInfo) {
        this(name, authDomainInfo, null, null);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }

    public final Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public final void addRole(String role) {
        this.roles.add(role);
    }

    public final void addRoles(Collection<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    public final boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    @Deprecated
    public final void addAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public final String getRequestedTenant() {
        return this.requestedTenant;
    }

    public final void setRequestedTenant(String requestedTenant) {
        this.requestedTenant = requestedTenant;
    }

    public final String toStringWithAttributes() {
        StringBuilder result = new StringBuilder("User ").append(this.name);
        if (this.subName != null && this.subName.length() > 0) {
            result.append(" (").append(this.subName).append(")");
        }
        if (this.authDomain != null && this.authDomain.length() > 0) {
            result.append(" <").append(this.authDomain).append(">");
        }
        if (this.roles != null) {
            result.append(" ").append(this.roles);
        } else {
            result.append(" []");
        }
        if (this.searchGuardRoles != null) {
            result.append("/").append(this.searchGuardRoles);
        } else {
            result.append("/[]");
        }
        if (this.structuredAttributes != null) {
            result.append(" ").append(this.structuredAttributes);
        } else {
            result.append("{}");
        }
        return result.toString();
    }

    public final String toString() {
        return this.toString(false);
    }

    private String toString(boolean includeAttributes) {
        StringBuilder result = new StringBuilder("User ").append(this.name);
        if (this.subName != null && this.subName.length() > 0) {
            result.append(" (").append(this.subName).append(")");
        }
        if (this.authDomain != null && this.authDomain.length() > 0) {
            result.append(" <").append(this.authDomain).append(">");
        }
        boolean propsAdded = false;
        if (this.roles != null && this.roles.size() > 0) {
            if (!propsAdded) {
                result.append(" [");
                propsAdded = true;
            } else {
                result.append(" ");
            }
            result.append("backend_roles=").append(this.roles);
        }
        if (this.searchGuardRoles != null && this.searchGuardRoles.size() > 0) {
            if (!propsAdded) {
                result.append(" [");
                propsAdded = true;
            } else {
                result.append(" ");
            }
            result.append("sg_roles=").append(this.searchGuardRoles);
        }
        if (this.requestedTenant != null && this.requestedTenant.length() > 0) {
            if (!propsAdded) {
                result.append(" [");
                propsAdded = true;
            } else {
                result.append(" ");
            }
            result.append("requestedTenant=").append(this.requestedTenant);
        }
        if (includeAttributes && this.attributes != null && this.attributes.size() > 0) {
            if (!propsAdded) {
                result.append(" [");
                propsAdded = true;
            } else {
                result.append(" ");
            }
            result.append("attributes=").append(this.attributes);
        }
        if (propsAdded) {
            result.append("]");
        }
        return result.toString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Deprecated
    public final synchronized Map<String, String> getCustomAttributesMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public Map<String, Object> getStructuredAttributes() {
        return this.structuredAttributes;
    }

    public String getAttributeAsString(String key) {
        Object value = this.structuredAttributes.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public void addStructuredAttribute(String key, Object value) {
        this.structuredAttributes.put(key, value);
    }

    public void addStructuredAttributesByJsonPath(Map<String, JsonPath> jsonPathMap, Object source) {
        Attributes.addAttributesByJsonPath(jsonPathMap, source, this.structuredAttributes);
    }

    public final void addSearchGuardRoles(Collection<String> sgRoles) {
        if (sgRoles != null && this.searchGuardRoles != null) {
            this.searchGuardRoles.addAll(sgRoles);
        }
    }

    public final Set<String> getSearchGuardRoles() {
        return this.searchGuardRoles == null ? Collections.emptySet() : Collections.unmodifiableSet(this.searchGuardRoles);
    }

    public String getType() {
        return this.type;
    }

    public Object getSpecialAuthzConfig() {
        return this.specialAuthzConfig;
    }

    public boolean isAuthzComplete() {
        return this.authzComplete;
    }

    public Builder copy() {
        Builder builder = new Builder();
        builder.name = this.name;
        builder.subName = this.subName;
        builder.type = this.type;
        builder.backendRoles.addAll(this.roles);
        builder.searchGuardRoles.addAll(this.searchGuardRoles);
        builder.requestedTenant = this.requestedTenant;
        builder.attributes.putAll(this.attributes);
        builder.structuredAttributes.putAll(this.structuredAttributes);
        builder.specialAuthzConfig = this.specialAuthzConfig;
        builder.authzComplete = this.authzComplete;
        return builder;
    }

    @Override
    public String getAuthDomain() {
        return this.authDomain;
    }

    public void setAuthDomain(String authDomain) {
        if (authDomain != null) {
            throw new IllegalStateException("AuthDomain has been already set: " + String.valueOf(this));
        }
        this.authDomain = authDomain;
    }

    public Object getAttributeValue(String attributeName) {
        if (attributeName.equals("user.name") || attributeName.equals("user_name")) {
            return this.getName();
        }
        if (attributeName.equals("user.roles") || attributeName.equals("user_roles")) {
            return this.getRoles();
        }
        if (attributeName.equals("user.attrs")) {
            return this.getStructuredAttributes();
        }
        if (attributeName.startsWith("user.attrs.")) {
            return this.getStructuredAttributes().get(attributeName.substring("user.attrs.".length()));
        }
        if (attributeName.startsWith("attr.") || attributeName.startsWith("_")) {
            log.error("The attribute syntax ${" + attributeName + "} is no longer supported. Please change to new user attributes. See here for details: https://docs.search-guard.com/latest/document-level-security#user-attributes");
            return "${" + attributeName + "}";
        }
        return null;
    }

    public static class Builder {
        private String name;
        private String subName;
        private AuthDomainInfo authDomainInfo;
        private String type;
        private final Set<String> backendRoles = new HashSet<String>();
        private final Set<String> searchGuardRoles = new HashSet<String>();
        private String requestedTenant;
        private Map<String, String> attributes = new HashMap<String, String>();
        private Map<String, Object> structuredAttributes = new HashMap<String, Object>();
        private Object specialAuthzConfig;
        private boolean authzComplete;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subName(String subName) {
            this.subName = subName;
            return this;
        }

        public Builder authDomainInfo(AuthDomainInfo authDomainInfo) {
            this.authDomainInfo = this.authDomainInfo == null ? authDomainInfo : this.authDomainInfo.add(authDomainInfo);
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder requestedTenant(String requestedTenant) {
            this.requestedTenant = requestedTenant;
            return this;
        }

        public Builder with(AuthCredentials authCredentials) {
            this.authDomainInfo(authCredentials.getAuthDomainInfo());
            this.backendRoles(authCredentials.getBackendRoles());
            this.searchGuardRoles((Collection<String>)authCredentials.getSearchGuardRoles());
            this.oldAttributes(authCredentials.getAttributes());
            this.attributes(authCredentials.getStructuredAttributes());
            return this;
        }

        public Builder backendRoles(String ... backendRoles) {
            return this.backendRoles(Arrays.asList(backendRoles));
        }

        public Builder backendRoles(Collection<String> backendRoles) {
            if (backendRoles != null) {
                this.backendRoles.addAll(backendRoles);
            }
            return this;
        }

        public Builder searchGuardRoles(String ... searchGuardRoles) {
            return this.searchGuardRoles(Arrays.asList(searchGuardRoles));
        }

        public Builder searchGuardRoles(Collection<String> searchGuardRoles) {
            if (searchGuardRoles != null) {
                this.searchGuardRoles.addAll(searchGuardRoles);
            }
            return this;
        }

        @Deprecated
        public Builder oldAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            Attributes.validate(attributes);
            this.structuredAttributes.putAll(attributes);
            return this;
        }

        public Builder attribute(String key, Object value) {
            Attributes.validate(value);
            this.structuredAttributes.put(key, value);
            return this;
        }

        public Builder attributesByJsonPath(Map<String, JsonPath> jsonPathMap, Object source) {
            Attributes.addAttributesByJsonPath(jsonPathMap, source, this.structuredAttributes);
            return this;
        }

        @Deprecated
        public Builder oldAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder specialAuthzConfig(Object specialAuthzConfig) {
            this.specialAuthzConfig = specialAuthzConfig;
            return this;
        }

        public Builder authzComplete() {
            this.authzComplete = true;
            return this;
        }

        public User build() {
            return new User(this.name, this.subName, this.authDomainInfo, this.type, this.backendRoles, this.searchGuardRoles, this.specialAuthzConfig, this.requestedTenant, this.structuredAttributes, this.attributes, this.authzComplete);
        }
    }
}

