/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;

public class NoSuchComponentException
extends Exception {
    private static final long serialVersionUID = 3631079566578234957L;
    private final String componentId;
    private final ImmutableList<String> availableTypes;

    public NoSuchComponentException(String componentId) {
        super("No such component: " + componentId);
        this.componentId = componentId;
        this.availableTypes = null;
    }

    public NoSuchComponentException(String componentId, Collection<String> availableTypes) {
        super("No such component: " + componentId);
        this.componentId = componentId;
        this.availableTypes = ImmutableList.of(availableTypes);
    }

    public NoSuchComponentException(String componentId, Throwable cause) {
        super("No such component: " + componentId, cause);
        this.componentId = componentId;
        this.availableTypes = null;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public ImmutableList<String> getAvailableTypes() {
        return this.availableTypes;
    }

    public String getAvailableTypesAsInfoString() {
        if (this.availableTypes != null) {
            return this.availableTypes.stream().collect(Collectors.joining("|"));
        }
        return null;
    }
}

