/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.config;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.StaticDefinable;

public class Tenant
implements Document<ActionGroup>,
Hideable,
StaticDefinable {
    public static final String GLOBAL_TENANT_ID = "SGS_GLOBAL_TENANT";
    private final DocNode source;
    private final boolean reserved;
    private final boolean hidden;
    private final boolean isStatic;
    private final String description;

    public static ValidationResult<Tenant> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        boolean reserved = vNode.get("reserved").withDefault(false).asBoolean();
        boolean hidden = vNode.get("hidden").withDefault(false).asBoolean();
        boolean isStatic = vNode.get("static").withDefault(false).asBoolean();
        String description = vNode.get("description").asString();
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new Tenant(docNode, reserved, hidden, isStatic, description), validationErrors);
    }

    public Tenant(DocNode source, boolean reserved, boolean hidden, boolean isStatic, String description) {
        this.source = source;
        this.reserved = reserved;
        this.hidden = hidden;
        this.isStatic = isStatic;
        this.description = description;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public String getDescription() {
        return this.description;
    }

    public Object toBasicObject() {
        return this.source;
    }
}

