/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.legacy;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.base.IPAddressAcceptanceRules;
import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.legacy.LegacyRestRequestAuthenticationProcessor;
import com.floragunn.searchguard.authc.legacy.LegacyRestRequestMetaData;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authc.rest.AuthenticatingRestFilter;
import com.floragunn.searchguard.authc.rest.ClientAddressAscertainer;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.rest.RestAuthenticationProcessor;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.cache.Cache;
import inet.ipaddr.IPAddress;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class LegacyRestAuthenticationProcessor
implements RestAuthenticationProcessor {
    private static final Logger log = LogManager.getLogger(LegacyRestAuthenticationProcessor.class);
    private final AuditLog auditLog;
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;
    private final Cache<AuthCredentials, User> userCache;
    private final Cache<String, User> impersonationCache;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final BlockedIpRegistry blockedIpRegistry;
    private final BlockedUserRegistry blockedUserRegistry;
    private final RestAuthcConfig authcConfig;
    private final List<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains;
    private final ClientAddressAscertainer clientAddressAscertainer;
    private final IPAddressAcceptanceRules ipAddressAcceptanceRules;
    private final List<String> requiredLoginPrivileges = Collections.emptyList();
    private final ComponentState componentState = new ComponentState(0, "rest_authentication_processor", "legacy_rest_authentication_processor");
    private List<AuthFailureListener> ipAuthFailureListeners = ImmutableList.empty();

    public LegacyRestAuthenticationProcessor(LegacySgConfig legacyConfig, SearchGuardModulesRegistry modulesRegistry, AdminDNs adminDns, BlockedIpRegistry blockedIpRegistry, BlockedUserRegistry blockedUserRegistry, AuditLog auditLog, ThreadPool threadPool, PrivilegesEvaluator privilegesEvaluator) {
        this.authcConfig = legacyConfig.getRestAuthcConfig();
        this.authenticationDomains = modulesRegistry.getImplicitHttpAuthenticationDomains().with(this.authcConfig.getAuthenticators());
        this.clientAddressAscertainer = ClientAddressAscertainer.create(this.authcConfig.getNetwork());
        this.ipAddressAcceptanceRules = IPAddressAcceptanceRules.ANY;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.adminDns = adminDns;
        this.privilegesEvaluator = privilegesEvaluator;
        this.blockedIpRegistry = blockedIpRegistry;
        this.blockedUserRegistry = blockedUserRegistry;
        this.userCache = this.authcConfig.getUserCacheConfig().build();
        this.impersonationCache = this.authcConfig.getUserCacheConfig().build();
        for (AuthenticationDomain<HttpAuthenticationFrontend> authenticationDomain : this.authenticationDomains) {
            this.componentState.addPart(authenticationDomain.getComponentState());
        }
    }

    @Override
    public void authenticate(RestRequest request, RestChannel channel, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        String sslPrincipal = (String)this.threadContext.getTransient("_sg_ssl_principal");
        ClientAddressAscertainer.ClientIpInfo clientInfo = null;
        try {
            clientInfo = this.clientAddressAscertainer.getActualRemoteAddress(request);
        }
        catch (ElasticsearchStatusException e) {
            onFailure.accept((Exception)((Object)e));
            return;
        }
        LegacyRestRequestMetaData requestMetaData = new LegacyRestRequestMetaData(request, clientInfo, sslPrincipal, this.threadContext);
        IPAddress remoteIpAddress = clientInfo.getOriginatingIpAddress();
        if (!this.ipAddressAcceptanceRules.accept(requestMetaData)) {
            log.info("Not accepting request from {}", (Object)requestMetaData);
            channel.sendResponse(new RestResponse(RestStatus.FORBIDDEN, "Forbidden"));
            onResult.accept(new AuthcResult(AuthcResult.Status.STOP));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Rest authentication request from {} [original: {}]", (Object)remoteIpAddress, (Object)request.getHttpChannel().getRemoteAddress());
        }
        if (clientInfo.isTrustedProxy()) {
            this.threadContext.putTransient("_sg_xff_done", (Object)Boolean.TRUE);
        }
        this.threadContext.putTransient("_sg_remote_address", (Object)clientInfo.getOriginatingTransportAddress());
        if (this.blockedIpRegistry.isIpBlocked(remoteIpAddress)) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting REST request because of blocked address: " + request.getHttpChannel().getRemoteAddress());
            }
            this.auditLog.logBlockedIp(request, request.getHttpChannel().getRemoteAddress());
            channel.sendResponse(AuthenticatingRestFilter.createUnauthorizedResponse(request));
            onResult.accept(new AuthcResult(AuthcResult.Status.STOP));
            return;
        }
        new LegacyRestRequestAuthenticationProcessor(requestMetaData, channel, this.threadContext, this.authenticationDomains, this.adminDns, this.privilegesEvaluator, this.userCache, this.impersonationCache, this.auditLog, this.blockedUserRegistry, this.ipAuthFailureListeners, this.requiredLoginPrivileges, false).authenticate(onResult, onFailure);
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void clearCaches() {
        this.userCache.invalidateAll();
        this.impersonationCache.invalidateAll();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

