/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.SignalsTenantParamResolver;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.base.RequestAuthenticationProcessor;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class RestRequestAuthenticationProcessor
extends RequestAuthenticationProcessor<HttpAuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(RestRequestAuthenticationProcessor.class);
    private final RequestMetaData<RestRequest> request;
    private LinkedHashSet<String> challenges = new LinkedHashSet(2);

    public RestRequestAuthenticationProcessor(RequestMetaData<RestRequest> request, Collection<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains, AdminDNs adminDns, PrivilegesEvaluator privilegesEvaluator, Cache<AuthCredentials, User> userCache, Cache<String, User> impersonationCache, AuditLog auditLog, BlockedUserRegistry blockedUserRegistry, List<AuthFailureListener> ipAuthFailureListeners, List<String> requiredLoginPrivileges, boolean debug) {
        super(request, authenticationDomains, adminDns, privilegesEvaluator, userCache, impersonationCache, auditLog, blockedUserRegistry, ipAuthFailureListeners, requiredLoginPrivileges, debug);
        this.request = request;
    }

    @Override
    protected RequestAuthenticationProcessor.AuthDomainState handleCurrentAuthenticationDomain(AuthenticationDomain<HttpAuthenticationFrontend> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        String challenge;
        AuthCredentials ac;
        HttpAuthenticationFrontend authenticationFrontend = authenticationDomain.getFrontend();
        if (log.isTraceEnabled()) {
            log.trace("Try to extract auth creds from {} http authenticator", (Object)authenticationFrontend.getType());
        }
        try {
            ac = authenticationFrontend.extractCredentials(this.request);
        }
        catch (CredentialsException e) {
            if (log.isTraceEnabled()) {
                log.trace("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            }
            this.debug.add(e.getDebugInfo());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        catch (AuthenticatorUnavailableException e) {
            log.warn("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            this.debug.failure(authenticationFrontend.getType(), e.getMessage());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        catch (Exception e) {
            log.error("'{}' extracting credentials from {} authentication frontend", (Object)e.toString(), (Object)authenticationFrontend.getType(), (Object)e);
            this.debug.failure(authenticationFrontend.getType(), e.toString());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        if (ac != null && this.isUserBlocked(authenticationDomain.getType(), ac.getUsername())) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting REST request because of blocked user: " + ac.getUsername() + "; authDomain: " + authenticationDomain);
            }
            this.auditLog.logBlockedUser(ac, false, ac, this.request.getRequest());
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        if (ac == null) {
            log.trace("no {} credentials found in request", (Object)authenticationDomain.getFrontend().getType());
            String challenge2 = authenticationFrontend.getChallenge(ac);
            if (challenge2 != null) {
                this.challenges.add(challenge2);
                this.debug.failure(authenticationFrontend.getType(), "No credentials extracted. Sending challenge", "challenge", challenge2);
            } else {
                this.debug.failure(authenticationFrontend.getType(), "No credentials extracted");
            }
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        ThreadContext.put((String)"user", (String)ac.getUsername());
        if (!ac.isComplete() && (challenge = authenticationFrontend.getChallenge(ac)) != null) {
            this.challenges.add(challenge);
            ac.clearSecrets();
            return RequestAuthenticationProcessor.AuthDomainState.STOP;
        }
        ac = ac.userMappingAttributes((ImmutableMap<String, Object>)ImmutableMap.of((Object)"request", (Object)ImmutableMap.of((Object)"headers", this.request.getHeaders(), (Object)"direct_ip_address", (Object)String.valueOf(this.request.getDirectIpAddress()), (Object)"originating_ip_address", (Object)String.valueOf(this.request.getOriginatingIpAddress()))));
        return this.proceed(ac, authenticationDomain, onResult, onFailure);
    }

    @Override
    protected AuthcResult handleChallenge(RestRequest restRequest) {
        if (this.challenges.size() == 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending WWW-Authenticate: " + String.join((CharSequence)", ", this.challenges));
        }
        return AuthcResult.stop(RestStatus.UNAUTHORIZED, "Unauthorized", (ImmutableMap<String, List<String>>)ImmutableMap.of((Object)"WWW-Authenticate", (Object)ImmutableList.of(this.challenges)), this.debug.get());
    }

    @Override
    protected String getRequestedTenant() {
        return SignalsTenantParamResolver.getRequestedTenant(this.request.getRequest());
    }

    @Override
    protected String getImpersonationUser() {
        return this.request.getHeader("sg_impersonate_as");
    }
}

