/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.searchguard.authc.session.backend.SessionService;
import com.floragunn.searchguard.authc.session.backend.SessionToken;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;

class SessionActivityTracker {
    private static final Logger log = LogManager.getLogger(SessionActivityTracker.class);
    private final String indexName;
    private final SessionService sessionService;
    private final PrivilegedConfigClient privilegedConfigClient;
    private final Map<String, Long> lastAccess = new ConcurrentHashMap<String, Long>();
    private final ThreadPool threadPool;
    private Duration minFlushInterval = Duration.ofSeconds(10L);
    private Duration inactivityTimeout;
    private long inactivityBeforeExpiryMillis;
    private Duration flushInterval;
    private Random random;
    private final ComponentState componentState = new ComponentState(1, null, "session_activity_tracker", SessionActivityTracker.class).initialized();
    private final TimeAggregation flushMetrics = new TimeAggregation.Milliseconds();
    private volatile long lastComponentStateUpdate = -1L;
    private WriteRequest.RefreshPolicy indexRefreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private final SessionFlushThread sessionFlushThread;

    SessionActivityTracker(Duration inactivityTimeout, SessionService sessionService, String indexName, PrivilegedConfigClient privilegedConfigClient, ThreadPool threadPool) {
        this.indexName = indexName;
        this.sessionService = sessionService;
        this.privilegedConfigClient = privilegedConfigClient;
        this.threadPool = threadPool;
        this.random = new Random(System.currentTimeMillis() + (long)this.hashCode());
        this.setInactivityTimeout(inactivityTimeout);
        this.componentState.addMetrics("flush", (Measurement)this.flushMetrics);
        this.sessionFlushThread = new SessionFlushThread();
        this.sessionFlushThread.start();
    }

    void trackAccess(SessionToken authToken) {
        long now = System.currentTimeMillis();
        this.lastAccess.put(authToken.getId(), now + this.inactivityBeforeExpiryMillis);
        this.sessionFlushThread.setEarlyFlushTimeIfNecessary(authToken.getDynamicExpiryTime().toEpochMilli());
        if (this.lastComponentStateUpdate + 10000L < now) {
            this.lastComponentStateUpdate = now;
        }
    }

    void checkExpiryAndTrackAccess(SessionToken authToken, Consumer<Boolean> onResult, Consumer<Exception> onFailure, Meter meter) {
        Instant now = Instant.now();
        if (authToken.getDynamicExpiryTime().isAfter(now)) {
            if (log.isTraceEnabled()) {
                log.trace("Checked timeout of " + authToken.getId() + "; token is not timed out. Expiry: " + authToken.getDynamicExpiryTime() + " (" + authToken.getDynamicExpiryTime().atZone(ZoneOffset.systemDefault()) + ")");
            }
            this.trackAccess(authToken);
            onResult.accept(Boolean.TRUE);
            return;
        }
        Long dynamicExpiryTime = this.lastAccess.get(authToken.getId());
        if (dynamicExpiryTime != null && dynamicExpiryTime > now.toEpochMilli()) {
            if (log.isTraceEnabled()) {
                log.trace("Checked timeout of " + authToken.getId() + "; token is not timed out (needed cache recheck). Expiry: " + authToken.getDynamicExpiryTime() + " (" + authToken.getDynamicExpiryTime().atZone(ZoneOffset.systemDefault()) + ")");
            }
            this.trackAccess(authToken);
            onResult.accept(Boolean.TRUE);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("The token " + authToken.getId() + " seems to have expired; re-checking with fresh index data. Expiry: " + authToken.getDynamicExpiryTime() + " (" + authToken.getDynamicExpiryTime().atZone(ZoneOffset.systemDefault()) + ")");
        }
        this.sessionService.getByIdFromIndex(authToken.getId(), refreshedAuthToken -> {
            if (refreshedAuthToken.getDynamicExpiryTime().isAfter(now)) {
                if (log.isTraceEnabled()) {
                    log.trace("Checked timeout of " + authToken.getId() + "; token is not timed out (needed index recheck). Expiry: " + refreshedAuthToken.getDynamicExpiryTime() + " (" + refreshedAuthToken.getDynamicExpiryTime().atZone(ZoneOffset.systemDefault()) + ")");
                }
                this.trackAccess(authToken);
                onResult.accept(Boolean.TRUE);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("The auth token " + authToken.getId() + " is expired. Expiry: " + refreshedAuthToken.getDynamicExpiryTime() + " (" + refreshedAuthToken.getDynamicExpiryTime().atZone(ZoneOffset.systemDefault()) + ")");
                }
                onResult.accept(Boolean.FALSE);
            }
        }, noSuchAuthTokenException -> onResult.accept(Boolean.FALSE), onFailure, meter);
    }

    Duration getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    synchronized void setInactivityTimeout(Duration inactivityBeforeExpiry) {
        if (this.inactivityTimeout != null && inactivityBeforeExpiry.equals(this.inactivityTimeout)) {
            return;
        }
        this.inactivityTimeout = inactivityBeforeExpiry;
        this.inactivityBeforeExpiryMillis = inactivityBeforeExpiry.toMillis();
        Duration newFlushInterval = inactivityBeforeExpiry.minusSeconds(120L);
        if (newFlushInterval.compareTo(this.minFlushInterval) < 0) {
            newFlushInterval = this.minFlushInterval;
        }
        this.flushInterval = newFlushInterval;
        if (this.sessionFlushThread != null) {
            this.sessionFlushThread.setEarlyFlushTime(Instant.now().plus(newFlushInterval).minusMillis(this.random.nextInt(2000)));
        }
    }

    void setIndexRefreshPolicy(WriteRequest.RefreshPolicy indexRefreshPolicy) {
        this.indexRefreshPolicy = indexRefreshPolicy;
    }

    private void flushWithJitter(String reason, int fixedDelay) {
        if (!this.lastAccess.isEmpty()) {
            if (this.flushInterval.toMillis() < 120000L) {
                this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis((long)(this.random.nextInt(1000) + fixedDelay * 1000)), (Executor)this.threadPool.generic(), () -> this.flush(reason));
            } else {
                this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)(this.random.nextInt(20) + fixedDelay)), (Executor)this.threadPool.generic(), () -> this.flush(reason));
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Not running flush because lastAccess is empty");
        }
    }

    private void flush(String reason) {
        final Meter superMeter = Meter.basic((MetricsLevel)this.sessionService.getMetricsLevel(), (TimeAggregation)this.flushMetrics);
        final Meter meter = superMeter.basic(reason);
        try {
            final HashMap<String, Long> lastAccessCopy = new HashMap<String, Long>(this.lastAccess);
            if (log.isDebugEnabled()) {
                log.debug("Flushing " + lastAccessCopy.size() + " dynamic_expires entries; reason: " + reason + "\n" + lastAccessCopy.keySet());
            }
            if (log.isTraceEnabled()) {
                log.trace(lastAccessCopy);
            }
            this.lastAccess.entrySet().removeIf(entry -> lastAccessCopy.get(entry.getKey()) == entry.getValue());
            final BoolQueryBuilder query = new BoolQueryBuilder();
            query.minimumShouldMatch(1);
            for (Map.Entry entry2 : lastAccessCopy.entrySet()) {
                query.should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{(String)entry2.getKey()})).must((QueryBuilder)QueryBuilders.rangeQuery((String)"dynamic_expires_at").lt(entry2.getValue())));
            }
            ActionListener<SearchResponse> searchListener = new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.getHits().getHits().length == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("No updates for dynamic_expires needed; Flushed in total " + lastAccessCopy.size() + " dynamic_expires entries");
                        }
                        SessionActivityTracker.this.componentState.setState(ComponentState.State.INITIALIZED, "Flushed " + lastAccessCopy.size() + " dynamic_expires entries");
                        meter.close();
                        superMeter.close();
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Got response for dynamic_expires search. Must update " + response.getHits().getHits().length + " tokens");
                    }
                    BulkRequest bulkRequest = new BulkRequest(SessionActivityTracker.this.indexName);
                    bulkRequest.setRefreshPolicy(SessionActivityTracker.this.indexRefreshPolicy);
                    ArrayList<String> sessionIdsToBeUpdated = new ArrayList<String>(response.getHits().getHits().length);
                    for (SearchHit hit : response.getHits().getHits()) {
                        Long localDynamicExpiresAt = (Long)lastAccessCopy.get(hit.getId());
                        if (localDynamicExpiresAt == null) continue;
                        UpdateRequest updateRequest = new UpdateRequest(SessionActivityTracker.this.indexName, hit.getId());
                        sessionIdsToBeUpdated.add(hit.getId());
                        updateRequest.setIfPrimaryTerm(hit.getPrimaryTerm());
                        updateRequest.setIfSeqNo(hit.getSeqNo());
                        updateRequest.doc(new Object[]{"dynamic_expires_at", localDynamicExpiresAt});
                        bulkRequest.add(updateRequest);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Tokens for update " + sessionIdsToBeUpdated);
                    }
                    if (bulkRequest.numberOfActions() != 0) {
                        final Meter updateMeter = meter.basic("update");
                        SessionActivityTracker.this.privilegedConfigClient.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                            public void onResponse(BulkResponse response) {
                                updateMeter.close();
                                int updated = 0;
                                int conflict = 0;
                                ArrayList<String> failureMessages = new ArrayList<String>();
                                for (BulkItemResponse itemResponse : response.getItems()) {
                                    if (itemResponse.isFailed()) {
                                        if (itemResponse.getFailure().getCause() instanceof VersionConflictEngineException) {
                                            ++conflict;
                                            continue;
                                        }
                                        failureMessages.add(Strings.toString((ToXContent)itemResponse.getFailure()));
                                        SessionActivityTracker.this.lastAccess.putIfAbsent(itemResponse.getId(), (Long)lastAccessCopy.get(itemResponse.getId()));
                                        continue;
                                    }
                                    ++updated;
                                }
                                if (failureMessages.isEmpty()) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Writing auth token activity bulk request finished. Updated: " + updated + "; Conflicts: " + conflict);
                                    }
                                } else {
                                    log.error("Error while writing auth token activity:\n" + failureMessages);
                                    SessionActivityTracker.this.componentState.addLastException("session activity update", (Throwable)new Exception(((Object)failureMessages).toString()));
                                    SessionActivityTracker.this.flushWithJitter("retry after error", 30);
                                }
                            }

                            public void onFailure(Exception e) {
                                updateMeter.close();
                                log.error("Error while writing session activity: " + query, (Throwable)e);
                                SessionActivityTracker.this.componentState.addLastException("session activity update", (Throwable)e);
                                SessionActivityTracker.this.restoreLastAccess(lastAccessCopy);
                            }
                        });
                    }
                    final Meter searchMeter = meter.basic("index_search");
                    final 1 self = this;
                    SessionActivityTracker.this.privilegedConfigClient.searchScroll(new SearchScrollRequest(response.getScrollId()), (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            searchMeter.close();
                            self.onResponse((Object)response);
                        }

                        public void onFailure(Exception e) {
                            searchMeter.close();
                            self.onFailure(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    log.error("Error while writing auth token activity: " + query, (Throwable)e);
                    SessionActivityTracker.this.restoreLastAccess(lastAccessCopy);
                    meter.close();
                    superMeter.close();
                }
            };
            this.componentState.setState(ComponentState.State.INITIALIZED, "Flushing " + lastAccessCopy.size() + " dynamic_expires entries");
            final Meter searchMeter = meter.basic("index_search");
            this.privilegedConfigClient.search(new SearchRequest(new String[]{this.indexName}).source(new SearchSourceBuilder().query((QueryBuilder)query).size(1000)).scroll(new TimeValue(10000L)), (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ ActionListener val$searchListener;
                {
                    this.val$searchListener = actionListener;
                }

                public void onResponse(SearchResponse response) {
                    searchMeter.close();
                    this.val$searchListener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    searchMeter.close();
                    this.val$searchListener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Exception during flush(" + reason + ")", (Throwable)e);
            superMeter.close();
            meter.close();
        }
    }

    private void restoreLastAccess(Map<String, Long> lastAccessCopy) {
        for (Map.Entry<String, Long> entry : lastAccessCopy.entrySet()) {
            this.lastAccess.putIfAbsent(entry.getKey(), entry.getValue());
        }
        this.flushWithJitter("restoreLastAccess", 30);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private class SessionFlushThread
    extends Thread {
        private Instant nextFlush;

        SessionFlushThread() {
            super("sg_session_activity_flusher");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SessionFlushThread sessionFlushThread = this;
                        synchronized (sessionFlushThread) {
                            long millisToWait;
                            if (this.nextFlush == null) {
                                this.nextFlush = Instant.now().plus(SessionActivityTracker.this.flushInterval).minusMillis(SessionActivityTracker.this.random.nextInt(2000));
                            }
                            if ((millisToWait = this.nextFlush.toEpochMilli() - System.currentTimeMillis()) > 0L) {
                                this.wait(millisToWait + 10L);
                                if (System.currentTimeMillis() < this.nextFlush.toEpochMilli()) {
                                    continue;
                                }
                            }
                            this.nextFlush = Instant.now().plus(SessionActivityTracker.this.flushInterval);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Flushing sessions now; next scheduled flush is at " + this.nextFlush);
                        }
                        SessionActivityTracker.this.flush("schedule");
                    }
                }
                catch (Exception e) {
                    log.error("Error in sg_session_activity_flusher", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        synchronized void setEarlyFlushTime(Instant newNextFlush) {
            if (this.nextFlush == null || this.nextFlush.isAfter(newNextFlush)) {
                this.nextFlush = newNextFlush;
                this.notifyAll();
            }
        }

        synchronized void setEarlyFlushTimeIfNecessary(long individualSessionTimeout) {
            if (this.nextFlush == null || this.nextFlush.toEpochMilli() - 10000L > individualSessionTimeout) {
                this.nextFlush = Instant.ofEpochMilli(individualSessionTimeout - 10000L);
                if (log.isTraceEnabled()) {
                    log.trace("Earlier flushing necessary. Now flushing at " + this.nextFlush);
                }
                this.notifyAll();
            }
        }
    }
}

