/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;

public class SnapshotRestoreHelper {
    protected static final Logger log = LogManager.getLogger(SnapshotRestoreHelper.class);
    private static final String GENERC_THREAD_NAME = "[generic]";

    public static List<String> resolveOriginalIndices(RestoreSnapshotRequest restoreRequest, RepositoriesService repositoriesService) {
        SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest, repositoriesService);
        if (snapshotInfo == null) {
            log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
            return null;
        }
        return SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotInfo getSnapshotInfo(RestoreSnapshotRequest restoreRequest, RepositoriesService repositoriesService) {
        Repository repository = repositoriesService.repository(restoreRequest.repository());
        String threadName = Thread.currentThread().getName();
        SnapshotInfo snapshotInfo = null;
        try {
            SnapshotRestoreHelper.setCurrentThreadName(GENERC_THREAD_NAME);
            RepositoryDataListener repositoryDataListener = new RepositoryDataListener(restoreRequest, repository);
            repository.getRepositoryData((Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, (ActionListener)repositoryDataListener);
            repositoryDataListener.waitForCompletion();
            snapshotInfo = repositoryDataListener.getSnapshotInfo();
        }
        finally {
            SnapshotRestoreHelper.setCurrentThreadName(threadName);
        }
        return snapshotInfo;
    }

    private static void setCurrentThreadName(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setName(name);
                return null;
            }
        });
    }

    private static final class RepositoryDataListener
    implements ActionListener<RepositoryData> {
        private final RestoreSnapshotRequest restoreRequest;
        private final Repository repository;
        private SnapshotInfo snapshotInfo = null;
        private Exception repositoryException = null;
        private final CountDownLatch latch = new CountDownLatch(1);

        public RepositoryDataListener(RestoreSnapshotRequest restoreRequest, Repository repository) {
            this.restoreRequest = restoreRequest;
            this.repository = repository;
        }

        public void onResponse(RepositoryData repositoryData) {
            SnapshotId snapshotId;
            if (log.isTraceEnabled()) {
                log.trace("RepositoryDataListener got: " + repositoryData);
            }
            if ((snapshotId = this.findSnapshot(this.restoreRequest.snapshot(), repositoryData)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("snapshot found: {} (UUID: {})", (Object)snapshotId.getName(), (Object)snapshotId.getUUID());
                }
                this.repository.getSnapshotInfo(snapshotId, (ActionListener)new ActionListener<SnapshotInfo>(){

                    public void onResponse(SnapshotInfo response) {
                        snapshotInfo = response;
                        latch.countDown();
                    }

                    public void onFailure(Exception e) {
                        log.error("Error in getSnapshotInfo()", (Throwable)e);
                        repositoryException = e;
                        latch.countDown();
                    }
                });
            } else {
                log.warn("Could not find snapshot " + this.restoreRequest.snapshot());
                this.latch.countDown();
            }
        }

        public void onFailure(Exception e) {
            log.error("Error in RepositoryDataListener", (Throwable)e);
            this.repositoryException = e;
            this.latch.countDown();
        }

        public SnapshotInfo getSnapshotInfo() {
            return this.snapshotInfo;
        }

        public Exception getRepositoryException() {
            return this.repositoryException;
        }

        public void waitForCompletion() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }

        private SnapshotId findSnapshot(String snapshotName, RepositoryData repositoryData) {
            for (SnapshotId snapshotId : repositoryData.getSnapshotIds()) {
                if (!snapshotId.getName().equals(snapshotName)) continue;
                return snapshotId;
            }
            return null;
        }
    }
}

