/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class RestAuthenticationIntegrationTests {
    static TestSgConfig.Role INDEX_PATTERN_WITH_ATTR = new TestSgConfig.Role("sg_index_pattern_with_attr_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("/attr_test_${user.attrs.pattern|toRegexFragment}/");
    static TestSgConfig.User ALL_ACCESS = new TestSgConfig.User("all_access").roles(TestSgConfig.Role.ALL_ACCESS);
    static TestSgConfig.User USER_WITH_ATTRIBUTES = new TestSgConfig.User("user_with_attributes").roles(INDEX_PATTERN_WITH_ATTR).attr("a", 1).attr("b", 2).attr("c", Arrays.asList(3, 4, 5)).attr("d", "a");
    static TestSgConfig.User USER_WITH_ATTRIBUTES2 = new TestSgConfig.User("user_with_attributes2").roles(INDEX_PATTERN_WITH_ATTR).attr("a", 1).attr("b", 2).attr("c", Arrays.asList(3, 4, 5)).attr("d", Arrays.asList("a", "b", "c"));
    static TestSgConfig.User SUBJECT_PATTERN_USER_TEST = new TestSgConfig.User("subject_pattern_user").roles(INDEX_PATTERN_WITH_ATTR).attr("a", 1).attr("b", 2).attr("c", Arrays.asList(3, 4, 5)).attr("d", Arrays.asList("a", "c"));
    static TestSgConfig.User SKIP_TEST_USER = new TestSgConfig.User("skip_test_user").roles("skip_test_user_from_internal_users_db");
    static TestSgConfig.User ADDITIONAL_USER_INFORMATION_USER = new TestSgConfig.User("additional_user_information").roles("additional_user_information_role").attr("additional", ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db").skipUsers("skip_test_*").skipIps("127.0.0.16/30").userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFrom(DocNode.of((String)"json_path", (Object)"credentials.user_name", (String)"pattern", (Object)"(all_access)|(user_.*)|(.+)@(?:subject_pattern_domain)")).attrsFrom("pattern", "user_entry.attributes.d")), new TestSgConfig.Authc.Domain("trusted_origin").skipUsers("skip_test_*").skipIps("127.0.0.16/30", "127.0.0.14").userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFrom("request.headers.x-proxy-user").rolesFrom("request.headers.x-proxy-roles").rolesFrom(DocNode.of((String)"json_path", (Object)"request.headers.x-proxy-roles-comma-separated", (String)"split", (Object)","))), new TestSgConfig.Authc.Domain("trusted_origin").id("trusted_origin_with_additional_user_information").skipUsers("skip_test_*").acceptIps("127.0.0.14").additionalUserInformation(new TestSgConfig.Authc.Domain.AdditionalUserInformation("internal_users_db")).userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFrom("request.headers.x-proxy-user").rolesFrom("request.headers.x-proxy-roles").attrsFrom("from_user_entry", "user_entry")), new TestSgConfig.Authc.Domain("basic").acceptUsers("skip_test_*").skipUsers("skip_test_skip").skipIps("127.0.0.16/30").userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesStatic("skip_test_user_role_from_accept_users_auth_domain")), new TestSgConfig.Authc.Domain("basic").acceptUsers("skip_test_*").skipUsers("skip_test_skip").acceptIps("127.0.0.16/30").userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesStatic("skip_test_user_role_from_accept_ips_auth_domain")), new TestSgConfig.Authc.Domain("anonymous").acceptIps("127.0.0.33").userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesStatic("anon_role")), new TestSgConfig.Authc.Domain("anonymous").acceptIps("127.0.0.34").userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameStatic("nobody").rolesStatic("anon_role"))).trustedProxies("127.0.0.12/30");
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(ALL_ACCESS, USER_WITH_ATTRIBUTES, USER_WITH_ATTRIBUTES2, SUBJECT_PATTERN_USER_TEST, ADDITIONAL_USER_INFORMATION_USER).authc(AUTHC).embedded().build();

    @BeforeClass
    public static void initTestData() {
        Client tc = cluster.getInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("attr_test_a").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"a\", \"amount\": 1010}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_b").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"b\", \"amount\": 2020}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_c").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"c\", \"amount\": 3030}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_d").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"d\", \"amount\": 4040}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_e").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"e\", \"amount\": 5050}", XContentType.JSON)).actionGet();
    }

    @Test
    public void userAttribute_indexPattern_integration() throws Exception {
        SearchResponse<Map> searchResponse;
        try (RestHighLevelClient client = cluster.getRestHighLevelClient(ALL_ACCESS);){
            searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)5L, (long)searchResponse.hits().total().value());
        }
        client = cluster.getRestHighLevelClient(USER_WITH_ATTRIBUTES);
        try {
            searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)1L, (long)searchResponse.hits().total().value());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = cluster.getRestHighLevelClient(USER_WITH_ATTRIBUTES2);
        try {
            searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)3L, (long)searchResponse.hits().total().value());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void username_pattern_integration() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("subject_pattern_user@subject_pattern_domain", SUBJECT_PATTERN_USER_TEST.getPassword(), new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"subject_pattern_user", (Object)response.getBodyAsDocNode().get("user_name"));
        }
    }

    @Test
    public void trustedOrigin_roles_integration() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "proxy_test_user"), new BasicHeader("x-proxy-roles", "proxy_role1,proxy_role2")});
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 13}));
            response = client.get("/_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "proxy_test_user"), new BasicHeader("x-proxy-roles", "proxy_role1,proxy_role2")});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"proxy_test_user", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("proxy_role1,proxy_role2"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            response = client.get("/_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "proxy_test_user"), new BasicHeader("x-proxy-roles", "proxy_role1"), new BasicHeader("x-proxy-roles", "proxy_role2")});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Arrays.asList("proxy_role1", "proxy_role2"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            response = client.get("/_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "proxy_test_user"), new BasicHeader("x-proxy-roles-comma-separated", "proxy_role1,proxy_role2"), new BasicHeader("x-proxy-roles", "proxy_role3")});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)ImmutableSet.of((Object)"proxy_role1", (Object[])new String[]{"proxy_role2", "proxy_role3"}), (Object)ImmutableSet.of((Collection)((Collection)response.getBodyAsDocNode().get("backend_roles"))));
        }
    }

    @Test
    public void trustedOrigin_additionalUserInformation_integration() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BasicHeader("x-proxy-user", ADDITIONAL_USER_INFORMATION_USER.getName()), new BasicHeader("x-proxy-roles", "proxy_role1"), new BasicHeader("x-proxy-roles", "proxy_role2")});){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 14}));
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)ADDITIONAL_USER_INFORMATION_USER.getName(), (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("proxy_role1", "proxy_role2"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("additional_user_information_role"), (Object)response.getBodyAsDocNode().get("sg_roles"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("from_user_entry"), (Object)response.getBodyAsDocNode().get("attribute_names"));
        }
    }

    @Test
    public void skipUser_integration() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient(SKIP_TEST_USER, new Header[0]);){
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"skip_test_user", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("skip_test_user_role_from_accept_users_auth_domain"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
        client = cluster.getRestClient("skip_test_skip", "password", new Header[0]);
        try {
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void skipIp_integration() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(SKIP_TEST_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"skip_test_user", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("skip_test_user_role_from_accept_users_auth_domain"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 17}));
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"skip_test_user", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("skip_test_user_role_from_accept_ips_auth_domain"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
    }

    @Test
    public void anonymousAuth() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 33}));
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"anonymous", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("anon_role"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 34}));
            response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"nobody", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("anon_role"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
    }

    @Test
    public void challenge() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getHeaders().toString(), (Object)"Basic realm=\"Search Guard\"", (Object)response.getHeaderValue("WWW-Authenticate"));
        }
    }

    @Test
    public void jsonResponse() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[]{new BasicHeader("Accept", "application/json")});
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getHeaders().toString(), (Object)"application/json", (Object)response.getHeaderValue("Content-Type"));
            Assert.assertEquals((String)response.getBody(), (Object)"Unauthorized", (Object)response.getBodyAsDocNode().get("error", new String[]{"reason"}));
            Assert.assertEquals((String)response.getBody(), (Object)401, (Object)response.getBodyAsDocNode().get("status"));
        }
    }

    @Test
    public void jsonResponseEsClientParsing() throws Exception {
        try (RestClient lowLevelRestClient = cluster.getLowLevelRestClient(new Header[0]);){
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(lowLevelRestClient, (JsonpMapper)new JacksonJsonpMapper()));
            try {
                client.cat().indices();
                Assert.fail();
            }
            catch (ElasticsearchException e) {
                Assert.assertEquals((String)e.toString(), (long)401L, (long)e.status());
            }
        }
    }

    @Test
    public void authDomainInfo() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(ALL_ACCESS, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().getAsString("user").startsWith("User all_access <basic/internal_users_db>"));
        }
    }
}

