/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class RestHighLevelClient
implements AutoCloseable,
Closeable {
    private static final JacksonJsonpMapper JACKSON_JSONP_MAPPER = new JacksonJsonpMapper();
    private final RestClientBuilder builder;
    private final RestClient restClient;
    private final ElasticsearchTransport transport;
    private final ElasticsearchClient elasticsearchClient;
    private volatile boolean closed;

    public RestHighLevelClient(RestClientBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
        this.restClient = builder.build();
        this.transport = new RestClientTransport(this.restClient, (JsonpMapper)JACKSON_JSONP_MAPPER);
        this.elasticsearchClient = new ElasticsearchClient(this.transport);
    }

    public ElasticsearchClient getJavaClient() {
        this.assertOpen();
        return this.elasticsearchClient;
    }

    @Override
    public void close() {
        this.closed = true;
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.transport});
    }

    public RestClient getLowLevelClient() {
        this.assertOpen();
        return this.restClient;
    }

    public Response reloadTransportCerts() throws IOException {
        this.assertOpen();
        return this.getLowLevelClient().performRequest(new Request("POST", "/_searchguard/api/ssl/transport/reloadcerts/"));
    }

    public Response reloadHttpCerts() throws IOException {
        this.assertOpen();
        return this.getLowLevelClient().performRequest(new Request("POST", "/_searchguard/api/ssl/http/reloadcerts/"));
    }

    public SearchResponse<Map> search(String index) throws IOException {
        this.assertOpen();
        return this.getJavaClient().search(new SearchRequest.Builder().index(index, new String[0]).build(), Map.class);
    }

    public SearchResponse<Map> search(String index, int from, int size) throws IOException {
        this.assertOpen();
        return this.getJavaClient().search(new SearchRequest.Builder().index(index, new String[0]).from(Integer.valueOf(from)).size(Integer.valueOf(size)).build(), Map.class);
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Client is already closed");
        }
    }

    public IndexResponse index(String index, Map<String, String> source) throws IOException {
        this.assertOpen();
        return this.getJavaClient().index(i -> i.index(index).document((Object)source));
    }

    public IndexResponse index(String index, String id, Map<String, Object> source) throws IOException {
        this.assertOpen();
        return this.getJavaClient().index(i -> i.index(index).id(id).document((Object)source));
    }

    public GetResponse<Map> get(String index, String id) throws IOException {
        this.assertOpen();
        return this.getJavaClient().get(g -> g.index(index).id(id), Map.class);
    }
}

