/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestComponentTemplate;
import org.apache.http.Header;

public class TestIndexTemplate
implements Document<TestIndexTemplate> {
    public static final TestIndexTemplate DATA_STREAM_MINIMAL = new TestIndexTemplate("test_index_template_data_stream_minimal", "ds_*").dataStream().composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL);
    private String name;
    private ImmutableList<String> indexPatterns;
    private DocNode dataStream;
    private ImmutableList<TestComponentTemplate> composedOf = ImmutableList.empty();
    private int priority = 0;

    public TestIndexTemplate(String name, String ... indexPatterns) {
        this.name = name;
        this.indexPatterns = ImmutableList.ofArray((Object[])indexPatterns);
    }

    public TestIndexTemplate dataStream() {
        this.dataStream = DocNode.EMPTY;
        return this;
    }

    public TestIndexTemplate dataStream(String k, Object v) {
        this.dataStream = DocNode.of((String)k, (Object)v);
        return this;
    }

    public TestIndexTemplate composedOf(TestComponentTemplate ... composedOf) {
        this.composedOf = ImmutableList.ofArray((Object[])composedOf);
        return this;
    }

    public TestIndexTemplate priority(int priority) {
        this.priority = priority;
        return this;
    }

    public Object toBasicObject() {
        return DocNode.of((String)"index_patterns", this.indexPatterns, (String)"priority", (Object)this.priority, (String)"data_stream", (Object)this.dataStream, (String)"composed_of", (Object)this.composedOf.map(TestComponentTemplate::getName));
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<TestComponentTemplate> getComposedOf() {
        return this.composedOf;
    }

    public void create(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response = client.putJson("/_index_template/" + this.name, this.toJsonString(), new Header[0]);
        if (response.getStatusCode() != 200) {
            throw new RuntimeException("Error while creating component template " + this.name + "\n" + String.valueOf(response));
        }
    }
}

