/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LeakDetector;
import com.floragunn.searchguard.test.helper.cluster.LocalEsCluster;
import com.floragunn.searchguard.test.helper.cluster.TestCertificateBasedSSLContextProvider;
import com.floragunn.searchguard.test.helper.network.PortAllocator;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.internal.AdminClient;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.xcontent.ToXContent;
import org.junit.Assert;

public class JvmEmbeddedEsCluster
extends LocalEsCluster {
    private static final Logger log;
    private final List<Class<? extends Plugin>> additionalPlugins;
    private final List<Node> allNodes = new ArrayList<Node>();
    private final List<Node> masterNodes = new ArrayList<Node>();
    private final List<Node> dataNodes = new ArrayList<Node>();
    private final List<Node> clientNodes = new ArrayList<Node>();
    private final LeakDetector leakDetector;

    public JvmEmbeddedEsCluster(String clusterName, ClusterConfiguration clusterConfiguration, NodeSettingsSupplier nodeSettingsSupplier, List<Class<? extends Plugin>> additionalPlugins, TestCertificates testCertificates) {
        super(clusterName, clusterConfiguration, nodeSettingsSupplier, testCertificates);
        this.additionalPlugins = additionalPlugins;
        this.leakDetector = new LeakDetector();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.leakDetector.start();
    }

    @Override
    public void destroy() {
        try {
            this.stop();
            this.clientNodes.clear();
            this.dataNodes.clear();
            this.masterNodes.clear();
        }
        finally {
            this.leakDetector.stop();
        }
        try {
            FileUtils.deleteDirectory((File)this.clusterHomeDir);
        }
        catch (IOException e) {
            log.warn("Error while deleting " + String.valueOf(this.clusterHomeDir), (Throwable)e);
        }
    }

    public List<Node> getAllNodes() {
        return Collections.unmodifiableList(this.allNodes);
    }

    protected CompletableFuture<Node> startNode(ClusterConfiguration.NodeSettings nodeSettings, int httpPort, int transportPort) {
        return new Node(nodeSettings, transportPort, httpPort).start();
    }

    @Override
    public void waitForGreenCluster() throws Exception {
        ClusterHealthStatus status = ClusterHealthStatus.GREEN;
        TimeValue timeout = TimeValue.timeValueSeconds((long)10L);
        int expectedNodeCount = this.allNodes.size();
        Client client = this.clientNode().getInternalNodeClient();
        try {
            AdminClient adminClient = client.admin();
            TimeValue masterNoeTimeout = TimeValue.timeValueSeconds((long)40L);
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)adminClient.cluster().prepareHealth(masterNoeTimeout, new String[0]).setWaitForStatus(status).setTimeout(timeout).setMasterNodeTimeout(timeout)).setWaitForNodes("" + expectedNodeCount).execute().actionGet();
            if (log.isDebugEnabled()) {
                log.debug("Current ClusterState:\n{}", (Object)Strings.toString((ToXContent)healthResponse));
            }
            if (healthResponse.isTimedOut()) {
                throw new Exception("cluster state is " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes");
            }
            log.debug("... cluster state ok {} with {} nodes", (Object)healthResponse.getStatus().name(), (Object)healthResponse.getNumberOfNodes());
            Assert.assertEquals((long)expectedNodeCount, (long)healthResponse.getNumberOfNodes());
        }
        catch (ElasticsearchTimeoutException e) {
            throw new Exception("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
        }
    }

    public <X> X getInjectable(Class<X> clazz) {
        return ((Node)this.masterNode()).getInjectable(clazz);
    }

    public String toString() {
        return "\nES Cluster " + this.clusterName + "\nmaster nodes: " + String.valueOf(this.masterNodes) + "\n  data nodes: " + String.valueOf(this.dataNodes) + "\nclient nodes: " + String.valueOf(this.clientNodes) + "\n";
    }

    @Override
    protected void destroyNodes() {
        this.allNodes.clear();
        this.masterNodes.clear();
        this.dataNodes.clear();
        this.clientNodes.clear();
    }

    public List<Node> clientNodes() {
        return this.clientNodes;
    }

    public List<Node> dataNodes() {
        return this.dataNodes;
    }

    public List<Node> masterNodes() {
        return this.masterNodes;
    }

    @Override
    public Node clientNode() {
        return (Node)super.clientNode();
    }

    static {
        System.setProperty("es.enforce.bootstrap.checks", "true");
        log = LogManager.getLogger(JvmEmbeddedEsCluster.class);
    }

    public class Node
    implements EsClientProvider,
    LocalEsCluster.Node {
        private final String nodeName;
        private final ClusterConfiguration.NodeSettings nodeSettings;
        private final File nodeHomeDir;
        private final File dataDir;
        private final File logsDir;
        private final int transportPort;
        private final int httpPort;
        private final InetSocketAddress httpAddress;
        private final InetSocketAddress transportAddress;
        private PluginAwareNode node;
        private boolean running = false;

        Node(ClusterConfiguration.NodeSettings nodeSettings, int transportPort, int httpPort) {
            this.nodeName = nodeSettings.name;
            this.nodeSettings = nodeSettings;
            this.nodeHomeDir = new File(JvmEmbeddedEsCluster.this.clusterHomeDir, this.nodeName);
            this.dataDir = new File(this.nodeHomeDir, "data");
            this.logsDir = new File(this.nodeHomeDir, "logs");
            this.transportPort = transportPort;
            this.httpPort = httpPort;
            InetAddress hostAddress = InetAddresses.forString((String)"127.0.0.1");
            this.httpAddress = new InetSocketAddress(hostAddress, httpPort);
            this.transportAddress = new InetSocketAddress(hostAddress, transportPort);
            if (nodeSettings.masterNode) {
                JvmEmbeddedEsCluster.this.masterNodes.add(this);
            } else if (nodeSettings.dataNode) {
                JvmEmbeddedEsCluster.this.dataNodes.add(this);
            } else {
                JvmEmbeddedEsCluster.this.clientNodes.add(this);
            }
            JvmEmbeddedEsCluster.this.allNodes.add(this);
        }

        CompletableFuture<Node> start() {
            final CompletableFuture<Node> completableFuture = new CompletableFuture<Node>();
            this.node = new PluginAwareNode(this.nodeSettings.masterNode, this.getEsSettings(), JvmEmbeddedEsCluster.this.additionalPlugins);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Node.this.node.start();
                        Node.this.running = true;
                        completableFuture.complete(Node.this);
                    }
                    catch (BindHttpException | BindTransportException e) {
                        log.warn("Port collision detected for {}", (Object)this, (Object)e);
                        JvmEmbeddedEsCluster.this.portCollisionDetected = true;
                        try {
                            Node.this.node.close();
                        }
                        catch (IOException e1) {
                            log.error((Object)e1);
                        }
                        Node.this.node = null;
                        PortAllocator.TCP.blacklist(Node.this.transportPort, Node.this.httpPort);
                        completableFuture.completeExceptionally(e);
                    }
                    catch (Throwable e) {
                        log.error("Unable to start {}", (Object)this, (Object)e);
                        Node.this.node = null;
                        completableFuture.completeExceptionally(e);
                    }
                }
            }).start();
            return completableFuture;
        }

        public Client getInternalNodeClient() {
            return this.node.client();
        }

        public PluginAwareNode esNode() {
            return this.node;
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }

        public <X> X getInjectable(Class<X> clazz) {
            return (X)this.node.injector().getInstance(clazz);
        }

        @Override
        public void stop() {
            try {
                log.info("Stopping {}", (Object)this);
                this.running = false;
                if (this.node != null) {
                    this.node.close();
                    this.node = null;
                    Thread.sleep(10L);
                }
            }
            catch (Throwable e) {
                log.warn("Error while stopping " + String.valueOf(this), e);
            }
        }

        public String toString() {
            String state = this.running ? "RUNNING" : (this.node != null ? "INITIALIZING" : "STOPPED");
            return this.nodeName + " " + state + " [" + this.transportPort + ", " + this.httpPort + "]";
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        public InetSocketAddress getHttpAddress() {
            return this.httpAddress;
        }

        @Override
        public InetSocketAddress getTransportAddress() {
            return this.transportAddress;
        }

        public RestHighLevelClient getRestHighLevelClient(BasicHeader basicHeader) {
            TestCertificateBasedSSLContextProvider sslContextProvider = new TestCertificateBasedSSLContextProvider(JvmEmbeddedEsCluster.this.testCertificates.getCaCertificate(), JvmEmbeddedEsCluster.this.testCertificates.getAnyClientCertificate());
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.getHttpAddress().getHostString(), this.getHttpAddress().getPort(), "https")}).setDefaultHeaders(new Header[]{basicHeader}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContextProvider.getSslContext(false), null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)));
            return new RestHighLevelClient(builder);
        }

        private Settings getEsSettings() {
            Settings.Builder settings = Settings.builder().put(this.getMinimalNodeSpecificSettings()).put(JvmEmbeddedEsCluster.this.getMinimalEsSettings());
            if (JvmEmbeddedEsCluster.this.nodeSettingsSupplier != null) {
                settings.put(JvmEmbeddedEsCluster.this.nodeSettingsSupplier.get(0));
            }
            if (JvmEmbeddedEsCluster.this.testCertificates != null) {
                settings.put(JvmEmbeddedEsCluster.this.testCertificates.getSgSettings());
            }
            return settings.build();
        }

        private Settings getMinimalNodeSpecificSettings() {
            ArrayList<String> nodeRoles = new ArrayList<String>();
            if (this.nodeSettings.dataNode) {
                nodeRoles.add("data");
            }
            if (this.nodeSettings.masterNode) {
                nodeRoles.add("master");
            }
            nodeRoles.add("remote_cluster_client");
            return Settings.builder().put("node.name", this.nodeName).putList("node.roles", nodeRoles).put("path.home", this.nodeHomeDir.toPath()).put("path.data", this.dataDir.toPath()).put("path.logs", this.logsDir.toPath()).put("transport.port", this.transportPort).put("http.port", this.httpPort).build();
        }

        @Override
        public String getClusterName() {
            return JvmEmbeddedEsCluster.this.clusterName;
        }

        @Override
        public TestCertificates getTestCertificates() {
            return JvmEmbeddedEsCluster.this.testCertificates;
        }

        @Override
        public Consumer<GenericRestClient.RequestInfo> getRequestInfoConsumer() {
            return null;
        }
    }
}

