/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class BackendRegistryTests {
    static TestSgConfig.User TEST_USER = new TestSgConfig.User("test_user").roles("SGS_ALL_ACCESS");
    static TestSgConfig.User BLOCK_TEST_USER = new TestSgConfig.User("block_test_user").roles("SGS_ALL_ACCESS");
    static TestSgConfig.User BLOCK_WILDCARD_TEST_USER = new TestSgConfig.User("block_wildcard_test_user").roles("SGS_ALL_ACCESS");
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/noop").acceptIps("127.0.0.4/30"), new TestSgConfig.Authc.Domain("basic/internal_users_db")).trustedProxies("127.0.0.44");
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().authc(AUTHC).users(TEST_USER, BLOCK_TEST_USER, BLOCK_WILDCARD_TEST_USER).embedded().build();

    @Test
    public void when_user_is_blocked_then_authentication_should_fail() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(BLOCK_TEST_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            cluster.updateSgConfig(CType.BLOCKS, "block_" + BLOCK_TEST_USER.getName(), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"name", (Object)"value", Arrays.asList(BLOCK_TEST_USER.getName()), (Object)"verdict", (Object)"disallow"));
            response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void when_user_is_blocked_then_authentication_should_fail_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(BLOCK_WILDCARD_TEST_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            cluster.updateSgConfig(CType.BLOCKS, "block_" + BLOCK_WILDCARD_TEST_USER.getName(), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"name", (Object)"value", Arrays.asList("block_wildcard_*"), (Object)"verdict", (Object)"disallow"));
            response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void when_ip_is_blocked_then_authentication_should_fail() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(TEST_USER, new Header[0]);){
            restClient.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 99}));
            GenericRestClient.HttpResponse response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            cluster.updateSgConfig(CType.BLOCKS, "block_ip", (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"ip", (Object)"value", Arrays.asList("127.0.0.99"), (Object)"verdict", (Object)"disallow"));
            response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void when_ip_is_blocked_from_net_then_authentication_should_fail() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(TEST_USER, new Header[0]);){
            restClient.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 90}));
            GenericRestClient.HttpResponse response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            cluster.updateSgConfig(CType.BLOCKS, "block_ip", (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"net_mask", (Object)"value", Arrays.asList("127.0.0.88/29"), (Object)"verdict", (Object)"disallow"));
            response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void when_xff_ip_is_blocked_from_net_then_authentication_should_fail() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(TEST_USER, new Header[]{new BasicHeader("X-Forwarded-For", "10.11.12.13")});){
            restClient.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 44}));
            GenericRestClient.HttpResponse response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            cluster.updateSgConfig(CType.BLOCKS, "block_ip", (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"net_mask", (Object)"value", Arrays.asList("10.11.12.8/29"), (Object)"verdict", (Object)"disallow"));
            response = restClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Ignore(value="TODO replacement")
    @Test
    public void testFailureRateLimitingXff() throws Exception {
        try (LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().start();){
            BasicHeader xffHeader = new BasicHeader("X-Forwarded-For", "10.14.15.16");
            try (GenericRestClient authRestClient = cluster.getRestClient(TEST_USER, new Header[]{xffHeader});
                 GenericRestClient unauthRestClient = cluster.getRestClient("any_name", "any_password", new Header[]{xffHeader});){
                GenericRestClient.HttpResponse response = authRestClient.get("_searchguard/authinfo?pretty", new Header[0]);
                Assert.assertEquals((String)response.toString(), (long)200L, (long)response.getStatusCode());
                response = unauthRestClient.get("_searchguard/authinfo?pretty", new Header[0]);
                Assert.assertEquals((String)response.toString(), (long)401L, (long)response.getStatusCode());
                response = authRestClient.get("_searchguard/authinfo?pretty", new Header[0]);
                Assert.assertEquals((String)response.toString(), (long)200L, (long)response.getStatusCode());
                for (int i = 0; i < 3; ++i) {
                    response = unauthRestClient.get("_searchguard/authinfo?pretty", new Header[0]);
                    Assert.assertEquals((String)response.toString(), (long)401L, (long)response.getStatusCode());
                }
                response = authRestClient.get("_searchguard/authinfo?pretty", new Header[0]);
                Assert.assertEquals((String)response.toString(), (long)401L, (long)response.getStatusCode());
            }
        }
    }
}

