/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ActionGroupsTest {
    @Test
    public void basicTest() throws Exception {
        TestActionGroup testActionGroups = new TestActionGroup().with("Z", "C", "A").with("A", "A1", "A2", "A3").with("B", "B1", "B2", "B3").with("C", "A", "B", "C1");
        SgDynamicConfiguration config = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap(testActionGroups.map, (CType)CType.ACTIONGROUPS, null).get();
        ActionGroup.FlattenedIndex actionGroups = new ActionGroup.FlattenedIndex(config);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"C", (Object[])new String[]{"A", "A1", "A2", "A3", "C1", "B", "B1", "B2", "B3", "Z"}), (Object)actionGroups.resolve((Collection)ImmutableSet.of((Object)"Z")));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object[])new String[]{"A1", "A2", "A3"}), (Object)actionGroups.resolve((Collection)ImmutableSet.of((Object)"A")));
    }

    @Test
    public void recursionTest() throws Exception {
        TestActionGroup testActionGroups = new TestActionGroup().with("A", "A1", "B").with("B", "B1", "C").with("C", "C1", "A", "D").with("D", "D1");
        SgDynamicConfiguration config = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap(testActionGroups.map, (CType)CType.ACTIONGROUPS, null).get();
        ActionGroup.FlattenedIndex actionGroups = new ActionGroup.FlattenedIndex(config);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object[])new String[]{"A1", "B", "B1", "C", "C1", "D", "D1"}), (Object)actionGroups.resolve((Collection)ImmutableSet.of((Object)"A")));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object[])new String[]{"A1", "B", "B1", "C", "C1", "D", "D1"}), (Object)actionGroups.resolve((Collection)ImmutableSet.of((Object)"C")));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"D", (Object)"D1"), (Object)actionGroups.resolve((Collection)ImmutableSet.of((Object)"D")));
    }

    @Test
    public void staticActionGroupsSmokeTest() throws Exception {
        SgDynamicConfiguration config = (SgDynamicConfiguration)SgDynamicConfiguration.fromDocNode((DocNode)DocNode.parse((Format)Format.YAML).from((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/static_config/static_action_groups.yml"))), null, (CType)CType.ACTIONGROUPS, (long)0L, (long)0L, (long)0L, null).get();
        ActionGroup.FlattenedIndex actionGroups = new ActionGroup.FlattenedIndex(config);
        ImmutableSet resolved = actionGroups.resolve((Collection)ImmutableSet.of((Object)"SGS_CRUD"));
        Assert.assertTrue((String)resolved.toString(), (boolean)resolved.contains((Object)"SGS_READ"));
        Assert.assertTrue((String)resolved.toString(), (boolean)resolved.contains((Object)"indices:data/read*"));
        Assert.assertTrue((String)resolved.toString(), (boolean)resolved.contains((Object)"SGS_CRUD"));
    }

    private static class TestActionGroup {
        private Map<String, Object> map = new HashMap<String, Object>();

        private TestActionGroup() {
        }

        TestActionGroup with(String key, String ... actions) {
            this.map.put(key, ImmutableMap.of((Object)"allowed_actions", Arrays.asList(actions)));
            return this;
        }
    }
}

