/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.awaitility.Awaitility;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.transport.LeakTracker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class LeakDetector {
    private final LeakToListAppender leakToListAppender = new LeakToListAppender();

    public void start() {
        Logger leakTrackerLoggerInstance = this.getLeakTrackerLogger();
        if (!leakTrackerLoggerInstance.isErrorEnabled()) {
            throw new RuntimeException("LeakTracker's logger - error level is disabled");
        }
        this.leakToListAppender.start();
        Loggers.addAppender((Logger)leakTrackerLoggerInstance, (Appender)this.leakToListAppender);
    }

    public void stop() {
        try {
            System.gc();
            Awaitility.await((String)"List of logged leaks should be empty").failFast("List of logged leaks is not empty", () -> MatcherAssert.assertThat(this.leakToListAppender.getLoggedLeaks(), (Matcher)Matchers.empty())).during(Duration.ofSeconds(2L)).pollInterval(Duration.ofMillis(50L)).until(() -> true);
        }
        finally {
            Logger leakTrackerLoggerInstance = this.getLeakTrackerLogger();
            Loggers.removeAppender((Logger)leakTrackerLoggerInstance, (Appender)this.leakToListAppender);
            this.leakToListAppender.stop();
        }
    }

    private Logger getLeakTrackerLogger() {
        String leakTrackerLoggerName = LeakTracker.class.getName();
        return LogManager.getLogger((String)leakTrackerLoggerName);
    }

    private static class LeakToListAppender
    extends AbstractAppender {
        private final List<String> leaksFromLogs = Collections.synchronizedList(new ArrayList());

        private LeakToListAppender() {
            super("leak to list appender", null, (Layout)PatternLayout.newBuilder().withPattern("%m").build(), true, Property.EMPTY_ARRAY);
        }

        public void append(LogEvent event) {
            String message = event.getMessage().getFormattedMessage();
            if (Level.ERROR.equals((Object)event.getLevel()) && message.contains("LEAK:")) {
                this.leaksFromLogs.add(message);
            }
        }

        private List<String> getLoggedLeaks() {
            return this.leaksFromLogs;
        }
    }
}

