/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class LocalClusterTest {
    private static final Logger log = LogManager.getLogger(LocalClusterTest.class);
    private static final String LIMITED_ROLE_NAME = "limited-role";
    private static final TestSgConfig.User USER_LIMITED = new TestSgConfig.User("limited-user").roles("limited-role");
    private static final TestSgConfig.User USER_WITHOUT_ROLE = new TestSgConfig.User("user-without-role");
    private static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(TestSgConfig.Role.ALL_ACCESS.getName());
    private static final String INDEX_NAME = "some-index";
    @ClassRule
    public static LocalCluster.Embedded CLUSTER = new LocalCluster.Builder().singleNode().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db"))).roles(TestSgConfig.Role.ALL_ACCESS).user(USER_ADMIN).users(USER_LIMITED).user(USER_WITHOUT_ROLE).sslEnabled().enterpriseModulesEnabled().embedded().build();

    @BeforeClass
    public static void setupData() {
        Client client = CLUSTER.getPrivilegedInternalNodeClient();
        client.index((IndexRequest)new IndexRequest(INDEX_NAME).id("contradiction").source(new Object[]{"yes", "no"}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
    }

    @Test
    public void shouldUpdateAndRestoreConfigurationOfRoles() throws Exception {
        GenericRestClient.HttpResponse response;
        TestSgConfig.Role role = new TestSgConfig.Role(LIMITED_ROLE_NAME).clusterPermissions("*").indexPermissions("*").on(INDEX_NAME);
        try (GenericRestClient client = CLUSTER.getRestClient(USER_LIMITED, new Header[0]);){
            response = client.get("/some-index/_search", new Header[0]);
            log.info("Search response before config update '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
        AtomicBoolean updateExecutedCorrectly = new AtomicBoolean(false);
        response = CLUSTER.callAndRestoreConfig(CType.ROLES, () -> {
            CLUSTER.updateRolesConfig(role);
            try (GenericRestClient client = CLUSTER.getRestClient(USER_LIMITED, new Header[0]);){
                updateExecutedCorrectly.set(true);
                GenericRestClient.HttpResponse httpResponse = client.get("/some-index/_search", new Header[0]);
                return httpResponse;
            }
        });
        log.info("Search response after config update '{}'", (Object)response.getBody());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)updateExecutedCorrectly.get(), (Matcher)Matchers.equalTo((Object)true));
        try (GenericRestClient client = CLUSTER.getRestClient(USER_LIMITED, new Header[0]);){
            response = client.get("/some-index/_search", new Header[0]);
            log.info("Search response after restore config '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void shouldUpdateAndRestoreConfigurationOfRoleMappings() throws Exception {
        GenericRestClient.HttpResponse response;
        TestSgConfig.RoleMapping mapping = new TestSgConfig.RoleMapping(TestSgConfig.Role.ALL_ACCESS.getName()).users(USER_WITHOUT_ROLE.getName());
        try (GenericRestClient client = CLUSTER.getRestClient(USER_WITHOUT_ROLE, new Header[0]);){
            response = client.get("/some-index/_search", new Header[0]);
            log.info("Search response before config update '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
        AtomicBoolean updateExecutedCorrectly = new AtomicBoolean(false);
        response = CLUSTER.callAndRestoreConfig(CType.ROLESMAPPING, () -> {
            CLUSTER.updateRolesMappingsConfig(mapping);
            try (GenericRestClient client = CLUSTER.getRestClient(USER_WITHOUT_ROLE, new Header[0]);){
                updateExecutedCorrectly.set(true);
                GenericRestClient.HttpResponse httpResponse = client.get("/some-index/_search", new Header[0]);
                return httpResponse;
            }
        });
        MatcherAssert.assertThat((Object)updateExecutedCorrectly.get(), (Matcher)Matchers.equalTo((Object)true));
        log.info("Search response after config update '{}'", (Object)response.getBody());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        GenericRestClient client = CLUSTER.getRestClient(USER_WITHOUT_ROLE, new Header[0]);
        response = client.get("/some-index/_search", new Header[0]);
        log.info("Search response after config restore '{}'", (Object)response.getBody());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
    }
}

