/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.plugins.Plugin;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class LeakDetectorTest {
    @Test
    public void testLeakDetected() {
        LocalCluster.Embedded localCluster = new LocalCluster.Builder().singleNode().sslEnabled().embedded().plugin(MemoryLeakPlugin.class).build();
        try {
            localCluster.before();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to start test cluster", e);
        }
        ClusterHealthResponse healthResponse = (ClusterHealthResponse)localCluster.getInternalNodeClient().admin().cluster().prepareHealth(TimeValue.timeValueSeconds((long)10L), new String[0]).setWaitForStatus(ClusterHealthStatus.GREEN).setIndices(new String[]{"test-index"}).setTimeout(TimeValue.timeValueSeconds((long)10L)).execute().actionGet();
        MatcherAssert.assertThat((Object)healthResponse.isTimedOut(), (Matcher)Matchers.is((Object)false));
        try {
            localCluster.close();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                MatcherAssert.assertThat((Object)runtimeException.getMessage(), (Matcher)Matchers.containsString((String)"List of logged leaks is not empty"));
            }
            MatcherAssert.assertThat((String)"Expected exception not thrown", (boolean)false);
        }
    }

    public static class MemoryLeakPlugin
    extends Plugin {
        public Collection<?> createComponents(final Plugin.PluginServices services) {
            final Client client = services.client();
            ClusterStateListener listener = new ClusterStateListener(){

                public void clusterChanged(ClusterChangedEvent event) {
                    if (!event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                        services.clusterService().removeListener((ClusterStateListener)this);
                        services.threadPool().generic().submit(() -> {
                            client.admin().indices().create(new CreateIndexRequest("test-index").settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0)));
                            client.index((IndexRequest)new IndexRequest("test-index").source(Map.of("a", "a")).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
                            for (int i = 0; i < 1000; ++i) {
                                client.search(new SearchRequest(new String[]{"test-index"})).actionGet();
                            }
                        });
                    }
                }
            };
            services.clusterService().addListener(listener);
            return Collections.emptyList();
        }
    }
}

