/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.blocking;

import com.floragunn.searchguard.authc.blocking.IpRangeVerdictBasedBlockRegistry;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IncompatibleAddressException;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class IpRangeVerdictBasedBlockRegistryTest {
    @Test
    public void when_singe_ip_is_allowed_block_others() throws AddressStringException, IncompatibleAddressException {
        HashSet<IPAddress> allows = new HashSet<IPAddress>();
        HashSet disallows = new HashSet();
        allows.add(new IPAddressString("127.0.0.1").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.1").toAddress()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1.2.3.4").toAddress()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void when_singe_ip_is_blocked_allow_others() throws AddressStringException, IncompatibleAddressException {
        HashSet allows = new HashSet();
        HashSet<IPAddress> disallows = new HashSet<IPAddress>();
        disallows.add(new IPAddressString("127.0.0.1").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.1").toAddress()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1.2.3.4").toAddress()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void when_singe_ip_is_blocked_in_range_allow_others() throws AddressStringException, IncompatibleAddressException {
        HashSet allows = new HashSet();
        HashSet<IPAddress> disallows = new HashSet<IPAddress>();
        disallows.add(new IPAddressString("127.0.0.0/8").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.1").toAddress()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1.2.3.4").toAddress()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void when_ip_range_is_allowed_block_others() throws AddressStringException, IncompatibleAddressException {
        HashSet<IPAddress> allows = new HashSet<IPAddress>();
        HashSet disallows = new HashSet();
        allows.add(new IPAddressString("127.0.0.0/8").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.1").toAddress()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.2").toAddress()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1.2.3.4").toAddress()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void when_ip_v6_range_is_allowed_block_others() throws AddressStringException, IncompatibleAddressException {
        HashSet<IPAddress> allows = new HashSet<IPAddress>();
        HashSet disallows = new HashSet();
        allows.add(new IPAddressString("1::/64").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1::1").toAddress()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("1::2").toAddress()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("2::1").toAddress()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void when_ip_is_allowed_and_blocked_then_block() throws AddressStringException, IncompatibleAddressException {
        HashSet<IPAddress> allows = new HashSet<IPAddress>();
        HashSet<IPAddress> disallows = new HashSet<IPAddress>();
        allows.add(new IPAddressString("127.0.0.0/8").toAddress());
        allows.add(new IPAddressString("10.10.20.0/30").toAddress());
        disallows.add(new IPAddressString("127.0.0.0/8").toAddress());
        IpRangeVerdictBasedBlockRegistry registry = new IpRangeVerdictBasedBlockRegistry(allows, disallows);
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("127.0.0.1").toAddress()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)registry.isBlocked((Object)new IPAddressString("10.10.20.3").toAddress()), (Matcher)Is.is((Object)false));
    }
}

