/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.indices.ShrinkResponse;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.searchsupport.junit.matcher.ExceptionsMatchers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class MiscAuthorizationIntTests {
    private static TestSgConfig.User RESIZE_USER_WITHOUT_CREATE_INDEX_PRIV = new TestSgConfig.User("resize_user_without_create_index_priv").roles(new TestSgConfig.Role("resize_role").clusterPermissions("*").indexPermissions("indices:admin/resize", "indices:monitor/stats").on("resize_test_source"));
    private static TestSgConfig.User RESIZE_USER = new TestSgConfig.User("resize_user").roles(new TestSgConfig.Role("resize_role").clusterPermissions("*").indexPermissions("indices:admin/resize", "indices:monitor/stats").on("resize_test_source").indexPermissions("SGS_CREATE_INDEX").on("resize_test_target"));
    private static TestSgConfig.User SEARCH_TEMPLATE_USER = new TestSgConfig.User("search_template_user").roles(new TestSgConfig.Role("search_template_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_SEARCH_TEMPLATES").indexPermissions("SGS_READ").on("resolve_test_*"));
    private static TestSgConfig.User SEARCH_NO_TEMPLATE_USER = new TestSgConfig.User("search_no_template_user").roles(new TestSgConfig.Role("search_no_template_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_READ").on("resolve_test_*"));
    private static TestSgConfig.User NEG_LOOKAHEAD_USER = new TestSgConfig.User("neg_lookahead_user").roles(new TestSgConfig.Role("neg_lookahead_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_READ").on("/^(?!t.*).*/"));
    private static TestSgConfig.User REGEX_USER = new TestSgConfig.User("regex_user").roles(new TestSgConfig.Role("regex_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_READ").on("/[^a-z].*/"));
    private static TestSgConfig.User SEARCH_TEMPLATE_LEGACY_USER = new TestSgConfig.User("search_template_legacy_user").roles(new TestSgConfig.Role("search_template_legacy_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_READ").on("resolve_test_*").indexPermissions("indices:data/read/search/template").on("*"));
    private static TestSgConfig.User HIDDEN_TEST_USER = new TestSgConfig.User("hidden_test_user").roles(new TestSgConfig.Role("hidden_test_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("*").on("hidden_test_not_hidden"));
    private static TestCertificates certificatesContext = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addNodes("CN=node-0.example.com,OU=SearchGuard,O=SearchGuard").addClients("CN=client-0.example.com,OU=SearchGuard,O=SearchGuard").addAdminClients("CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard").build();
    @ClassRule
    public static LocalCluster.Embedded anotherCluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).user("resolve_test_user", "secret", new TestSgConfig.Role("resolve_test_user_role").indexPermissions("*").on("resolve_test_allow_*")).embedded().build();
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).remote("my_remote", anotherCluster).user("resolve_test_user", "secret", new TestSgConfig.Role("resolve_test_user_role").indexPermissions("*").on("resolve_test_allow_*").indexPermissions("*").on("/alias_resolve_test_index_allow_.*/")).user("admin", "admin", new TestSgConfig.Role("admin_role").clusterPermissions("*")).user("permssion_rest_api_user", "secret", new TestSgConfig.Role("permssion_rest_api_user_role").clusterPermissions("indices:data/read/mtv")).user("limited_test_user_basic", "secret", new TestSgConfig.Role("role").clusterPermissions("*").indexPermissions("*").on("exclude_test_*")).users(SEARCH_TEMPLATE_USER, SEARCH_NO_TEMPLATE_USER, SEARCH_TEMPLATE_LEGACY_USER).embedded().build();
    @ClassRule
    public static LocalCluster.Embedded clusterFof = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).remote("my_remote", anotherCluster).ignoreUnauthorizedIndices(false).user("resolve_test_user", "secret", new TestSgConfig.Role("resolve_test_user_role").indexPermissions("*").on("resolve_test_allow_*").indexPermissions("*").on("/alias_resolve_test_index_allow_.*/")).users(RESIZE_USER, RESIZE_USER_WITHOUT_CREATE_INDEX_PRIV, NEG_LOOKAHEAD_USER, REGEX_USER, HIDDEN_TEST_USER).embedded().build();

    @BeforeClass
    public static void setupTestData() {
        Client client = cluster.getInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest("resolve_test_allow_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_allow_1", "b", "y", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("resolve_test_allow_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_allow_2", "b", "yy", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("resolve_test_disallow_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_disallow_1", "b", "yy", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("resolve_test_disallow_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_disallow_2", "b", "yy", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("alias_resolve_test_index_allow_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "alias_resolve_test_index_allow_1", "b", "y", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("alias_resolve_test_index_allow_aliased_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "alias_resolve_test_index_allow_aliased_1", "b", "y", "date", "1985/01/01"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("alias_resolve_test_index_allow_aliased_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "alias_resolve_test_index_allow_aliased_2", "b", "y", "date", "1985/01/01"})).actionGet();
        client.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias_resolve_test_alias_1").index("alias_resolve_test_*"))).actionGet();
        Client clientFof = clusterFof.getInternalNodeClient();
        clientFof.index(((IndexRequest)new IndexRequest("resolve_test_allow_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_allow_1", "b", "y", "date", "1985/01/01"})).actionGet();
        clientFof.index(((IndexRequest)new IndexRequest("resolve_test_allow_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_allow_2", "b", "yy", "date", "1985/01/01"})).actionGet();
        clientFof.index(((IndexRequest)new IndexRequest("resolve_test_disallow_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_disallow_1", "b", "yy", "date", "1985/01/01"})).actionGet();
        clientFof.index(((IndexRequest)new IndexRequest("resolve_test_disallow_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "resolve_test_disallow_2", "b", "yy", "date", "1985/01/01"})).actionGet();
        clientFof.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).alias("resolve_test_allow_alias").indices(new String[]{"resolve_test_*"}))).actionGet();
        clientFof.index(((IndexRequest)new IndexRequest("hidden_test_not_hidden").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "hidden_test_not_hidden", "b", "y", "date", "1985/01/01"})).actionGet();
        clientFof.admin().indices().create(new CreateIndexRequest(".hidden_test_actually_hidden").settings((Map)ImmutableMap.of((Object)"index.hidden", (Object)true))).actionGet();
        clientFof.index((IndexRequest)new IndexRequest(".hidden_test_actually_hidden").id("test").source(new Object[]{"a", "b"}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        Client anotherClient = anotherCluster.getInternalNodeClient();
        anotherClient.index(((IndexRequest)new IndexRequest("resolve_test_allow_remote_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y", "date", "1985/01/01"})).actionGet();
        anotherClient.index(((IndexRequest)new IndexRequest("resolve_test_allow_remote_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy", "date", "1985/01/01"})).actionGet();
        anotherClient.index(((IndexRequest)new IndexRequest("resolve_test_disallow_remote_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy", "date", "1985/01/01"})).actionGet();
        anotherClient.index(((IndexRequest)new IndexRequest("resolve_test_disallow_remote_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy", "date", "1985/01/01"})).actionGet();
    }

    @Test
    public void detailsAboutMissingPermissions_shouldBeReturnedOnlyWhenAuthzDebugIsEnabled() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();
             GenericRestClient userClient = cluster.getRestClient("limited_test_user_basic", "secret", new Header[0]);){
            GenericRestClient.HttpResponse finalResponse = cluster.callAndRestoreConfig(CType.AUTHZ, () -> {
                GenericRestClient.HttpResponse httpResponse = adminCertClient.putJson("/_searchguard/config/authz", (Document<?>)DocNode.of((String)"debug", (Object)true));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
                httpResponse = userClient.get("alias_resolve_test_alias_1", new Header[0]);
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
                MatcherAssert.assertThat((String)httpResponse.getBody(), (Object)httpResponse.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"error", (String)"missing_permissions"));
                httpResponse = adminCertClient.putJson("/_searchguard/config/authz", (Document<?>)DocNode.EMPTY);
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
                return userClient.get("alias_resolve_test_alias_1", new Header[0]);
            });
            MatcherAssert.assertThat((Object)finalResponse, RestMatchers.isForbidden());
            MatcherAssert.assertThat((String)finalResponse.getBody(), (Object)finalResponse.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"error", (String)"missing_permissions")));
        }
    }

    @Test
    public void resolveTestRemote() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("resolve_test_user", "secret", new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/my_remote:resolve_test_*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("indices[*].name", Matchers.contains((Object[])new String[]{"my_remote:resolve_test_allow_remote_1", "my_remote:resolve_test_allow_remote_2"}))}));
        }
    }

    @Test
    public void resolveTestLocalRemoteMixed() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("resolve_test_user", "secret", new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/resolve_test_*,my_remote:resolve_test_*_remote_*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("indices[*].name", Matchers.contains((Object[])new String[]{"resolve_test_allow_1", "resolve_test_allow_2", "my_remote:resolve_test_allow_remote_1", "my_remote:resolve_test_allow_remote_2"}))}));
        }
    }

    @Test
    public void readAliasAndIndexMixed() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("resolve_test_user", "secret", new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/alias_resolve_test_*/_search", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("hits.hits[*]._source.index", Matchers.containsInAnyOrder((Object[])new String[]{"alias_resolve_test_index_allow_aliased_1", "alias_resolve_test_index_allow_aliased_2", "alias_resolve_test_index_allow_1"}))}));
        }
    }

    @Test
    public void permissionApi_evaluateClusterAndTenantPrivileges() throws Exception {
        try (GenericRestClient adminRestClient = cluster.getRestClient("admin", "admin", new Header[0]);
             GenericRestClient permissionRestClient = cluster.getRestClient("permssion_rest_api_user", "secret", new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = adminRestClient.get("/_searchguard/permission?permissions=indices:data/read/mtv,indices:data/read/viva", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("permissions['indices:data/read/mtv']", Matchers.equalTo((Object)true))}));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("permissions['indices:data/read/viva']", Matchers.equalTo((Object)true))}));
            httpResponse = permissionRestClient.get("/_searchguard/permission?permissions=indices:data/read/mtv,indices:data/read/viva", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("permissions['indices:data/read/mtv']", Matchers.equalTo((Object)true))}));
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("permissions['indices:data/read/viva']", Matchers.equalTo((Object)false))}));
        }
    }

    @Test
    public void testResizeAction() throws Exception {
        String sourceIndex = "resize_test_source";
        String targetIndex = "resize_test_target";
        Client clientFof = clusterFof.getInternalNodeClient();
        clientFof.admin().indices().create(new CreateIndexRequest(sourceIndex).settings(Settings.builder().put("index.number_of_shards", 5).build())).actionGet();
        clientFof.index(((IndexRequest)new IndexRequest(sourceIndex).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"index", "a", "b", "y", "date", "1985/01/01"})).actionGet();
        clientFof.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{sourceIndex}).settings(Settings.builder().put("index.blocks.write", true).build())).actionGet();
        Thread.sleep(300L);
        try (RestHighLevelClient client = clusterFof.getRestHighLevelClient(RESIZE_USER_WITHOUT_CREATE_INDEX_PRIV);){
            ThrowableAssert.assertThatThrown(() -> client.getJavaClient().indices().shrink(r -> r.index("whatever").target(targetIndex)), (Matcher[])new Matcher[]{Matchers.instanceOf(ElasticsearchException.class), ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
        }
        client = clusterFof.getRestHighLevelClient(RESIZE_USER_WITHOUT_CREATE_INDEX_PRIV);
        try {
            ThrowableAssert.assertThatThrown(() -> client.getJavaClient().indices().shrink(r -> r.index(sourceIndex).target(targetIndex)), (Matcher[])new Matcher[]{Matchers.instanceOf(ElasticsearchException.class), ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = clusterFof.getRestHighLevelClient(RESIZE_USER);
        try {
            ThrowableAssert.assertThatThrown(() -> client.getJavaClient().indices().shrink(r -> r.index("whatever").target(targetIndex)), (Matcher[])new Matcher[]{Matchers.instanceOf(ElasticsearchException.class), ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = clusterFof.getRestHighLevelClient(RESIZE_USER);
        try {
            ShrinkResponse shrinkResponse = client.getJavaClient().indices().shrink(r -> r.index(sourceIndex).target(targetIndex));
            MatcherAssert.assertThat((String)shrinkResponse.toString(), (Object)shrinkResponse.acknowledged(), (Matcher)Matchers.is((Object)true));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        clientFof = clusterFof.getInternalNodeClient();
        boolean exists = ((GetIndexResponse)clientFof.admin().indices().getIndex((GetIndexRequest)new GetIndexRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{targetIndex})).actionGet()).indices().length > 0;
        MatcherAssert.assertThat((Object)exists, (Matcher)Matchers.is((Object)true));
    }
}

