/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.patch.MergePatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.variables.ConfigVarRefreshAction;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.NestedValueMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.hamcrest.BaseMatcher;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TestSgConfig {
    private static final Logger log = LogManager.getLogger(TestSgConfig.class);
    private String resourceFolder = null;
    private NestedValueMap overrideSgConfigSettings;
    private NestedValueMap overrideUserSettings;
    private NestedValueMap overrideRoleSettings;
    private NestedValueMap overrideRoleMappingSettings;
    private NestedValueMap overrideFrontendConfigSettings;
    private NestedValueMap overrideFrontendMultiTenancyConfigSettings;
    private NestedValueMap overrideTenantSettings;
    private Authc authc;
    private DlsFls dlsFls;
    private Authz privileges;
    private Sessions sessions;
    private AuthTokenService authTokenService;
    private String indexName = ".searchguard";
    private Map<String, Supplier<Object>> variableSuppliers = new HashMap<String, Supplier<Object>>();

    public TestSgConfig configIndexName(String configIndexName) {
        this.indexName = configIndexName;
        return this;
    }

    public TestSgConfig resources(String resourceFolder) {
        this.resourceFolder = resourceFolder;
        return this;
    }

    public TestSgConfig var(String name, Supplier<Object> variableSupplier) {
        this.variableSuppliers.put(name, variableSupplier);
        return this;
    }

    public TestSgConfig sgConfigSettings(String keyPath, Object value, Object ... more) {
        if (this.overrideSgConfigSettings == null) {
            this.overrideSgConfigSettings = new NestedValueMap();
        }
        this.overrideSgConfigSettings.put(NestedValueMap.Path.parse(keyPath), value);
        for (int i = 0; i < more.length - 1; i += 2) {
            this.overrideSgConfigSettings.put(NestedValueMap.Path.parse(String.valueOf(more[i])), more[i + 1]);
        }
        return this;
    }

    public TestSgConfig xff(String proxies) {
        if (this.overrideSgConfigSettings == null) {
            this.overrideSgConfigSettings = new NestedValueMap();
        }
        this.overrideSgConfigSettings.put(new NestedValueMap.Path("sg_config", "dynamic", "http", "xff"), (Object)NestedValueMap.of("enabled", (Object)true, "internalProxies", (Object)proxies));
        return this;
    }

    public TestSgConfig authc(Authc authc) {
        this.authc = authc;
        return this;
    }

    public TestSgConfig dlsFls(DlsFls dlsFls) {
        this.dlsFls = dlsFls;
        return this;
    }

    public TestSgConfig frontendAuthc(FrontendAuthc ... frontendAuthcz) {
        return this.frontendAuthc("default", frontendAuthcz);
    }

    public TestSgConfig frontendAuthc(String configId, FrontendAuthc ... frontendAuthc) {
        if (this.overrideFrontendConfigSettings == null) {
            this.overrideFrontendConfigSettings = new NestedValueMap();
        }
        NestedValueMap mergedConfigs = new NestedValueMap();
        for (FrontendAuthc authc : frontendAuthc) {
            mergedConfigs.putAll(NestedValueMap.copy(authc.toMap()));
        }
        this.overrideFrontendConfigSettings.put(configId, mergedConfigs);
        return this;
    }

    public TestSgConfig frontendMultiTenancy(FrontendMultiTenancy frontendMultiTenancy) {
        if (this.overrideFrontendMultiTenancyConfigSettings == null) {
            this.overrideFrontendMultiTenancyConfigSettings = new NestedValueMap();
        }
        this.overrideFrontendMultiTenancyConfigSettings.putAllFromAnyMap(frontendMultiTenancy.toJsonMap());
        return this;
    }

    public TestSgConfig tenants(Tenant ... tenants) {
        if (this.overrideTenantSettings == null) {
            this.overrideTenantSettings = new NestedValueMap();
        }
        for (Tenant tenant : tenants) {
            this.overrideTenantSettings.putAllFromAnyMap(tenant.toJsonMap());
        }
        return this;
    }

    public TestSgConfig frontendAuthcDebug(boolean debug) {
        return this.frontendAuthcDebug("default", debug);
    }

    public TestSgConfig frontendAuthcDebug(String configId, boolean debug) {
        if (this.overrideFrontendConfigSettings == null) {
            this.overrideFrontendConfigSettings = new NestedValueMap();
        }
        this.overrideFrontendConfigSettings.put(new NestedValueMap.Path(configId, "debug"), (Object)debug);
        return this;
    }

    public TestSgConfig user(User user) {
        if (user.roleNames != null) {
            return this.user(user.name, user.password, user.attributes, user.roleNames);
        }
        return this.user(user.name, user.password, user.attributes, user.roles);
    }

    public TestSgConfig user(String name, UserPassword password, String ... sgRoles) {
        return this.user(name, password, (Map<String, Object>)null, sgRoles);
    }

    public TestSgConfig user(String name, UserPassword password, Map<String, Object> attributes, String ... sgRoles) {
        if (this.overrideUserSettings == null) {
            this.overrideUserSettings = new NestedValueMap();
        }
        this.overrideUserSettings.put(new NestedValueMap.Path(name, "hash"), (Object)password.passwordValueForConfiguration());
        if (sgRoles != null && sgRoles.length > 0) {
            this.overrideUserSettings.put(new NestedValueMap.Path(name, "search_guard_roles"), (Object)sgRoles);
        }
        if (attributes != null && attributes.size() != 0) {
            for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                this.overrideUserSettings.put(new NestedValueMap.Path(name, "attributes", attr.getKey()), attr.getValue());
            }
        }
        return this;
    }

    public TestSgConfig user(String name, UserPassword password, Role ... sgRoles) {
        return this.user(name, password, (Map<String, Object>)null, sgRoles);
    }

    public TestSgConfig user(String name, UserPassword password, Map<String, Object> attributes, Role ... sgRoles) {
        if (this.overrideUserSettings == null) {
            this.overrideUserSettings = new NestedValueMap();
        }
        this.overrideUserSettings.put(new NestedValueMap.Path(name, "hash"), (Object)password.passwordValueForConfiguration());
        if (sgRoles != null && sgRoles.length > 0) {
            String roleNamePrefix = "user_" + name + "__";
            this.overrideUserSettings.put(new NestedValueMap.Path(name, "search_guard_roles"), (Object)Arrays.asList(sgRoles).stream().map(r -> roleNamePrefix + r.name).collect(Collectors.toList()));
            this.roles(roleNamePrefix, sgRoles);
        }
        if (attributes != null && attributes.size() != 0) {
            for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                this.overrideUserSettings.put(new NestedValueMap.Path(name, "attributes", attr.getKey()), attr.getValue());
            }
        }
        return this;
    }

    public TestSgConfig roles(Role ... roles) {
        return this.roles("", roles);
    }

    public TestSgConfig roles(String roleNamePrefix, Role ... roles) {
        if (this.overrideRoleSettings == null) {
            this.overrideRoleSettings = new NestedValueMap();
        }
        for (Role role : roles) {
            this.overrideRoleSettings.putAllFromAnyMap(role.toJsonMap(roleNamePrefix));
        }
        return this;
    }

    public TestSgConfig roleMapping(RoleMapping ... roleMappings) {
        if (this.overrideRoleMappingSettings == null) {
            this.overrideRoleMappingSettings = new NestedValueMap();
        }
        for (RoleMapping roleMapping : roleMappings) {
            this.overrideRoleMappingSettings.putAllFromAnyMap(roleMapping.toJsonMap());
        }
        return this;
    }

    public TestSgConfig roleToRoleMapping(Role role, String ... backendRoles) {
        return this.roleMapping(new RoleMapping(role.name).backendRoles(backendRoles));
    }

    public TestSgConfig authFailureListener(AuthFailureListener authFailureListener) {
        if (this.overrideSgConfigSettings == null) {
            this.overrideSgConfigSettings = new NestedValueMap();
        }
        this.overrideSgConfigSettings.put(new NestedValueMap.Path("sg_config", "dynamic", "auth_failure_listeners"), (Object)authFailureListener.toMap());
        return this;
    }

    public TestSgConfig ignoreUnauthorizedIndices(boolean ignoreUnauthorizedIndices) {
        if (this.privileges == null) {
            this.privileges = new Authz();
        }
        this.privileges.ignoreUnauthorizedIndices(ignoreUnauthorizedIndices);
        return this;
    }

    public TestSgConfig authzDebug(boolean debug) {
        if (this.privileges == null) {
            this.privileges = new Authz();
        }
        this.privileges.debug(debug);
        return this;
    }

    public TestSgConfig sessions(Sessions sessions) {
        this.sessions = sessions;
        return this;
    }

    public TestSgConfig authTokenService(AuthTokenService authTokenService) {
        this.authTokenService = authTokenService;
        return this;
    }

    public TestSgConfig clone() {
        TestSgConfig result = new TestSgConfig();
        result.resourceFolder = this.resourceFolder;
        result.indexName = this.indexName;
        result.overrideRoleSettings = this.overrideRoleSettings != null ? this.overrideRoleSettings.clone() : null;
        result.overrideSgConfigSettings = this.overrideSgConfigSettings != null ? this.overrideSgConfigSettings.clone() : null;
        result.overrideUserSettings = this.overrideUserSettings != null ? this.overrideUserSettings.clone() : null;
        result.overrideRoleMappingSettings = this.overrideRoleMappingSettings != null ? this.overrideRoleMappingSettings.clone() : null;
        result.overrideFrontendConfigSettings = this.overrideFrontendConfigSettings != null ? this.overrideFrontendConfigSettings.clone() : null;
        result.overrideFrontendMultiTenancyConfigSettings = this.overrideFrontendMultiTenancyConfigSettings != null ? this.overrideFrontendMultiTenancyConfigSettings.clone() : null;
        result.overrideTenantSettings = this.overrideTenantSettings != null ? this.overrideTenantSettings.clone() : null;
        return result;
    }

    public void initIndex(Client client) {
        ConfigUpdateResponse configUpdateResponse;
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        if (this.indexName.startsWith(".")) {
            settings.put("index.hidden", true);
        }
        client.admin().indices().create(new CreateIndexRequest(this.indexName).settings(settings)).actionGet();
        this.writeOptionalConfigToIndex(client, CType.CONFIG, "sg_config.yml", this.overrideSgConfigSettings);
        this.writeOptionalConfigToIndex(client, CType.ROLES, "sg_roles.yml", this.overrideRoleSettings);
        this.writeOptionalConfigToIndex(client, CType.INTERNALUSERS, "sg_internal_users.yml", this.overrideUserSettings);
        this.writeOptionalConfigToIndex(client, CType.ROLESMAPPING, "sg_roles_mapping.yml", this.overrideRoleMappingSettings);
        this.writeConfigToIndex(client, CType.ACTIONGROUPS, "sg_action_groups.yml");
        this.writeOptionalConfigToIndex(client, CType.TENANTS, "sg_tenants.yml", this.overrideTenantSettings);
        this.writeOptionalConfigToIndex(client, CType.BLOCKS, "sg_blocks.yml", null);
        this.writeOptionalConfigToIndex(client, CType.FRONTEND_AUTHC, "sg_frontend_authc.yml", this.overrideFrontendConfigSettings);
        this.writeOptionalConfigToIndex(client, "frontend_multi_tenancy", "sg_frontend_multi_tenancy.yml", this.overrideFrontendMultiTenancyConfigSettings);
        if (this.authc != null) {
            this.writeConfigToIndex(client, CType.AUTHC, this.authc);
        } else {
            this.writeOptionalConfigToIndex(client, CType.AUTHC, "sg_authc.yml", null);
        }
        if (this.privileges != null) {
            this.writeConfigToIndex(client, CType.AUTHZ, this.privileges);
        } else {
            this.writeOptionalConfigToIndex(client, CType.AUTHZ, "sg_privileges.yml", null);
        }
        if (this.sessions != null) {
            this.writeConfigToIndex(client, "sessions", this.sessions);
        }
        if (this.dlsFls != null) {
            this.writeConfigToIndex(client, "authz_dlsfls", this.dlsFls);
        }
        if (this.authTokenService != null) {
            this.writeConfigToIndex(client, "auth_token_service", this.authTokenService);
        }
        if (this.variableSuppliers.size() != 0) {
            this.writeConfigVars(client, this.variableSuppliers);
        }
        if ((configUpdateResponse = (ConfigUpdateResponse)client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]))).actionGet()).hasFailures()) {
            throw new RuntimeException("ConfigUpdateResponse produced failures: " + String.valueOf(configUpdateResponse.failures()));
        }
    }

    public void initByConfigRestApi(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response;
        DocNode request = DocNode.EMPTY;
        request = request.with((Document)this.getConfigDocNode(CType.CONFIG, "sg_config.yml", this.overrideSgConfigSettings));
        request = request.with((Document)this.getConfigDocNode(CType.ROLES, "sg_roles.yml", this.overrideRoleSettings));
        request = request.with((Document)this.getConfigDocNode(CType.INTERNALUSERS, "sg_internal_users.yml", this.overrideUserSettings));
        request = request.with((Document)this.getConfigDocNode(CType.ROLESMAPPING, "sg_roles_mapping.yml", this.overrideRoleMappingSettings));
        request = request.with((Document)this.getConfigDocNode(CType.ACTIONGROUPS, "sg_action_groups.yml", null));
        request = request.with((Document)this.getConfigDocNode(CType.TENANTS, "sg_tenants.yml", null));
        request = request.with((Document)this.getConfigDocNode(CType.BLOCKS, "sg_blocks.yml", null));
        request = request.with((Document)this.getConfigDocNode(CType.FRONTEND_AUTHC, "sg_frontend_authc.yml", this.overrideFrontendConfigSettings));
        request = request.with((Document)ConfigDocument.bulkUpdateMap(this.authc != null ? this.authc : Authc.DEFAULT, this.privileges, this.sessions, this.dlsFls, this.authTokenService));
        if (this.variableSuppliers.size() != 0) {
            HashMap<String, DocNode> values = new HashMap<String, DocNode>();
            for (Map.Entry<String, Supplier<Object>> entry : this.variableSuppliers.entrySet()) {
                values.put(entry.getKey(), DocNode.of((String)"value", (Object)entry.getValue().get()));
            }
            request = request.with("config_vars", (Object)DocNode.of((String)"content", values));
        }
        if ((response = client.putJson("/_searchguard/config", (Document<?>)request)).getStatusCode() != 200) {
            throw new RuntimeException("Config update failed: " + String.valueOf(response) + " (using " + String.valueOf(client.getUser()) + ")");
        }
    }

    private void writeConfigToIndex(Client client, CType<?> configType, String file) {
        this.writeConfigToIndex(client, configType, file, null);
    }

    private void writeConfigToIndex(Client client, CType<?> configType, String file, NestedValueMap overrides) {
        try {
            NestedValueMap config = this.resourceFolder != null ? NestedValueMap.fromYaml(this.openFile(file)) : NestedValueMap.of(new NestedValueMap.Path("_sg_meta", "type"), (Object)configType.toLCString(), new NestedValueMap.Path("_sg_meta", "config_version"), (Object)2);
            if (overrides != null) {
                config.overrideLeafs(overrides);
            }
            log.debug("Writing " + String.valueOf(configType) + ":\n" + config.toYamlString());
            client.index(((IndexRequest)new IndexRequest(this.indexName).id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType.toLCString(), BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(config.toJsonString().getBytes("utf-8")))})).actionGet();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private void writeOptionalConfigToIndex(Client client, CType<?> configType, String file, NestedValueMap overrides) {
        try {
            DocNode config = this.getMergedConfig(configType, file, overrides);
            log.debug("Writing SearchGuard configuration of type " + String.valueOf(configType) + " to index:\n" + config.toYamlString());
            client.index(((IndexRequest)new IndexRequest(this.indexName).id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType.toLCString(), BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(config.toJsonString().getBytes("utf-8")))})).actionGet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private DocNode getMergedConfig(CType<?> configType, String file, NestedValueMap overrides) {
        try {
            DocNode config = null;
            if (this.resourceFolder != null) {
                try {
                    config = DocNode.parse((Format)Format.YAML).from(this.openFile(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (config == null) {
                config = DocNode.EMPTY;
            }
            if (overrides != null) {
                config = new MergePatch(DocNode.wrap((Object)overrides)).apply(config);
            }
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private DocNode getConfigDocNode(CType<?> configType, String file, NestedValueMap overrides) {
        return DocNode.of((String)configType.getName(), (Object)DocNode.of((String)"content", (Object)this.getMergedConfig(configType, file, overrides)));
    }

    private void writeOptionalConfigToIndex(Client client, String configType, String file, NestedValueMap overrides) {
        try {
            NestedValueMap config = null;
            if (this.resourceFolder != null) {
                try {
                    config = NestedValueMap.fromYaml(this.openFile(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (config == null) {
                config = NestedValueMap.of(new NestedValueMap.Path("_sg_meta", "type"), (Object)configType, new NestedValueMap.Path("_sg_meta", "config_version"), (Object)2);
            }
            if (overrides != null) {
                config.overrideLeafs(overrides);
            }
            log.info("Writing " + configType + ":\n" + config.toYamlString());
            client.index(((IndexRequest)new IndexRequest(this.indexName).id(configType).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType, BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(config.toJsonString().getBytes("utf-8")))})).actionGet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private void writeConfigToIndex(Client client, CType<?> configType, Document<?> document) {
        try {
            log.info("Writing " + String.valueOf(configType) + ":\n" + document.toYamlString());
            client.index(((IndexRequest)new IndexRequest(this.indexName).id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType.toLCString(), BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(DocNode.of((String)"default", document).toJsonString().getBytes("utf-8")))})).actionGet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private void writeConfigToIndex(Client client, String configType, Document<?> document) {
        try {
            log.info("Writing " + configType + ":\n" + document.toYamlString());
            client.index(((IndexRequest)new IndexRequest(this.indexName).id(configType).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType, BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(DocNode.of((String)"default", document).toJsonString().getBytes("utf-8")))})).actionGet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while initializing config for " + this.indexName, e);
        }
    }

    private void writeConfigVars(Client client, Map<String, Supplier<Object>> configVars) {
        BulkRequest bulkRequest = new BulkRequest(".searchguard_config_vars").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map.Entry<String, Supplier<Object>> entry : configVars.entrySet()) {
            bulkRequest.add(new IndexRequest(".searchguard_config_vars").id(entry.getKey()).source(new Object[]{"value", entry.getValue().get(), "updated", Instant.now()}));
        }
        client.bulk(bulkRequest).actionGet();
        ConfigVarRefreshAction.send((Client)client, (ActionListener)new ActionListener<ConfigVarRefreshAction.Response>(){

            public void onResponse(ConfigVarRefreshAction.Response response) {
            }

            public void onFailure(Exception e) {
                log.error("Error while refreshing secrets");
            }
        });
    }

    private InputStream openFile(String file) throws IOException {
        String path = this.resourceFolder == null || this.resourceFolder.length() == 0 || this.resourceFolder.equals("/") ? "/" + file : "/" + this.resourceFolder + "/" + file;
        InputStream is = FileHelper.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Could not find resource in class path: " + path);
        }
        return is;
    }

    public static NestedValueMap fromYaml(String yamlString) {
        try {
            return NestedValueMap.fromYaml(yamlString);
        }
        catch (DocumentParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])Objects.requireNonNull(clearTextPassword), (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    public static class Authc
    extends ConfigDocument<Authc> {
        public static final Authc DEFAULT = new Authc(new Domain("basic/internal_users_db"));
        private List<Domain> domains;
        private List<String> trustedProxies;
        private boolean debug;
        private boolean userCacheEnabled = true;

        public Authc(Domain ... domains) {
            this.domains = ImmutableList.ofArray((Object[])domains);
        }

        public Authc trustedProxies(String ... trustedProxies) {
            this.trustedProxies = Arrays.asList(trustedProxies);
            return this;
        }

        public Authc debug() {
            this.debug = true;
            return this;
        }

        public Authc userCacheEnabled(boolean userCacheEnabled) {
            this.userCacheEnabled = userCacheEnabled;
            return this;
        }

        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("auth_domains", this.domains);
            if (this.trustedProxies != null) {
                result.put("network", ImmutableMap.of((Object)"trusted_proxies", this.trustedProxies));
            }
            result.put("debug", this.debug);
            if (!this.userCacheEnabled) {
                result.put("user_cache", ImmutableMap.of((Object)"enabled", (Object)false));
            }
            return ImmutableMap.of(result);
        }

        @Override
        public String configType() {
            return "authc";
        }

        public static class Domain
        implements Document<Domain> {
            private final String type;
            private String id;
            private String description;
            private List<String> acceptIps = null;
            private List<String> acceptOriginatingIps = null;
            private List<String> skipIps = null;
            private List<String> skipOriginatingIps = null;
            private List<String> acceptUsers = null;
            private List<String> skipUsers = null;
            private List<AdditionalUserInformation> additionalUserInformation = null;
            private UserMapping userMapping;
            private DocNode backendConfig;
            private DocNode frontendConfig;
            private JwtDomain jwt;

            public Domain jwt(JwtDomain jwt) {
                this.jwt = jwt;
                return this;
            }

            public Domain(String type) {
                this.type = type;
            }

            public Domain id(String id) {
                this.id = id;
                return this;
            }

            public Domain description(String description) {
                this.description = description;
                return this;
            }

            public Domain frontend(DocNode frontendConfig) {
                this.frontendConfig = frontendConfig;
                return this;
            }

            public Domain backend(DocNode backendConfig) {
                this.backendConfig = backendConfig;
                return this;
            }

            public Domain userMapping(UserMapping userMapping) {
                this.userMapping = userMapping;
                return this;
            }

            public Domain additionalUserInformation(AdditionalUserInformation ... additionalUserInformation) {
                if (this.additionalUserInformation == null) {
                    this.additionalUserInformation = new ArrayList<AdditionalUserInformation>(Arrays.asList(additionalUserInformation));
                } else {
                    this.additionalUserInformation.addAll(Arrays.asList(additionalUserInformation));
                }
                return this;
            }

            public Domain acceptIps(String ... ips) {
                if (this.acceptIps == null) {
                    this.acceptIps = new ArrayList<String>(Arrays.asList(ips));
                } else {
                    this.acceptIps.addAll(Arrays.asList(ips));
                }
                return this;
            }

            public Domain acceptOriginatingIps(String ... ips) {
                if (this.acceptOriginatingIps == null) {
                    this.acceptOriginatingIps = new ArrayList<String>(Arrays.asList(ips));
                } else {
                    this.acceptOriginatingIps.addAll(Arrays.asList(ips));
                }
                return this;
            }

            public Domain skipIps(String ... ips) {
                if (this.skipIps == null) {
                    this.skipIps = new ArrayList<String>(Arrays.asList(ips));
                } else {
                    this.skipIps.addAll(Arrays.asList(ips));
                }
                return this;
            }

            public Domain skipOriginatingIps(String ... ips) {
                if (this.skipOriginatingIps == null) {
                    this.skipOriginatingIps = new ArrayList<String>(Arrays.asList(ips));
                } else {
                    this.skipOriginatingIps.addAll(Arrays.asList(ips));
                }
                return this;
            }

            public Domain skipUsers(String ... users) {
                this.skipUsers = Arrays.asList(users);
                return this;
            }

            public Domain acceptUsers(String ... users) {
                this.acceptUsers = Arrays.asList(users);
                return this;
            }

            public Object toBasicObject() {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                result.put("type", this.type);
                if (this.id != null) {
                    result.put("id", this.id);
                }
                if (this.description != null) {
                    result.put("description", this.description);
                }
                if (this.frontendConfig != null) {
                    int slash = this.type.indexOf(47);
                    result.put(this.type.substring(0, slash != -1 ? slash : this.type.length()), this.frontendConfig);
                }
                if (this.backendConfig != null) {
                    result.put(this.type.substring(this.type.indexOf(47) + 1), this.backendConfig);
                }
                if (this.acceptIps != null || this.acceptUsers != null || this.acceptOriginatingIps != null) {
                    result.put("accept", ImmutableMap.ofNonNull((Object)"ips", this.acceptIps, (Object)"users", this.acceptUsers, (Object)"originating_ips", this.acceptOriginatingIps));
                }
                if (this.skipIps != null || this.skipUsers != null || this.skipOriginatingIps != null) {
                    result.put("skip", ImmutableMap.ofNonNull((Object)"ips", this.skipIps, (Object)"users", this.skipUsers, (Object)"originating_ips", this.skipOriginatingIps));
                }
                if (this.additionalUserInformation != null) {
                    result.put("additional_user_information", this.additionalUserInformation);
                }
                if (this.userMapping != null) {
                    result.put("user_mapping", this.userMapping.toBasicObject());
                }
                if (this.jwt != null) {
                    result.put("jwt", this.jwt.toBasicObject());
                }
                return result;
            }

            public static class UserMapping
            implements Document<UserMapping> {
                private List<DocNode> userNameFrom = new ArrayList<DocNode>();
                private List<String> userNameStatic = new ArrayList<String>();
                private List<DocNode> userNameFromBackend = new ArrayList<DocNode>();
                private List<DocNode> rolesFrom = new ArrayList<DocNode>();
                private List<DocNode> rolesFromCommaSeparatedString = new ArrayList<DocNode>();
                private List<String> rolesStatic = new ArrayList<String>();
                private Map<String, String> attrsFrom = new HashMap<String, String>();
                private Map<String, String> attrsStatic = new HashMap<String, String>();

                public UserMapping userNameFrom(String sourcePath) {
                    this.userNameFrom.add(DocNode.wrap((Object)sourcePath));
                    return this;
                }

                public UserMapping userNameFrom(DocNode docNode) {
                    this.userNameFrom.add(docNode);
                    return this;
                }

                public UserMapping userNameStatic(String userName) {
                    this.userNameStatic.add(userName);
                    return this;
                }

                public UserMapping userNameFromBackend(String sourcePath) {
                    this.userNameFromBackend.add(DocNode.wrap((Object)sourcePath));
                    return this;
                }

                public UserMapping userNameFromBackend(DocNode docNode) {
                    this.userNameFromBackend.add(docNode);
                    return this;
                }

                public UserMapping rolesFrom(String sourcePath) {
                    this.rolesFrom.add(DocNode.wrap((Object)sourcePath));
                    return this;
                }

                public UserMapping rolesFromCommaSeparatedString(String sourcePath) {
                    this.rolesFromCommaSeparatedString.add(DocNode.wrap((Object)sourcePath));
                    return this;
                }

                public UserMapping rolesFrom(DocNode docNode) {
                    this.rolesFrom.add(docNode);
                    return this;
                }

                public UserMapping rolesStatic(String ... roles) {
                    this.rolesStatic.addAll(Arrays.asList(roles));
                    return this;
                }

                public UserMapping attrsFrom(String target, String sourcePath) {
                    this.attrsFrom.put(target, sourcePath);
                    return this;
                }

                public UserMapping attrsStatic(String target, String value) {
                    this.attrsStatic.put(target, value);
                    return this;
                }

                public Object toBasicObject() {
                    LinkedHashMap result = new LinkedHashMap();
                    if (this.userNameFrom.size() != 0 || this.userNameStatic.size() != 0 || this.userNameFromBackend.size() != 0) {
                        LinkedHashMap<String, Object> userName = new LinkedHashMap<String, Object>();
                        if (this.userNameFrom.size() == 1) {
                            userName.put("from", this.userNameFrom.get(0));
                        } else if (this.userNameFrom.size() > 1) {
                            userName.put("from", this.userNameFrom);
                        }
                        if (this.userNameStatic.size() == 1) {
                            userName.put("static", this.userNameStatic.get(0));
                        } else if (this.userNameStatic.size() > 1) {
                            userName.put("static", this.userNameStatic);
                        }
                        if (this.userNameFromBackend.size() == 1) {
                            userName.put("from_backend", this.userNameFromBackend.get(0));
                        } else if (this.userNameFromBackend.size() > 1) {
                            userName.put("from_backend", this.userNameFromBackend);
                        }
                        result.put("user_name", userName);
                    }
                    if (this.rolesFrom.size() != 0 || this.rolesStatic.size() != 0 || this.rolesFromCommaSeparatedString.size() != 0) {
                        LinkedHashMap<String, Object> roles = new LinkedHashMap<String, Object>();
                        if (this.rolesFrom.size() == 1) {
                            roles.put("from", this.rolesFrom.get(0));
                        } else if (this.rolesFrom.size() > 1) {
                            roles.put("from", this.rolesFrom);
                        }
                        if (this.rolesFromCommaSeparatedString.size() == 1) {
                            roles.put("from_comma_separated_string", this.rolesFromCommaSeparatedString.get(0));
                        } else if (this.rolesFromCommaSeparatedString.size() > 1) {
                            roles.put("from_comma_separated_string", this.rolesFromCommaSeparatedString);
                        }
                        if (this.rolesStatic.size() == 1) {
                            roles.put("static", this.rolesStatic.get(0));
                        } else if (this.rolesStatic.size() > 1) {
                            roles.put("static", this.rolesStatic);
                        }
                        result.put("roles", roles);
                    }
                    if (this.attrsFrom.size() != 0 || this.attrsStatic.size() != 0) {
                        LinkedHashMap<String, Map<String, String>> attrs = new LinkedHashMap<String, Map<String, String>>();
                        if (this.attrsFrom.size() != 0) {
                            attrs.put("from", this.attrsFrom);
                        }
                        if (this.attrsStatic.size() != 0) {
                            attrs.put("static", this.attrsStatic);
                        }
                        result.put("attrs", attrs);
                    }
                    return result;
                }
            }

            public static class AdditionalUserInformation
            implements Document<AdditionalUserInformation> {
                private String type;
                private DocNode config;

                public AdditionalUserInformation(String type) {
                    this.type = type;
                    this.config = null;
                }

                public AdditionalUserInformation(String type, DocNode config) {
                    this.type = type;
                    this.config = config;
                }

                public Object toBasicObject() {
                    return ImmutableMap.ofNonNull((Object)"type", (Object)this.type, (Object)this.type, (Object)this.config);
                }
            }
        }
    }

    public static class DlsFls
    extends ConfigDocument<DlsFls> {
        private Boolean debug;
        private String metrics;
        private Boolean dlsAllowNow;
        private String mode;
        private String fieldAnonymizationPrefix;

        public DlsFls metrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public DlsFls mode(String mode) {
            this.mode = mode;
            return this;
        }

        public DlsFls fieldAnonymizationPrefix(String prefix) {
            this.fieldAnonymizationPrefix = prefix;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"debug", (Object)this.debug, (Object)"metrics", (Object)this.metrics, (Object)"dls", (Object)ImmutableMap.ofNonNull((Object)"allow_now", (Object)this.dlsAllowNow, (Object)"mode", (Object)this.mode), (Object)"field_anonymization", (Object)ImmutableMap.ofNonNull((Object)"prefix", (Object)this.fieldAnonymizationPrefix));
        }

        @Override
        public String configType() {
            return "authz_dlsfls";
        }
    }

    public static class FrontendAuthc {
        private List<FrontendAuthDomain> authDomains = new ArrayList<FrontendAuthDomain>();
        private FrontendLoginPage loginPage;

        public FrontendAuthc authDomain(FrontendAuthDomain authDomain) {
            this.authDomains.add(authDomain);
            return this;
        }

        public FrontendAuthc loginPage(FrontendLoginPage loginPage) {
            this.loginPage = loginPage;
            return this;
        }

        NestedValueMap toMap() {
            NestedValueMap result = new NestedValueMap();
            result.put("auth_domains", (Object)this.authDomains.stream().map(FrontendAuthDomain::toMap).collect(Collectors.toList()));
            if (this.loginPage != null) {
                result.put("login_page", this.loginPage.toMap());
            }
            return result;
        }
    }

    public static class FrontendMultiTenancy {
        private boolean enabled;
        private String index;
        private String serverUser;
        private boolean globalTenantEnabled = true;
        private List<String> preferredTenants = new ArrayList<String>();

        public FrontendMultiTenancy(boolean enabled) {
            this.enabled = enabled;
        }

        public FrontendMultiTenancy index(String index) {
            this.index = index;
            return this;
        }

        public FrontendMultiTenancy serverUser(String serverUser) {
            this.serverUser = serverUser;
            return this;
        }

        public FrontendMultiTenancy globalTenantEnabled(boolean globalTenantEnabled) {
            this.globalTenantEnabled = globalTenantEnabled;
            return this;
        }

        public FrontendMultiTenancy preferredTenants(String ... preferredTenants) {
            this.preferredTenants.addAll(Arrays.asList(preferredTenants));
            return this;
        }

        NestedValueMap toJsonMap() {
            NestedValueMap result = new NestedValueMap();
            result.put("enabled", (Object)this.enabled);
            result.put("index", (Object)this.index);
            result.put("server_user", (Object)this.serverUser);
            result.put("global_tenant_enabled", (Object)this.globalTenantEnabled);
            result.put("preferred_tenants", (Object)this.preferredTenants);
            return NestedValueMap.of("default", (Object)result);
        }
    }

    public static class Tenant {
        private String name;
        private boolean reserved;
        private boolean hidden;
        private boolean isStatic;
        private String description;

        public Tenant(String name) {
            this.name = Objects.requireNonNull(name, "Name is required");
        }

        public Tenant reserved(boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        public Tenant hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Tenant isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        public Tenant description(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public NestedValueMap toJsonMap() {
            NestedValueMap map = new NestedValueMap();
            map.put(new NestedValueMap.Path(this.name, "reserved"), (Object)this.reserved);
            map.put(new NestedValueMap.Path(this.name, "hidden"), (Object)this.hidden);
            map.put(new NestedValueMap.Path(this.name, "static"), (Object)this.isStatic);
            map.put(new NestedValueMap.Path(this.name, "description"), (Object)this.description);
            return map;
        }
    }

    public static class User
    implements EsClientProvider.UserCredentialsHolder {
        private String name;
        private UserPassword password;
        private Role[] roles;
        private String[] roleNames;
        private String description;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private BiFunction<String, List<String>, Matcher<GenericRestClient.HttpResponse>> restMatcher;
        private Map<String, IndexApiMatchers.IndexMatcher> indexMatchers = new HashMap<String, IndexApiMatchers.IndexMatcher>();
        private Map<String, Matcher<GenericRestClient.HttpResponse>> documentFieldValueMatchers = new LinkedHashMap<String, Matcher<GenericRestClient.HttpResponse>>();
        private boolean adminCertUser = false;

        public User(String name) {
            this.name = name;
            this.password = UserPassword.of("secret");
        }

        public User description(String description) {
            this.description = description;
            return this;
        }

        public User password(String password) {
            this.password = UserPassword.of(password);
            return this;
        }

        public User passwordExpression(String passwordExpression) {
            this.password = UserPassword.fromExpression(passwordExpression);
            return this;
        }

        public User roles(Role ... roles) {
            this.roles = roles;
            return this;
        }

        public User roles(String ... roles) {
            this.roleNames = roles;
            return this;
        }

        public User attr(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public User restMatcher(BiFunction<String, List<String>, Matcher<GenericRestClient.HttpResponse>> restMatcher) {
            this.restMatcher = restMatcher;
            return this;
        }

        public Matcher<GenericRestClient.HttpResponse> restMatcher(String jsonPath, String ... params) {
            return this.restMatcher.apply(jsonPath, (List<String>)ImmutableList.ofArray((Object[])params));
        }

        public User indexMatcher(String key, IndexApiMatchers.IndexMatcher indexMatcher) {
            this.indexMatchers.put(key, indexMatcher);
            return this;
        }

        public IndexApiMatchers.IndexMatcher indexMatcher(String key) {
            IndexApiMatchers.IndexMatcher result = this.indexMatchers.get(key);
            if (result != null) {
                return result;
            }
            throw new RuntimeException("Unknown index matcher " + key + " in user " + this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPassword() {
            return this.password.loginPassword();
        }

        public Set<String> getRoleNames() {
            ImmutableSet result = ImmutableSet.empty();
            if (this.roleNames != null) {
                result = result.with((Object[])this.roleNames);
            }
            if (this.roles != null) {
                result = result.with((Collection)ImmutableSet.ofArray((Object[])this.roles).map(r -> r.name));
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isAdminCertUser() {
            return this.adminCertUser;
        }

        public User adminCertUser() {
            this.adminCertUser = true;
            return this;
        }

        public User addFieldValueMatcher(String fieldJsonPath, boolean multipleDocuments, Matcher<?> ... matchers) {
            Objects.requireNonNull(fieldJsonPath, "Document field JSON patch name must not be null");
            if (this.documentFieldValueMatchers.containsKey(fieldJsonPath)) {
                throw new IllegalArgumentException("Field matcher for " + fieldJsonPath + " already exists");
            }
            if (matchers == null || matchers.length == 0) {
                throw new IllegalArgumentException("At least one pattern must be provided");
            }
            Matcher[] everyFieldValueMatchers = (Matcher[])Arrays.stream(matchers).map(m -> multipleDocuments ? Matchers.everyItem((Matcher)m) : m).toArray(Matcher[]::new);
            DiagnosingMatcher<GenericRestClient.HttpResponse> fieldValueMatcher = RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt(fieldJsonPath, Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.emptyIterable()), (Matcher)Matchers.allOf((Matcher[])everyFieldValueMatchers)))});
            this.documentFieldValueMatchers.put(fieldJsonPath, (Matcher<GenericRestClient.HttpResponse>)fieldValueMatcher);
            return this;
        }

        public Matcher<GenericRestClient.HttpResponse> matcherForField(String fieldJsonPath) {
            Objects.requireNonNull(fieldJsonPath, "Field JSON path must not be null");
            Matcher<GenericRestClient.HttpResponse> matcher = this.documentFieldValueMatchers.get(fieldJsonPath);
            return Objects.requireNonNull(matcher, "No field matcher found for " + fieldJsonPath);
        }

        public String toString() {
            return "User name '" + this.name + "'";
        }
    }

    public static class UserPassword {
        private final String password;
        private final boolean passwordNeedsToBeHashed;

        private UserPassword(String password, boolean passwordNeedsToBeHashed) {
            this.password = Objects.requireNonNull(password, "Password is required");
            this.passwordNeedsToBeHashed = passwordNeedsToBeHashed;
        }

        public static UserPassword of(String password) {
            return new UserPassword(password, true);
        }

        public static UserPassword fromExpression(String expression) {
            return new UserPassword(expression, false);
        }

        String passwordValueForConfiguration() {
            if (this.passwordNeedsToBeHashed) {
                return TestSgConfig.hash(this.password.toCharArray());
            }
            return this.password;
        }

        String loginPassword() {
            if (this.passwordNeedsToBeHashed) {
                return this.password;
            }
            throw new IllegalStateException("Password expression was used, cannot retrieve password.");
        }
    }

    public static class Role
    implements Document<Role> {
        public static Role ALL_ACCESS = new Role("all_access").clusterPermissions("*").indexPermissions("*").on("*");
        private String name;
        private List<String> clusterPermissions = new ArrayList<String>();
        private List<String> excludedClusterPermissions = new ArrayList<String>();
        private List<IndexLikePermission> indexPermissions = new ArrayList<IndexLikePermission>();
        private List<IndexLikePermission> aliasPermissions = new ArrayList<IndexLikePermission>();
        private List<IndexLikePermission> dataStreamPermissions = new ArrayList<IndexLikePermission>();
        private List<TenantPermission> tenantPermissions = new ArrayList<TenantPermission>();

        public Role(String name) {
            this.name = name;
        }

        public Role tenantPermission(Collection<String> tenantPatterns, Collection<String> allowedActions) {
            this.tenantPermissions.add(new TenantPermission(new ArrayList<String>(tenantPatterns), new ArrayList<String>(allowedActions)));
            return this;
        }

        public Role tenantPermission(String tenantPattern, String ... allowedActions) {
            return this.tenantPermission(Collections.singletonList(tenantPattern), Arrays.asList(allowedActions));
        }

        public Role clusterPermissions(String ... clusterPermissions) {
            this.clusterPermissions.addAll(Arrays.asList(clusterPermissions));
            return this;
        }

        public Role excludeClusterPermissions(String ... clusterPermissions) {
            this.excludedClusterPermissions.addAll(Arrays.asList(clusterPermissions));
            return this;
        }

        public IndexLikePermission indexPermissions(String ... indexPermissions) {
            return new IndexLikePermission(this, this.indexPermissions, "index_patterns", indexPermissions);
        }

        public IndexLikePermission aliasPermissions(String ... aliasPermissions) {
            return new IndexLikePermission(this, this.aliasPermissions, "alias_patterns", aliasPermissions);
        }

        public IndexLikePermission dataStreamPermissions(String ... dataStreamPermissions) {
            return new IndexLikePermission(this, this.dataStreamPermissions, "data_stream_patterns", dataStreamPermissions);
        }

        public TenantPermission withTenantPermission(String ... tenantPermissions) {
            return new TenantPermission(this, tenantPermissions);
        }

        public String getName() {
            return this.name;
        }

        public NestedValueMap toJsonMap() {
            return this.toJsonMap("");
        }

        public NestedValueMap toJsonMap(String roleNamePrefix) {
            NestedValueMap map = new NestedValueMap();
            String name = roleNamePrefix + this.name;
            if (!this.clusterPermissions.isEmpty()) {
                map.put(new NestedValueMap.Path(name, "cluster_permissions"), (Object)this.clusterPermissions);
            }
            if (!this.indexPermissions.isEmpty()) {
                map.put(new NestedValueMap.Path(name, "index_permissions"), (Object)this.indexPermissions.stream().map(p -> p.toJsonMap()).collect(Collectors.toList()));
            }
            if (this.aliasPermissions.size() > 0) {
                map.put(new NestedValueMap.Path(name, "alias_permissions"), (Object)this.aliasPermissions.stream().map(p -> p.toJsonMap()).collect(Collectors.toList()));
            }
            if (this.dataStreamPermissions.size() > 0) {
                map.put(new NestedValueMap.Path(name, "data_stream_permissions"), (Object)this.dataStreamPermissions.stream().map(p -> p.toJsonMap()).collect(Collectors.toList()));
            }
            if (this.excludedClusterPermissions.size() > 0) {
                map.put(new NestedValueMap.Path(name, "exclude_cluster_permissions"), (Object)this.excludedClusterPermissions);
            }
            if (this.tenantPermissions.size() > 0) {
                map.put(new NestedValueMap.Path(name, "tenant_permissions"), (Object)this.tenantPermissions.stream().map(TenantPermission::asNestedValueMap).collect(Collectors.toList()));
            }
            return map;
        }

        public com.floragunn.searchguard.authz.config.Role toActualRole() throws ConfigValidationException {
            return this.toActualRole(new ConfigurationRepository.Context(null, null, null, null, null));
        }

        public com.floragunn.searchguard.authz.config.Role toActualRole(ConfigurationRepository.Context parserContext) throws ConfigValidationException {
            return (com.floragunn.searchguard.authz.config.Role)com.floragunn.searchguard.authz.config.Role.parse((DocNode)DocNode.wrap((Object)this.toDeepBasicObject()), (ConfigurationRepository.Context)parserContext).get();
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"cluster_permissions", this.clusterPermissions, (Object)"index_permissions", this.indexPermissions, (Object)"alias_permissions", this.aliasPermissions, (Object)"data_stream_permissions", this.dataStreamPermissions).with(ImmutableMap.ofNonNull((Object)"tenant_permissions", this.tenantPermissions, (Object)"exclude_cluster_permissions", this.excludedClusterPermissions));
        }

        public static SgDynamicConfiguration<com.floragunn.searchguard.authz.config.Role> toActualRole(ConfigurationRepository.Context parserContext, Role ... roles) throws ConfigValidationException {
            HashMap<String, com.floragunn.searchguard.authz.config.Role> parsedRoles = new HashMap<String, com.floragunn.searchguard.authz.config.Role>();
            for (Role role : roles) {
                parsedRoles.put(role.getName(), (com.floragunn.searchguard.authz.config.Role)com.floragunn.searchguard.authz.config.Role.parse((DocNode)DocNode.wrap((Object)role.toDeepBasicObject()), (ConfigurationRepository.Context)parserContext).get());
            }
            return SgDynamicConfiguration.of((CType)CType.ROLES, parsedRoles);
        }

        public static SgDynamicConfiguration<com.floragunn.searchguard.authz.config.Role> toActualRole(Role ... roles) throws ConfigValidationException {
            return Role.toActualRole(new ConfigurationRepository.Context(null, null, null, null, null), roles);
        }
    }

    public static class RoleMapping {
        private String name;
        private List<String> backendRoles = new ArrayList<String>();
        private List<String> users = new ArrayList<String>();
        private List<String> hosts = new ArrayList<String>();
        private List<String> ips = new ArrayList<String>();

        public RoleMapping(String name) {
            this.name = name;
        }

        public RoleMapping backendRoles(String ... backendRoles) {
            this.backendRoles.addAll(Arrays.asList(backendRoles));
            return this;
        }

        public RoleMapping users(String ... users) {
            this.users.addAll(Arrays.asList(users));
            return this;
        }

        public RoleMapping hosts(String ... hosts) {
            this.hosts.addAll(Arrays.asList(hosts));
            return this;
        }

        public RoleMapping ips(String ... ips) {
            this.ips.addAll(Arrays.asList(ips));
            return this;
        }

        public String getName() {
            return this.name;
        }

        public NestedValueMap toJsonMap() {
            NestedValueMap map = new NestedValueMap();
            String name = this.name;
            if (this.backendRoles.size() > 0) {
                map.put(new NestedValueMap.Path(name, "backend_roles"), (Object)this.backendRoles);
            }
            if (this.users.size() > 0) {
                map.put(new NestedValueMap.Path(name, "users"), (Object)this.users);
            }
            if (this.hosts.size() > 0) {
                map.put(new NestedValueMap.Path(name, "hosts"), (Object)this.hosts);
            }
            if (this.ips.size() > 0) {
                map.put(new NestedValueMap.Path(name, "ips"), (Object)this.ips);
            }
            return map;
        }
    }

    public static class AuthFailureListener {
        private final String id;
        private final String type;
        private int allowedTries;
        private int timeWindowSeconds = 3600;
        private int blockExpirySeconds = 600;

        public AuthFailureListener(String id, String type) {
            this.id = id;
            this.type = type;
            this.allowedTries = 3;
        }

        public AuthFailureListener(String id, String type, int allowedTries) {
            this.id = id;
            this.type = type;
            this.allowedTries = allowedTries;
        }

        NestedValueMap toMap() {
            NestedValueMap result = new NestedValueMap();
            result.put("type", (Object)this.type);
            result.put("allowed_tries", (Object)this.allowedTries);
            result.put("time_window_seconds", (Object)this.timeWindowSeconds);
            result.put("block_expiry_seconds", (Object)this.blockExpirySeconds);
            return NestedValueMap.of(this.id, (Object)result);
        }
    }

    public static class Authz
    extends ConfigDocument<Authz> {
        private boolean ignoreUnauthorizedIndices = true;
        private boolean debug = false;

        public boolean isIgnoreUnauthorizedIndices() {
            return this.ignoreUnauthorizedIndices;
        }

        public Authz ignoreUnauthorizedIndices(boolean ignoreUnauthorizedIndices) {
            this.ignoreUnauthorizedIndices = ignoreUnauthorizedIndices;
            return this;
        }

        public Authz debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)"ignore_unauthorized_indices.enabled", (Object)this.ignoreUnauthorizedIndices, (Object)"debug", (Object)this.debug);
        }

        @Override
        public String configType() {
            return "authz";
        }
    }

    public static class Sessions
    extends ConfigDocument<Sessions> {
        private Duration inactivityTimeout;
        private Boolean refreshSessionActivityIndex;
        private String jwtSigningKeyHs512;
        private String jwtAudience;

        public Sessions inactivityTimeout(Duration inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Sessions refreshSessionActivityIndex(boolean refreshSessionActivityIndex) {
            this.refreshSessionActivityIndex = refreshSessionActivityIndex;
            return this;
        }

        public Sessions jwtSigningKeyHs512(String jwtSigningKeyHs512) {
            this.jwtSigningKeyHs512 = jwtSigningKeyHs512;
            return this;
        }

        public Sessions jwtAudience(String jwtAudience) {
            this.jwtAudience = jwtAudience;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"inactivity_timeout", (Object)(this.inactivityTimeout != null ? DurationFormat.INSTANCE.format(this.inactivityTimeout) : null), (Object)"refresh_session_activity_index", (Object)this.refreshSessionActivityIndex, (Object)"jwt_signing_key_hs512", (Object)this.jwtSigningKeyHs512, (Object)"jwt_audience", (Object)this.jwtAudience);
        }

        @Override
        public String configType() {
            return "sessions";
        }
    }

    public static class AuthTokenService
    extends ConfigDocument<AuthTokenService> {
        private Boolean enabled;
        private String metrics;
        private String jwtSigningKeyHs512;

        public AuthTokenService enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AuthTokenService metrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public AuthTokenService jwtSigningKeyHs512(String jwtSigningKeyHs512) {
            this.jwtSigningKeyHs512 = jwtSigningKeyHs512;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"enabled", (Object)this.enabled, (Object)"metrics", (Object)this.metrics, (Object)"jwt_signing_key_hs512", (Object)this.jwtSigningKeyHs512);
        }

        @Override
        public String configType() {
            return "auth_token_service";
        }
    }

    public static abstract class ConfigDocument<C>
    implements Document<C> {
        public abstract String configType();

        public static DocNode bulkUpdateMap(ConfigDocument<?> ... configDocuments) {
            DocNode result = DocNode.EMPTY;
            for (ConfigDocument<?> configDocument : configDocuments) {
                if (configDocument == null) continue;
                result = result.with(configDocument.configType(), (Object)DocNode.of((String)"content", (Object)configDocument.toDeepBasicObject()));
            }
            return result;
        }
    }

    public static class JsonWebKey
    implements Document<JsonWebKey> {
        private String kty;
        private String kid;
        private String d;
        private String use;
        private String crv;
        private String x;
        private String y;
        private String alg;
        private String k;

        public JsonWebKey kty(String kty) {
            this.kty = kty;
            return this;
        }

        public JsonWebKey kid(String kid) {
            this.kid = kid;
            return this;
        }

        public JsonWebKey d(String d) {
            this.d = d;
            return this;
        }

        public JsonWebKey use(String use) {
            this.use = use;
            return this;
        }

        public JsonWebKey crv(String crv) {
            this.crv = crv;
            return this;
        }

        public JsonWebKey x(String x) {
            this.x = x;
            return this;
        }

        public JsonWebKey y(String y) {
            this.y = y;
            return this;
        }

        public JsonWebKey alg(String alg) {
            this.alg = alg;
            return this;
        }

        public JsonWebKey k(String k) {
            this.k = k;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"kty", (Object)this.kty, (Object)"d", (Object)this.d, (Object)"use", (Object)this.use, (Object)"crv", (Object)this.crv, (Object)"x", (Object)this.x).with(ImmutableMap.ofNonNull((Object)"y", (Object)this.y, (Object)"alg", (Object)this.alg)).with(ImmutableMap.of((Object)"kid", (Object)this.kid, (Object)"k", (Object)this.k));
        }
    }

    public static class Jwks
    implements Document<JsonWebKey> {
        private List<JsonWebKey> keys = new ArrayList<JsonWebKey>();

        public Jwks keys(List<JsonWebKey> keys) {
            this.keys = keys;
            return this;
        }

        public Jwks addKey(JsonWebKey jsonWebKey) {
            Objects.requireNonNull(jsonWebKey, "Json web key is required");
            this.keys.add(jsonWebKey);
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)"keys", this.keys);
        }
    }

    public static class Signing
    implements Document<JsonWebKey> {
        private Jwks jwks;

        public Signing jwks(Jwks jwks) {
            this.jwks = jwks;
            return this;
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)"jwks", (Object)this.jwks.toBasicObject());
        }
    }

    public static class JwtDomain
    implements Document<JsonWebKey> {
        private Signing signing;

        public JwtDomain signing(Signing signing) {
            this.signing = signing;
            return this;
        }

        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            if (this.signing != null) {
                result.put("signing", this.signing.toBasicObject());
            }
            return result;
        }
    }

    public static class FrontendLoginPage {
        private String brandImage;

        public FrontendLoginPage brandImage(String brandImage) {
            this.brandImage = brandImage;
            return this;
        }

        NestedValueMap toMap() {
            NestedValueMap result = new NestedValueMap();
            if (this.brandImage != null) {
                result.put("brand_image", (Object)this.brandImage);
            }
            return result;
        }
    }

    public static class FrontendAuthDomain {
        private final String type;
        private String label;
        private NestedValueMap moreProperties = new NestedValueMap();

        public FrontendAuthDomain(String type) {
            this.type = type;
        }

        public FrontendAuthDomain label(String label) {
            this.label = label;
            return this;
        }

        public FrontendAuthDomain config(String key, Object value) {
            this.moreProperties.put(NestedValueMap.Path.parse(key), value);
            return this;
        }

        public FrontendAuthDomain config(String key, Object value, Object ... kvPairs) {
            this.moreProperties.put(NestedValueMap.Path.parse(key), value);
            if (kvPairs != null && kvPairs.length >= 2) {
                for (int i = 0; i < kvPairs.length; i += 2) {
                    this.moreProperties.put(NestedValueMap.Path.parse(String.valueOf(kvPairs[i])), kvPairs[i + 1]);
                }
            }
            return this;
        }

        NestedValueMap toMap() {
            NestedValueMap result = this.moreProperties.clone();
            result.put("type", (Object)this.type);
            result.put("label", (Object)this.label);
            return result;
        }
    }

    public static class IndexLikePermission
    implements Document<IndexLikePermission> {
        private List<String> allowedActions;
        private List<String> indexPatterns;
        private Role role;
        private String dlsQuery;
        private List<String> fls;
        private List<String> maskedFields;
        private List<IndexLikePermission> targetList;
        private String patternAttributeName;

        IndexLikePermission(Role role, List<IndexLikePermission> targetList, String patternAttributeName, String ... allowedActions) {
            this.allowedActions = Arrays.asList(allowedActions);
            this.role = role;
            this.targetList = targetList;
            this.patternAttributeName = patternAttributeName;
        }

        public IndexLikePermission dls(String dlsQuery) {
            this.dlsQuery = dlsQuery;
            return this;
        }

        public IndexLikePermission dls(Map<String, Object> dlsQuery) {
            this.dlsQuery = DocWriter.json().writeAsString(dlsQuery);
            return this;
        }

        public IndexLikePermission fls(String ... fls) {
            this.fls = Arrays.asList(fls);
            return this;
        }

        public IndexLikePermission maskedFields(String ... maskedFields) {
            this.maskedFields = Arrays.asList(maskedFields);
            return this;
        }

        public Role on(String ... indexPatterns) {
            this.indexPatterns = Arrays.asList(indexPatterns);
            this.targetList.add(this);
            return this.role;
        }

        public NestedValueMap toJsonMap() {
            NestedValueMap result = new NestedValueMap();
            result.put(this.patternAttributeName, (Object)this.indexPatterns);
            result.put("allowed_actions", (Object)this.allowedActions);
            if (this.dlsQuery != null) {
                result.put("dls", (Object)this.dlsQuery);
            }
            if (this.fls != null) {
                result.put("fls", (Object)this.fls);
            }
            if (this.maskedFields != null) {
                result.put("masked_fields", (Object)this.maskedFields);
            }
            return result;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)this.patternAttributeName, this.indexPatterns, (Object)"allowed_actions", this.allowedActions, (Object)"dls", (Object)this.dlsQuery, (Object)"fls", this.fls, (Object)"masked_fields", this.maskedFields);
        }
    }

    public static class TenantPermission
    implements Document<TenantPermission> {
        private List<String> tenantPatterns;
        private final List<String> allowedActions;
        private Role role;

        TenantPermission(Role role, String ... allowedActions) {
            this.tenantPatterns = ImmutableList.empty();
            this.allowedActions = Arrays.asList(allowedActions);
            this.role = role;
        }

        public TenantPermission(List<String> tenantPatterns, List<String> allowedActions) {
            this.tenantPatterns = Objects.requireNonNull(tenantPatterns, "Tenant patterns must not be null");
            this.allowedActions = Objects.requireNonNull(allowedActions, "Tenant allowed actions must not be null");
        }

        public Role on(String ... tenantPatterns) {
            this.tenantPatterns = Arrays.asList(tenantPatterns);
            this.role.tenantPermissions.add(this);
            return this.role;
        }

        NestedValueMap asNestedValueMap() {
            return NestedValueMap.of("tenant_patterns", this.tenantPatterns, "allowed_actions", this.allowedActions);
        }

        public Object toBasicObject() {
            return DocNode.of((String)"tenant_patterns", this.tenantPatterns, (String)"allowed_actions", this.allowedActions);
        }
    }
}

