/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.blocking;

import com.floragunn.searchguard.authc.blocking.Blocks;
import com.floragunn.searchguard.authc.blocking.ClientBlockRegistry;
import com.floragunn.searchguard.authc.blocking.IpRangeVerdictBasedBlockRegistry;
import com.floragunn.searchguard.authc.blocking.VerdictBasedBlockRegistry;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.google.common.collect.ImmutableList;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;

public class BlockedIpRegistry {
    protected static final Logger log = LogManager.getLogger(BlockedIpRegistry.class);
    private volatile List<ClientBlockRegistry<IPAddress>> blockedNetmasks;
    private volatile List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;

    public BlockedIpRegistry(ConfigurationRepository configurationRepository) {
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<Blocks> blocks = configMap.get(CType.BLOCKS);
                if (blocks != null) {
                    BlockedIpRegistry.this.blockedNetmasks = ImmutableList.of(BlockedIpRegistry.this.reloadBlockedNetmasks(blocks));
                    BlockedIpRegistry.this.ipClientBlockRegistries = ImmutableList.of(BlockedIpRegistry.this.reloadBlockedIpAddresses(blocks));
                    if (log.isDebugEnabled()) {
                        log.debug("Updated confiuration: " + String.valueOf(blocks) + "\nBlockedNetmasks: " + String.valueOf(BlockedIpRegistry.this.blockedNetmasks) + "; ips: " + String.valueOf(BlockedIpRegistry.this.ipClientBlockRegistries));
                    }
                }
            }
        });
    }

    public boolean isIpBlocked(IPAddress address) {
        if (address == null) {
            return false;
        }
        if ((this.ipClientBlockRegistries == null || this.ipClientBlockRegistries.isEmpty()) && (this.blockedNetmasks == null || this.blockedNetmasks.isEmpty())) {
            return false;
        }
        InetAddress inetAddress = address.toInetAddress();
        if (this.ipClientBlockRegistries != null) {
            for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.ipClientBlockRegistries) {
                if (!clientBlockRegistry.isBlocked(inetAddress)) continue;
                return true;
            }
        }
        if (this.blockedNetmasks != null) {
            for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.blockedNetmasks) {
                if (!clientBlockRegistry.isBlocked((InetAddress)address)) continue;
                return true;
            }
        }
        return false;
    }

    private ClientBlockRegistry<IPAddress> reloadBlockedNetmasks(SgDynamicConfiguration<Blocks> blocks) {
        Function<String, Optional> parsedIp = s -> {
            IPAddressString ipAddressString = new IPAddressString(s);
            try {
                ipAddressString.validate();
                return Optional.of(ipAddressString.toAddress());
            }
            catch (AddressStringException e) {
                log.error("Reloading blocked IP addresses failed ", (Throwable)e);
                return Optional.empty();
            }
        };
        Tuple<Set<String>, Set<String>> b = this.readBlocks(blocks, Blocks.Type.net_mask);
        Set<IPAddress> allows = ((Set)b.v1()).stream().map(parsedIp).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
        Set<IPAddress> disallows = ((Set)b.v2()).stream().map(parsedIp).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
        return new IpRangeVerdictBasedBlockRegistry(allows, disallows);
    }

    private ClientBlockRegistry<InetAddress> reloadBlockedIpAddresses(SgDynamicConfiguration<Blocks> blocks) {
        Function<String, Optional> parsedIp = s -> {
            try {
                return Optional.of(InetAddress.getByName(s));
            }
            catch (UnknownHostException e) {
                log.error("Reloading blocked IP addresses failed", (Throwable)e);
                return Optional.empty();
            }
        };
        Tuple<Set<String>, Set<String>> b = this.readBlocks(blocks, Blocks.Type.ip);
        Set allows = ((Set)b.v1()).stream().map(parsedIp).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
        Set disallows = ((Set)b.v2()).stream().map(parsedIp).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
        return new VerdictBasedBlockRegistry<InetAddress>(InetAddress.class, allows, disallows);
    }

    private Tuple<Set<String>, Set<String>> readBlocks(SgDynamicConfiguration<Blocks> blocks, Blocks.Type type) {
        HashSet<String> allows = new HashSet<String>();
        HashSet<String> disallows = new HashSet<String>();
        List blocksV7s = blocks.getCEntries().values().stream().filter(b -> b.getType() == type).collect(Collectors.toList());
        for (Blocks blocksV7 : blocksV7s) {
            if (blocksV7.getVerdict() == null) {
                log.error("No verdict type found in blocks");
                continue;
            }
            if (blocksV7.getVerdict() == Blocks.Verdict.disallow) {
                disallows.addAll((Collection<String>)blocksV7.getValue());
                continue;
            }
            if (blocksV7.getVerdict() == Blocks.Verdict.allow) {
                allows.addAll((Collection<String>)blocksV7.getValue());
                continue;
            }
            log.error("Found unknown verdict type: " + String.valueOf((Object)blocksV7.getVerdict()));
        }
        return new Tuple(allows, disallows);
    }
}

