/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchsupport.rest.AttributedHttpRequest;
import io.netty.handler.ssl.SslHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardHttpServerTransport
extends SearchGuardSSLNettyHttpServerTransport {
    private static final Logger log = LogManager.getLogger(SearchGuardHttpServerTransport.class);

    public SearchGuardHttpServerTransport(Settings settings, NetworkService networkService, ThreadPool threadPool, SearchGuardKeyStore sgks, SslExceptionHandler sslExceptionHandler, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer, BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext) {
        super(settings, networkService, threadPool, sgks, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, sslExceptionHandler, tracer, perRequestThreadContext);
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        SslHandler sslhandler = (SslHandler)((Netty4HttpChannel)httpChannel).getNettyChannel().pipeline().get("ssl_http");
        ImmutableMap attributes = ImmutableMap.of((Object)"sg_ssl_handler", (Object)sslhandler);
        HttpRequest fixedRequest = this.fixNonStandardContentType(httpRequest);
        super.incomingRequest((HttpRequest)AttributedHttpRequest.create((HttpRequest)fixedRequest, (ImmutableMap)attributes), httpChannel);
    }

    private HttpRequest fixNonStandardContentType(final HttpRequest httpRequest) {
        try {
            if (SearchGuardHttpServerTransport.hasEmptyBody(httpRequest)) {
                return httpRequest;
            }
            Map headers = httpRequest.getHeaders();
            List contentTypeHeader = (List)headers.get("Content-Type");
            if (contentTypeHeader == null || contentTypeHeader.size() != 1) {
                return httpRequest;
            }
            if (RestRequest.parseContentType((List)contentTypeHeader) != null) {
                return httpRequest;
            }
            ContentType contentType = ContentType.parseHeader((String)((String)contentTypeHeader.get(0)));
            ImmutableMap modifiedHeaders = ImmutableMap.of((Map)headers, (Object)"Content-Type", Collections.singletonList(contentType.getFormat().getMediaType()), (Object)"X-SG-Original-Content-Type", (Object)contentTypeHeader);
            return new HttpRequest(){
                final /* synthetic */ Map val$modifiedHeaders;
                {
                    this.val$modifiedHeaders = map;
                }

                public String uri() {
                    return httpRequest.uri();
                }

                public HttpBody body() {
                    return httpRequest.body();
                }

                public List<String> strictCookies() {
                    return httpRequest.strictCookies();
                }

                public HttpRequest removeHeader(String header) {
                    return httpRequest.removeHeader(header);
                }

                public void release() {
                    httpRequest.release();
                }

                public HttpRequest.HttpVersion protocolVersion() {
                    return httpRequest.protocolVersion();
                }

                public RestRequest.Method method() {
                    return httpRequest.method();
                }

                public Exception getInboundException() {
                    return httpRequest.getInboundException();
                }

                public Map<String, List<String>> getHeaders() {
                    return this.val$modifiedHeaders;
                }

                public HttpResponse createResponse(RestStatus status, BytesReference content) {
                    return httpRequest.createResponse(status, content);
                }

                public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart content) {
                    return httpRequest.createResponse(status, content);
                }
            };
        }
        catch (Format.UnknownDocTypeException e) {
            log.debug("Unknown content type", (Throwable)e);
            return httpRequest;
        }
        catch (Exception e) {
            log.error("Error in fixNonStandardContentType(" + String.valueOf(httpRequest) + ")", (Throwable)e);
            return httpRequest;
        }
    }

    static boolean hasEmptyBody(HttpRequest httpRequest) {
        if (httpRequest.body() == null) {
            return true;
        }
        if (httpRequest.body().isFull()) {
            HttpBody.Full full = httpRequest.body().asFull();
            return full.bytes() == null || full.bytes().length() == 0;
        }
        return false;
    }
}

