/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.ssl.http.AttributedHttpRequest;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.SslHandler;
import java.util.function.BiConsumer;
import org.elasticsearch.action.bulk.IncrementalBulkService;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.transport.netty4.TLSConfig;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardNonSslHttpServerTransport
extends Netty4HttpServerTransport {
    private final BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext;
    private final IncrementalBulkService.Enabled incremantalBulkServiceEnabled;

    public SearchGuardNonSslHttpServerTransport(Settings settings, NetworkService networkService, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer) {
        super(settings, networkService, threadPool, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, tracer, TLSConfig.noTLS(), null, null);
        this.perRequestThreadContext = perRequestThreadContext;
        this.incremantalBulkServiceEnabled = new IncrementalBulkService.Enabled(clusterSettings);
    }

    protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
        this.perRequestThreadContext.accept((HttpPreRequest)restRequest.getHttpRequest(), threadContext);
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        Channel nettyChannel = ((Netty4HttpChannel)httpChannel).getNettyChannel();
        SslHandler sslhandler = (SslHandler)nettyChannel.pipeline().get("ssl_http");
        super.incomingRequest((HttpRequest)AttributedHttpRequest.create((HttpRequest)httpRequest, (SslHandler)sslhandler, (EventLoop)nettyChannel.eventLoop()), httpChannel);
    }

    public ChannelHandler configureServerChannelHandler() {
        return new NonSslHttpChannelHandler(this, this.handlingSettings);
    }

    protected class NonSslHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected NonSslHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            super(transport, handlingSettings, TLSConfig.noTLS(), null, null, SearchGuardNonSslHttpServerTransport.this.incremantalBulkServiceEnabled);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
        }
    }
}

